//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
#define macroRandom (rand() / (double)SHORT_MAX)
#define macroSigmoid(a) (1.0 / (1 + MathExp(-a)))
//+------------------------------------------------------------------+
#define def_Fast
//+------------------------------------------------------------------+
double  _NOR[][3] {
                    {0, 0, 1},
                    {0, 1, 0},
                    {1, 0, 0},
                    {1, 1, 0},
                  };
double  _AND[][3] {
                    {0, 0, 0},
                    {0, 1, 0},
                    {1, 0, 0},
                    {1, 1, 1},
                  };
struct st_XOR
{
    double Nor_w0, Nor_w1, Nor_bias, Nor_Err,
           And_w0, And_w1, And_bias, And_Err;
}_XOR;
//+------------------------------------------------------------------+
const uint nTrain = _NOR.Size() / 3;
const double eps = 1e-3;
//+------------------------------------------------------------------+
double Cost(const double w0, const double w1, const double b, const double &Train[][])
{
    double err;

    err = 0;
    for (uint c = 0; c < nTrain; c++)
        err += MathPow((macroSigmoid((Train[c][0] * w0) + (Train[c][1] * w1) + b) - Train[c][2]), 2);

    return err / nTrain;
}
//+------------------------------------------------------------------+
void OnStart()
{
    double ew0, ew1, eb;
    ulong count, it0, it1;

    Print("The Neuron - Tutor...");
    MathSrand(512);
    
    _XOR.Nor_w0 = (double)macroRandom;
    _XOR.Nor_w1 = (double)macroRandom;
    _XOR.Nor_bias = (double)macroRandom;

    _XOR.And_w0 = (double)macroRandom;
    _XOR.And_w1 = (double)macroRandom;
    _XOR.And_bias = (double)macroRandom;

    it0 = GetTickCount();

    for (count = 0; count < ULONG_MAX; count++)
    {
        _XOR.Nor_Err = Cost(_XOR.Nor_w0, _XOR.Nor_w1, _XOR.Nor_bias, _NOR);
        _XOR.And_Err = Cost(_XOR.And_w0, _XOR.And_w1, _XOR.And_bias, _AND);

        if ((_XOR.Nor_Err < eps) && (_XOR.And_Err < eps))
            break;

        ew0 = ((Cost(_XOR.Nor_w0 + eps, _XOR.Nor_w1, _XOR.Nor_bias, _NOR) - _XOR.Nor_Err) / eps);
        ew1 = ((Cost(_XOR.Nor_w0, _XOR.Nor_w1 + eps, _XOR.Nor_bias, _NOR) - _XOR.Nor_Err) / eps);
        eb  = ((Cost(_XOR.Nor_w0, _XOR.Nor_w1, _XOR.Nor_bias + eps, _NOR) - _XOR.Nor_Err) / eps);

        _XOR.Nor_w0 -= (ew0 * eps);
        _XOR.Nor_w1 -= (ew1 * eps);
        _XOR.Nor_bias -= (eb * eps);

        ew0 = ((Cost(_XOR.And_w0 + eps, _XOR.And_w1, _XOR.And_bias, _AND) - _XOR.And_Err) / eps);
        ew1 = ((Cost(_XOR.And_w0, _XOR.And_w1 + eps, _XOR.And_bias, _AND) - _XOR.And_Err) / eps);
        eb  = ((Cost(_XOR.And_w0, _XOR.And_w1, _XOR.And_bias + eps, _AND) - _XOR.And_Err) / eps);

        _XOR.And_w0 -= (ew0 * eps);
        _XOR.And_w1 -= (ew1 * eps);
        _XOR.And_bias -= (eb * eps);
    }

    it1 = GetTickCount();
    Print("Time: ", (it1 - it0) / 1000.0, " seconds.");
    PrintFormat("Interactions: %I64u", count);
    Print("NOR port information:");
    Print("w0: ", _XOR.Nor_w0, " w1: ", _XOR.Nor_w1, " bias: ", _XOR.Nor_bias, " Error: ", _XOR.Nor_Err);
    Print("AND port information:");
    Print("w0: ", _XOR.And_w0, " w1: ", _XOR.And_w1, " bias: ", _XOR.And_bias, " Error: ", _XOR.And_Err);

    Print("Testing the neuron...");
    for (uchar p0 = 0; p0 < 2; p0++)
        for (uchar p1 = 0; p1 < 2; p1++)
            PrintFormat("%d XOR %d IS %f", p0, p1, macroSigmoid((_XOR.Nor_w0 * macroSigmoid((p0 * _XOR.Nor_w0) + (p1 * _XOR.Nor_w1) + _XOR.Nor_bias)) + 
                                                                (_XOR.Nor_w1 * macroSigmoid((p0 * _XOR.And_w0) + (p1 * _XOR.And_w1) + _XOR.And_bias)) + _XOR.Nor_bias));


    Print("************************************");
}
//+------------------------------------------------------------------+