//+------------------------------------------------------------------+
//|                                                       EA TIM.mq5 |
//|                                                      Aleksej1966 |
//|                        https://www.mql5.com/ru/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "Aleksej1966"
#property link      "https://www.mql5.com/ru/users/aleksej1966"
#property version   "1.00"

input ushort Seed=0,
             DurationTP=5,
             ShiftSL=3;

int DurationSL,buy_sl[],buy_tp[],sell_sl[],sell_tp[];
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//---
   if(Seed>0)
      MathSrand(Seed);
   else
      MathSrand(GetTickCount());

   DurationSL=DurationTP+ShiftSL;

   ArrayResize(buy_sl,0,1);
   ArrayResize(buy_tp,0,1);
   ArrayResize(sell_sl,0,1);
   ArrayResize(sell_tp,0,1);

   for(int i=iBars(_Symbol,PERIOD_CURRENT)-1; i>=DurationTP; i--)
     {
      double open=iOpen(_Symbol,PERIOD_CURRENT,i),max=open,min=open;

      for(int j=0; j<DurationTP; j++)
        {
         int p=i-j;
         max=MathMax(max,iHigh(_Symbol,PERIOD_CURRENT,p));
         min=MathMin(min,iLow(_Symbol,PERIOD_CURRENT,p));
        }
      CalcLvl(buy_tp,(int)MathRound((max-open)/_Point));
      CalcLvl(sell_tp,(int)MathRound((open-min)/_Point));

      if(i>=DurationSL)
        {
         for(int j=DurationTP; j<DurationSL; j++)
           {
            int p=i-j;
            max=MathMax(max,iHigh(_Symbol,PERIOD_CURRENT,p));
            min=MathMin(min,iLow(_Symbol,PERIOD_CURRENT,p));
           }
         CalcLvl(buy_sl,(int)MathRound((open-min)/_Point));
         CalcLvl(sell_sl,(int)MathRound((max-open)/_Point));
        }
     }
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//---
//---
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//---
   if(NewBar()==true)
     {
      double open=iOpen(_Symbol,PERIOD_CURRENT,DurationTP),max=open,min=open;

      for(int j=0; j<DurationTP; j++)
        {
         int p=DurationTP-j;
         max=MathMax(max,iHigh(_Symbol,PERIOD_CURRENT,p));
         min=MathMin(min,iLow(_Symbol,PERIOD_CURRENT,p));
        }
      CalcLvl(buy_tp,(int)MathRound((max-open)/_Point));
      CalcLvl(sell_tp,(int)MathRound((open-min)/_Point));

      open=iOpen(_Symbol,PERIOD_CURRENT,DurationSL);
      max=open;
      min=open;
      for(int j=0; j<DurationSL; j++)
        {
         int p=DurationSL-j;
         max=MathMax(max,iHigh(_Symbol,PERIOD_CURRENT,p));
         min=MathMin(min,iLow(_Symbol,PERIOD_CURRENT,p));
        }
      CalcLvl(buy_sl,(int)MathRound((open-min)/_Point));
      CalcLvl(sell_sl,(int)MathRound((max-open)/_Point));

      PutPosition((uchar)MathMod(MathRand(),2));
     }
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void CalcLvl(int &array[],int value)
  {
//---
   int s=ArraySize(array);
   if(s>value)
      array[value]++;
   else
     {
      int a[];
      ArrayResize(a,value+1);
      ArrayInitialize(a,0);
      for(int i=0; i<s; i++)
         a[i]=array[i];
      a[value]=value;
      ArrayCopy(array,a);
     }
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int CalcSL(int &array[])
  {
//---
   int a[],s=ArrayCopy(a,array),sl=0;
   ulong max=0;

   for(int i=s-2; i>=0; i--)
      a[i]=a[i]+a[i+1];

   for(int i=0; i<s; i++)
     {
      ulong res=(s-i)*(a[0]-a[i]);
      if(max<res)
        {
         max=res;
         sl=i;
        }
     }
   return(sl);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int CalcTP(int &array[])
  {
//---
   int a[],s=ArrayCopy(a,array),tp=0;
   ulong max=0;

   for(int i=s-2; i>=0; i--)
      a[i]=a[i]+a[i+1];

   for(int i=0; i<s; i++)
     {
      ulong res=i*a[i];
      if(max<res)
        {
         max=res;
         tp=i;
        }
     }
   return(tp);
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void PutPosition(uchar t)
  {
//---
   ENUM_ORDER_TYPE type= t==0? ORDER_TYPE_BUY:ORDER_TYPE_SELL;

   long lvl=SymbolInfoInteger(_Symbol,SYMBOL_TRADE_STOPS_LEVEL),
        spread=SymbolInfoInteger(_Symbol,SYMBOL_SPREAD);

   double sl=0,tp=0,margin,
          lot=SymbolInfoDouble(_Symbol,SYMBOL_VOLUME_MIN),
          price= t==0? SymbolInfoDouble(_Symbol,SYMBOL_ASK):SymbolInfoDouble(_Symbol,SYMBOL_BID);

   if(OrderCalcMargin(type,_Symbol,lot,price,margin)==false)
      return;

   if(margin>=AccountInfoDouble(ACCOUNT_MARGIN_FREE))
     {
      Print("Not enough money!");
      return;
     }

   if(t==0)
     {
      tp=price+MathMax(lvl,CalcTP(buy_tp))*_Point;
      sl=price-MathMax(lvl+spread,CalcSL(buy_sl))*_Point;
     }
   else
     {
      tp=price-MathMax(lvl,CalcTP(sell_tp))*_Point;
      sl=price+MathMax(lvl+spread,CalcSL(sell_sl))*_Point;
     }

   MqlTradeRequest request= {};
   MqlTradeResult result= {};
   request.action=TRADE_ACTION_DEAL;
   request.symbol=_Symbol;
   request.volume=lot;
   request.price=price;
   request.sl=NormalizeDouble(sl,_Digits);
   request.tp=NormalizeDouble(tp,_Digits);
   request.deviation=5;
   request.type=type;
   if(OrderSend(request,result)==false)
      Print("OrderSend error #",GetLastError());
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool NewBar()
  {
//---
   static long last_bar;
   long cur_bar=SeriesInfoInteger(_Symbol,PERIOD_CURRENT,SERIES_LASTBAR_DATE);

   if(last_bar<cur_bar)
     {
      last_bar=cur_bar;
      return(true);
     }

   return(false);
//---
  }
//+------------------------------------------------------------------+
