//+------------------------------------------------------------------+
//|                                                     EA SL&TP.mq5 |
//|                                                      Aleksej1966 |
//|                        https://www.mql5.com/ru/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "Aleksej1966"
#property link      "https://www.mql5.com/ru/users/aleksej1966"
#property version   "1.00"

input ushort Seed=0,
             SLBuy=622,
             TPBuy=210,
             SLSell=603,
             TPSell=220;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//---
   if(Seed>0)
      MathSrand(Seed);
   else
      MathSrand(GetTickCount());
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//---
//---
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//---
   if(NewBar()==true && PositionsTotal()==0)
      PutPosition((uchar)MathMod(MathRand(),2));
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void PutPosition(uchar t)
  {
//---
   ENUM_ORDER_TYPE type= t==0? ORDER_TYPE_BUY:ORDER_TYPE_SELL;

   long lvl=SymbolInfoInteger(_Symbol,SYMBOL_TRADE_STOPS_LEVEL),
        spread=SymbolInfoInteger(_Symbol,SYMBOL_SPREAD);

   double sl=0,tp=0,margin,
          lot=SymbolInfoDouble(_Symbol,SYMBOL_VOLUME_MIN),
          price= t==0? SymbolInfoDouble(_Symbol,SYMBOL_ASK):SymbolInfoDouble(_Symbol,SYMBOL_BID);

   if(OrderCalcMargin(type,_Symbol,lot,price,margin)==false)
      return;

   if(margin>=AccountInfoDouble(ACCOUNT_MARGIN_FREE))
     {
      Print("Not enough money!");
      return;
     }

   if(t==0)
     {
      tp=price+MathMax(lvl,TPBuy)*_Point;
      sl=price-MathMax(lvl+spread,SLBuy)*_Point;
     }
   else
     {
      tp=price-MathMax(lvl,TPSell)*_Point;
      sl=price+MathMax(lvl+spread,SLSell)*_Point;
     }

   MqlTradeRequest request= {};
   MqlTradeResult result= {};
   request.action=TRADE_ACTION_DEAL;
   request.symbol=_Symbol;
   request.volume=lot;
   request.price=price;
   request.sl=NormalizeDouble(sl,_Digits);
   request.tp=NormalizeDouble(tp,_Digits);
   request.deviation=5;
   request.type=type;
   if(OrderSend(request,result)==false)
      Print("OrderSend error #",GetLastError());
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool NewBar()
  {
//---
   static long last_bar;
   long cur_bar=SeriesInfoInteger(_Symbol,PERIOD_CURRENT,SERIES_LASTBAR_DATE);

   if(last_bar<cur_bar)
     {
      last_bar=cur_bar;
      return(true);
     }

   return(false);
//---
  }
//+------------------------------------------------------------------+
