import pandas as pd
from transformers import GPT2LMHeadModel, GPT2Tokenizer, GPT2Config
from sklearn.metrics import mean_squared_error
import torch
import numpy as np

df = pd.read_csv('llm_data.csv')
dvc='cuda' if torch.cuda.is_available() else 'cpu'

model = GPT2LMHeadModel.from_pretrained('./gpt2_stock')
tokenizer = GPT2Tokenizer.from_pretrained('gpt2')

prompt = ' '.join(map(str, df.iloc[:,1:20].values[-1]))
generated = tokenizer.decode(model.generate(tokenizer.encode(prompt, return_tensors='pt'), do_sample=True, max_length=200)[0], skip_special_tokens=True)
true_prices= df.iloc[-1:,21:].values.tolist()[0]
generated_prices=generated.split('\n')[0]
generated_prices=list(map(float,generated_prices.split()))
generated_prices=generated_prices[0:len(true_prices)]
def trim_lists(a, b):
    min_len = min(len(a), len(b))
    return a[:min_len], b[:min_len]
true_prices,generated_prices=trim_lists(true_prices,generated_prices)
print(f"true_prices:{true_prices}")
print(f"generated_prices:{generated_prices}")
mse = mean_squared_error(true_prices, generated_prices)
print('MSE:', mse)
rmse=np.sqrt(mse)
nrmse=rmse/(np.max(true_prices)-np.min(generated_prices))
print(f"RMSE:{rmse},NRMSE:{nrmse}")

