//+------------------------------------------------------------------+
//|                                               GetDataforONNX.mq5 |
//|                                     Copyright 2023, Omega Joctan |
//|                        https://www.mql5.com/en/users/omegajoctan |
//+------------------------------------------------------------------+
#property copyright "Copyright 2023, Omega Joctan"
#property link      "https://www.mql5.com/en/users/omegajoctan"
#property version   "1.00"
#property description "These inputs needs to have the same values as those of an EA named svm test"
#property script_show_inputs

#include <svm.mqh>

CDualSVMONNX dual_svm;

input uint bars = 1000;
input uint epochs_ = 1000;
input uint batch_size_ = 64;
input double alpha__ =0.1;
input double lambda_ = 0.01;

input int rsi_period = 13;
input int bb_period = 20;
input double bb_deviation = 2.0;

int rsi_handle, 
    bb_handle;
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
  
    rsi_handle = iRSI(Symbol(),PERIOD_CURRENT,rsi_period, PRICE_CLOSE);
    bb_handle = iBands(Symbol(), PERIOD_CURRENT, bb_period,0, bb_deviation, PRICE_CLOSE);
    
//---

    matrixf data = GetTrainTestData<float>();
    dual_svm.SendDataToONNX(data,"DualSVMONNX-data.csv","rsi,bb-high,bb-low,bb-mid,target");
  }
//+------------------------------------------------------------------+
//|   Getting data for Training and Testing the model                |
//+------------------------------------------------------------------+
template <typename T>
matrix<T> GetTrainTestData()
 {
   matrix<T> data(bars, 5);
   vector<T> v; //Temporary vector for storing Inidcator buffers
    
   v.CopyIndicatorBuffer(rsi_handle, 0, 0, bars);
   data.Col(v, 0);
   v.CopyIndicatorBuffer(bb_handle, 0, 0, bars);
   data.Col(v, 1);
   v.CopyIndicatorBuffer(bb_handle, 1, 0, bars);
   data.Col(v, 2);
   v.CopyIndicatorBuffer(bb_handle, 2, 0, bars);
   data.Col(v, 3);
   
   vector open, close;
   open.CopyRates(Symbol(), PERIOD_CURRENT, COPY_RATES_OPEN, 0, bars);
   close.CopyRates(Symbol(), PERIOD_CURRENT, COPY_RATES_CLOSE, 0, bars);
   
   for (ulong i=0; i<v.Size(); i++) //preparing the independent variable
     data[i][4] = close[i] > open[i] ? 1 : -1; // if price closed above its opening thats bullish else bearish
     
   return data;  
 }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
