//+------------------------------------------------------------------+
//|                                            TEST_CSrvResponse.mq5 |
//|            ********* WORK IN PROGRESS **********                 |
//| **** PART OF ARTICLE https://www.mql5.com/en/articles/13388 **** |
//+------------------------------------------------------------------+
#include <MQTT\CSrvResponse.mqh>

//+------------------------------------------------------------------+
//| Tests for CSrvResponse class                                     |
//+------------------------------------------------------------------+
void OnStart()
  {
   TestProtectedMethods *testProtectedMethods = new TestProtectedMethods();
   Print(testProtectedMethods.TEST_GetConnectReasonCode());
   Print(testProtectedMethods.TEST_GetConnectReasonCode_FAIL());
   delete(testProtectedMethods);
//Print(TEST_IsRETAIN());
//Print(TEST_IsRETAIN_FAIL());
//Print(TEST_GetQoSLevel_2());
//Print(TEST_GetQoSLevel_1());
//Print(TEST_GetQoSLevel_0());
//Print(TEST_GetQoSLevel_0_FAIL());
//Print(TEST_IsDUP());
//Print(TEST_IsDUP_FAIL());
//Print(TEST_GetPktType());
//Print(TEST_GetPktType_FAIL());
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
class TestProtectedMethods: public CSrvResponse
  {
public:
                     TestProtectedMethods() {};
                    ~TestProtectedMethods() {};
   bool              TEST_GetConnectReasonCode_FAIL();
   bool              TEST_GetConnectReasonCode();
  };
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool TestProtectedMethods::TEST_GetConnectReasonCode_FAIL()
  {
   Print(__FUNCTION__);
//--- Arrange
   uchar expected = MQTT_REASON_CODE_SUCCESS;
   uchar reason_code_banned[4];
   reason_code_banned[0] = B'00100000'; // packet type
   reason_code_banned[1] = 2; // remaining length
   reason_code_banned[2] = 0; // connect acknowledge flags
   reason_code_banned[3] = MQTT_REASON_CODE_BANNED;
//--- Act
   CSrvResponse *cut = new CSrvResponse();
   uchar result = this.GetConnectReasonCode(reason_code_banned);
//--- Assert
   bool isTrue = AssertNotEqual(expected, result);
//--- cleanup
   delete cut;
   ZeroMemory(result);
   return  isTrue ? true : false;
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool TestProtectedMethods::TEST_GetConnectReasonCode()
  {
   Print(__FUNCTION__);
//--- Arrange
   uchar expected = MQTT_REASON_CODE_SUCCESS;
   uchar reason_code_success[4];
   reason_code_success[0] = B'00100000'; // packet type
   reason_code_success[1] = 2; // remaining length
   reason_code_success[2] = 0; // connect acknowledge flags
   reason_code_success[3] = MQTT_REASON_CODE_SUCCESS;
//--- Act
   CSrvResponse *cut = new CSrvResponse();
   uchar result = this.GetConnectReasonCode(reason_code_success);
//--- Assert
   bool isTrue = AssertEqual(expected, result);
//--- cleanup
   delete cut;
   ZeroMemory(result);
   return  isTrue ? true : false;
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool TEST_IsRETAIN()
  {
   Print(__FUNCTION__);
//--- Arrange
   bool expected = true;
   bool result;
   uchar first_byte_CONNACK_RETAIN[] = {B'00011000'};
//--- Act
   CSrvResponse * cut = new CSrvResponse();
   result = cut.IsRETAIN(first_byte_CONNACK_RETAIN);
//--- Assert
   bool isTrue = AssertEqual(expected, result);
//--- cleanup
   delete cut;
   ZeroMemory(result);
   return  isTrue ? true : false;
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool TEST_IsRETAIN_FAIL()
  {
   Print(__FUNCTION__);
//--- Arrange
   bool expected = true; // we are expecting true...
   bool result;
   uchar first_byte_CONNACK_NO_RETAIN[] = {B'00010000'}; //... but passing NO RETAIN...
//--- Act
   CSrvResponse * cut = new CSrvResponse();
   result = cut.IsRETAIN(first_byte_CONNACK_NO_RETAIN);
//--- Assert
   bool isTrue = AssertNotEqual(expected, result);//... test should fail
//--- cleanup
   delete cut;
   ZeroMemory(result);
   return  isTrue ? true : false;
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool TEST_GetQoSLevel_2()
  {
   Print(__FUNCTION__);
//--- Arrange
   ENUM_QOS_LEVEL expected = EXACTLY_ONCE;
   ENUM_QOS_LEVEL result;
   uchar connack_with_QoS_2[] = {B'00010110'};
//--- Act
   CSrvResponse *cut = new CSrvResponse();
   result = cut.GetQoSLevel(connack_with_QoS_2);
//--- Assert
   bool isTrue = AssertEqual(expected, result);
//--- cleanup
   delete cut;
   ZeroMemory(result);
   return  isTrue ? true : false;
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool TEST_GetQoSLevel_1()
  {
   Print(__FUNCTION__);
//--- Arrange
   ENUM_QOS_LEVEL expected = AT_LEAST_ONCE;
   ENUM_QOS_LEVEL result;
   uchar connack_with_QoS_1[] = {B'00010010'};
//--- Act
   CSrvResponse *cut = new CSrvResponse();
   result = cut.GetQoSLevel(connack_with_QoS_1);
//--- Assert
   bool isTrue = AssertEqual(expected, result);
//--- cleanup
   delete cut;
   ZeroMemory(result);
   return  isTrue ? true : false;
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool TEST_GetQoSLevel_0()
  {
   Print(__FUNCTION__);
//--- Arrange
   ENUM_QOS_LEVEL expected = AT_MOST_ONCE;
   ENUM_QOS_LEVEL result;
   uchar connack_with_QoS_0[] = {B'00010000'};
//--- Act
   CSrvResponse *cut = new CSrvResponse();
   result = cut.GetQoSLevel(connack_with_QoS_0);
//--- Assert
   bool isTrue = AssertEqual(expected, result);
//--- cleanup
   delete cut;
   ZeroMemory(result);
   return  isTrue ? true : false;
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool TEST_GetQoSLevel_0_FAIL()
  {
   Print(__FUNCTION__);
//--- Arrange
   ENUM_QOS_LEVEL expected = AT_MOST_ONCE;
   ENUM_QOS_LEVEL result;
   uchar connack_with_QoS_2[] = {B'00010110'}; // EXACTLY_ONCE
//--- Act
   CSrvResponse *cut = new CSrvResponse();
   result = cut.GetQoSLevel(connack_with_QoS_2);
//--- Assert
   bool isTrue = AssertNotEqual(expected, result);
//--- cleanup
   delete cut;
   ZeroMemory(result);
   return  isTrue ? true : false;
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool TEST_IsDUP()
  {
   Print(__FUNCTION__);
//--- Arrange
   bool expected = true;
   bool result;
   uchar first_byte_CONNACK_DUP[] = {B'00011000'};
//--- Act
   CSrvResponse * cut = new CSrvResponse();
   result = cut.IsDUP(first_byte_CONNACK_DUP);
//--- Assert
   bool isTrue = AssertEqual(expected, result);
//--- cleanup
   delete cut;
   ZeroMemory(result);
   return  isTrue ? true : false;
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool TEST_IsDUP_FAIL()
  {
   Print(__FUNCTION__);
//--- Arrange
   bool expected = true; // we are expecting true...
   bool result;
   uchar first_byte_CONNACK_NO_DUP[] = {B'00010000'}; //... but passing NO DUP...
//--- Act
   CSrvResponse * cut = new CSrvResponse();
   result = cut.IsDUP(first_byte_CONNACK_NO_DUP);
//--- Assert
   bool isTrue = AssertNotEqual(expected, result);//... test should fail
//--- cleanup
   delete cut;
   ZeroMemory(result);
   return  isTrue ? true : false;
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool TEST_GetPktType()
  {
   Print(__FUNCTION__);
//--- Arrange
   uchar expected[] = {(uchar)CONNACK};
   uchar result[1] = {};
   uchar right_first_byte[] = {B'00100000'};
//--- Act
   CSrvResponse *cut = new CSrvResponse();
   ENUM_PKT_TYPE pkt_type = cut.GetPktType(right_first_byte);
   ArrayFill(result, 0, 1, (uchar)pkt_type);
//--- Assert
   bool isTrue = AssertEqual(expected, result);
//--- cleanup
   delete cut;
   ZeroMemory(result);
   return  isTrue ? true : false;
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool TEST_GetPktType_FAIL()
  {
   Print(__FUNCTION__);
//--- Arrange
   uchar expected[] = {(uchar)CONNACK};
   uchar result[1] = {};
   uchar wrong_first_byte[] = {'X'};
//--- Act
   CSrvResponse *cut = new CSrvResponse();
   ENUM_PKT_TYPE pkt_type = cut.GetPktType(wrong_first_byte);
   ArrayFill(result, 0, 1, (uchar)pkt_type);
//--- Assert
   bool isTrue = AssertNotEqual(expected, result);
//--- cleanup
   delete cut;
   ZeroMemory(result);
   return  isTrue ? true : false;
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool AssertEqual(ENUM_QOS_LEVEL expected, ENUM_QOS_LEVEL result)
  {
   return expected == result ? true : false;
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool AssertNotEqual(ENUM_QOS_LEVEL expected, ENUM_QOS_LEVEL result)
  {
   return expected == result ? false : true;
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool AssertEqual(bool expected, bool result)
  {
   return expected == result ? true : false;
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool AssertNotEqual(bool expected, bool result)
  {
   return expected == result ? false : true;
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool AssertNotEqual(uchar & expected[], uchar & result[])
  {
   if(!ArrayCompare(expected, result) == 0)
     {
      for(uint i = 0; i < expected.Size(); i++)
        {
         printf("expected\t%d\t\t%d result", expected[i], result[i]);
        }
      printf("expected size %d <=> %d result size", expected.Size(), result.Size());
      return true;
     }
   return false;
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool AssertEqual(uchar & expected[], uchar & result[])
  {
   if(!ArrayCompare(expected, result) == 0)
     {
      for(uint i = 0; i < expected.Size(); i++)
        {
         printf("expected\t%d\t\t%d result", expected[i], result[i]);
        }
      printf("expected size %d <=> %d result size", expected.Size(), result.Size());
      return false;
     }
   return true;
  }
//+------------------------------------------------------------------+
