//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
#property description "Basic script for SQL database written in MQL5"
#property version   "1.00"
#property script_show_inputs
//+------------------------------------------------------------------+
#resource "\\Files\\Script 01.sql" as string SQL_Create
#resource "\\Files\\Script 02.sql" as string SQL_Insert
//+------------------------------------------------------------------+
#include <Market Replay\SQL\C_DB_SQL.mqh>
//+------------------------------------------------------------------+
enum ECall {eType_00, eType_01, eType_02, eType_03, eType_04, eType_05};
//+------------------------------------------------------------------+
input string user01 = "DataBase01";		//Database File Name
input ECall user02 = eType_01;			//Search type
//+------------------------------------------------------------------+
C_DB_SQL *SQL;
//+------------------------------------------------------------------+
void SELECT_Type_01(void)
{
	struct st
	{
		int id;
		string symbol;
	}stLocal;

	Print("Executing type 1 data request...");
	if ((*SQL).ExecRequestOfData("SELECT * FROM tb_Symbols"))
	{
		Print("Request: OK...");
		for (int c = 0; (*SQL).GetRegisterOfRequest(stLocal, false); c++)
			Print(" Resq ", c, " ==> ", stLocal.id, " - ", stLocal.symbol);
		Print("Reload...");
		for (int c = 0; (*SQL).GetRegisterOfRequest(stLocal, false); c++)
			Print(" Resq ", c, " ==> ", stLocal.id, " - ", stLocal.symbol);
	};
	Print("Finish type 1...");
}
//+------------------------------------------------------------------+
void SELECT_Type_02(void)
{
	struct st
	{
		string of_day;
		double price;
		string symbol;
	}stLocal;
	
	Print("Executing type 2 data request...");
	if ((*SQL).ExecRequestOfData("SELECT tq.of_day, tq.price, ts.symbol FROM tb_Quotes AS tq, tb_Symbols AS ts WHERE tq.fk_id = ts.id ORDER BY price DESC;"))
	{
		Print("Request: OK...");
		for (int c = 0; (*SQL).GetRegisterOfRequest(stLocal); c++)
			Print(" Resq ", c, " ==> ", stLocal.of_day, " { ", stLocal.price, " } ", stLocal.symbol);
	}
	Print("Finish type 2...");
}
//+------------------------------------------------------------------+
void SELECT_Type_03(void)
{
	struct st
	{
		double price;
		string symbol;
	}stLocal;
	struct st1
	{
		string tmp1,
				 tmp2,
				 date;
	}std;
	
	Print("Executing type 3 data request...");
	if ((*SQL).ExecRequestOfData("SELECT tq.price, ts.symbol, tq.of_day FROM tb_Quotes AS tq, tb_Symbols AS ts WHERE tq.fk_id = ts.id ORDER BY price DESC;"))
	{
		Print("Request: OK...");
		for (int c = 0; (*SQL).GetRegisterOfRequest(stLocal, false); c++)
			Print(" Resq ", c, " ==> { ", stLocal.price, " } ", stLocal.symbol);
		Print("Reload...");
		for (int c = 0; (*SQL).GetRegisterOfRequest(std); c++)
			Print(" Resq ", c, " ==> < ", std.date, " > ");
		
	}
	Print("Finish type 3...");
}
//+------------------------------------------------------------------+
void SELECT_Type_04(void)
{
	struct st
	{
		string of_day;
		double price;
		string symbol;
	}stLocal;
	
	Print("Executing type 4 data request...");
	if ((*SQL).ExecRequestOfData("SELECT tq.price, ts.symbol FROM tb_Quotes AS tq, tb_Symbols AS ts WHERE tq.fk_id = ts.id ORDER BY price DESC;"))
	{
		Print("Request: OK...");
		for (int c = 0; (*SQL).GetRegisterOfRequest(stLocal); c++)
			Print(" Resq ", c, " ==> ", stLocal.of_day, " { ", stLocal.price, " } ", stLocal.symbol);
	}
	Print("Finish type 4...");
}
//+------------------------------------------------------------------+
void SELECT_Type_05(void)
{
	struct st
	{
		double price;
	}stLocal;
	
	Print("Executing type 5 data request...");
	if ((*SQL).ExecRequestOfData("SELECT tq.price FROM tb_Quotes AS tq, tb_Symbols AS ts WHERE tq.fk_id = (SELECT ts.id FROM tb_Symbols WHERE ts.symbol = 'PETR4') AND tq.of_day = '2023-07-11';"))
	{
		Print("Request: OK...");
		for (int c = 0; (*SQL).GetRegisterOfRequest(stLocal); c++)
			Print(" Resq ", c, " ==> { ", stLocal.price, " } ");
	}
	Print("Finish type 5...");
}
//+------------------------------------------------------------------+
const string ExecScripts(void)
{
	string szMsg = (*SQL).ExecResourceSQL(SQL_Create);
	if (szMsg != NULL) return szMsg;
	return (*SQL).ExecResourceSQL(SQL_Insert);
};
//+------------------------------------------------------------------+
void OnStart()
{
	string szMsg = NULL;
	
	SQL = new C_DB_SQL(user01);
	
	if (user02 == eType_00) szMsg = ExecScripts();
	Print(szMsg == NULL ? "Result of executing the SQL script: Success" : szMsg);
	
	if (szMsg == NULL) switch (user02)
	{
		case eType_01: SELECT_Type_01();	break;
		case eType_02:	SELECT_Type_02();	break;
		case eType_03: SELECT_Type_03(); break;
		case eType_04: SELECT_Type_04(); break;
		case eType_05: SELECT_Type_05(); break;
	}

	delete SQL;
}
//+------------------------------------------------------------------+
