//+------------------------------------------------------------------+
//|                                                    TestArima.mq5 |
//|                        Copyright 2023, MetaQuotes Software Corp. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2023, MetaQuotes Software Corp."
#property link      "https://www.mql5.com"
#property version   "1.00"
#property script_show_inputs
#include<Arima.mqh>

input bool Add_Noise=false;
input double Const_Offset=0.625;
   


//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
//---
  
    double inputs[300];
    ArrayInitialize(inputs,0);
                    
    int error_code;
      
    for(int i=2;i<ArraySize(inputs);i++)
     {
      inputs[i]= Const_Offset;
      inputs[i]+= 0.5*inputs[i-1] - 0.3*inputs[i-2]; 
      inputs[i]+=(Add_Noise)?MathRandomNormal(0,1,error_code):0;
     }                 
                                  
    CArima arima(2,0,0,Const_Offset!=0);
        
    if(arima.Fit(inputs))
      Print(arima.Summary()); 
  }
//+------------------------------------------------------------------+
  
   