//+------------------------------------------------------------------+
//|                                                     template.mq5 |
//|                                  Copyright 2022, MetaQuotes Ltd. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2022, MetaQuotes Ltd."
#property link      "https://www.mql5.com"
#property version   "1.00"

#property                           script_show_inputs

#include <Object.mqh>

#define OBJECT_NAME(x) #x+" "   // macro for displaying an object name
//+------------------------------------------------------------------+
//| ELEMENT CLASS                                                    |
//+------------------------------------------------------------------+
template <typename T>
class CElement                      : public CObject
   {
      protected:
      
      int                           cardinal;
      T                             element[];
      
      public:
      
      bool                          Cardinality(int Value) { if(Value>=0 && Value<INT_MAX) { cardinal=Value; ArrayResize(element,cardinal); return(true); } return(false); }
      int                           Cardinality() { return(cardinal); }
      
      T                             Get(int ElementIndex) { T _element=NULL; if(ElementIndex>=0 && ElementIndex<Cardinality()) { _element=element[ElementIndex]; return(_element); } return(_element); }
      bool                          Set(int ValueIndex,T Value) { if(ValueIndex>=0 && ValueIndex<Cardinality()) { element[ValueIndex]=Value; return(true); } return(false); }
      
                                    CElement(void)
                                    {
                                       Cardinality(0);
                                    };
                                    ~CElement(void) {};
   };
//+------------------------------------------------------------------+
//| DOMAIN CLASS                                                     |
//+------------------------------------------------------------------+
template <typename T>
class CDomain                       : public CObject
   {
      protected:
      
      int                           cardinal;
      CElement<T>                   elements[];
      
      public:
      
      bool                          Cardinality(int Value) { if(Value>=0 && Value<INT_MAX) { cardinal=Value; ArrayResize(elements,cardinal); return(true); } return(false); }
      int                           Cardinality() { return(cardinal); }
      
      bool                          Get(int ElementIndex,CElement<T> &Element) { if(ElementIndex>=0 && ElementIndex<Cardinality()) { Element=elements[ElementIndex]; return(true); } return(false); }
                                    
                                    //'IsIndexed' parameter specifies value should be unique in domain which is a typical requirement
                                    //there are exceptions however, such as when swapping values (see GetIsomorphisms()), where this rule could be suspended
      bool                          Set(int ValueIndex,CElement<T> &Value,bool IsIndexed=false) { if(ValueIndex>=0 && ValueIndex<Cardinality()) { if(!IsIndexed||Index(Value)<0){ elements[ValueIndex]=Value; return(true); }else{ printf(__FUNCSIG__+" value already exists. "); } }else{ printf(__FUNCSIG__+" index out of bounds. "); } return(false); }
      
      int                           Index(CElement<T> &Value)
                                    {
                                       int _index=-1;
                                       //
                                       for(int c=0; c<cardinal; c++)
                                       {
                                          if(ElementMatch(Value,elements[c]))
                                          {
                                             //printf(__FUNCSIG__+" value match at: "+IntegerToString(c)+" with value cardinality: "+IntegerToString(Value.Cardinality())+", & element cardinality: "+string(elements[c].Cardinality()));
                                             //
                                             //for(int cc=0; cc<elements[c].Cardinality(); cc++)
                                             {
                                                //printf(__FUNCSIG__+" value match at: "+IntegerToString(c)+" with value: "+string(Value.Get(cc))+", & element: "+string(elements[c].Get(cc)));
                                             }
                                             _index=c; break;
                                          }
                                       }
                                       
                                       return(_index);
                                    }
      
                                    CDomain(void)
                                    {
                                       Cardinality(0);
                                    };
                                    ~CDomain(void) {};
   };
//+------------------------------------------------------------------+
//| MORPHISM CLASS                                                   |
//+------------------------------------------------------------------+
template <typename TD,typename TC>
class CMorphism
   {
      protected:
      
      int                           domain_index;
      int                           codomain_index;
      
      public:
      
      CDomain<TD>                   domain;
      CDomain<TC>                   codomain;
      
      int                           Domain(){ return(domain_index); };
      bool                          Domain(int DomainIndex) { if(DomainIndex>=0 && DomainIndex<domain.Cardinality()) { domain_index=DomainIndex; }else{ printf(__FUNCSIG__+" index out of bounds. "); } return(false); }
      
      int                           Codomain(){ return(codomain_index); };
      bool                          Codomain(int CodomainIndex) { if(CodomainIndex>=0 && CodomainIndex<codomain.Cardinality()) { codomain_index=CodomainIndex; }else{ printf(__FUNCSIG__+" index out of bounds. "); } return(false); }
      
                                    template <typename TDD,typename TDC>
      bool                          Morph(CDomain<TDD> &D,CDomain<TDC> &C,int  &DomainIndex,int &CodomainIndex)
                                    {
                                       if(DomainIndex>=0 && DomainIndex<D.Cardinality() && CodomainIndex>=0 && CodomainIndex<D.Cardinality())
                                       {
                                          domain_index=DomainIndex;
                                          codomain_index=CodomainIndex;
                                          
                                          domain=D;
                                          codomain=C;
                                          
                                          return(true);
                                       }
                                       
                                       return(false);
                                    }
      
                                    CMorphism(void){ domain_index=-1; codomain_index=-1; };
                                    ~CMorphism(void){};
   };
//+------------------------------------------------------------------+
//| HOMO-MORPHISM CLASS                                              |
//+------------------------------------------------------------------+
template <typename TD,typename TC>
class CHomomorphism                 : public CObject
   {
      protected:
      
      int                           morphisms;
      
      public:
      
      CDomain<TD>                   domain;
      CDomain<TC>                   codomain;
      
      CMorphism<TD,TC>              morphism[];
      
      int                           Morphisms() { return(morphisms); }
      bool                          Morphisms(int Value) { if(Value>=0 && Value<INT_MAX) { morphisms=Value; ArrayResize(morphism,morphisms); return(true); } return(false); }
      
      bool                          Get(int MorphismIndex,CMorphism<TD,TC> &Morphism) { if(MorphismIndex>=0 && MorphismIndex<Morphisms()) { Morphism=morphism[MorphismIndex]; Morphism.domain=domain; Morphism.codomain=codomain; return(true); } return(false); }
      
                                    template <typename TDD,typename TDC>
      bool                          Set(int ValueIndex,CMorphism<TDD,TDC> &Value)
                                    {
                                       if
                                       (
                                       (string(typename(TD))!=string(typename(TDD)))
                                       ||
                                       (string(typename(TC))!=string(typename(TDC)))
                                       )
                                       {
                                          return(false);
                                       }
                                       //
                                       /*if(!DomainMatch(Value.domain,domain)||!DomainMatch(Value.codomain,codomain))
                                       {
                                          printf(__FUNCSIG__+" mismatched domain and/or codomain... ");
                                          return(false);
                                       }*/
                                       // 
                                       int _index=Index(Value);//printf(__FUNCSIG__+" Index: "+IntegerToString(_index));
                                       //
                                       if(_index==-1)
                                       {
                                          if(ValueIndex>=0 && ValueIndex<Morphisms())
                                          {
                                             morphism[ValueIndex]=Value;//printf(__FUNCSIG__+" re-assigned... ");
                                             
                                             return(true);
                                          }
                                          else if(ValueIndex>=0 && ValueIndex<INT_MAX)
                                          {
                                             if(Morphisms(ValueIndex+1))
                                             {
                                                morphism[ValueIndex]=Value;//printf(__FUNCSIG__+" incremented... ");
                                                
                                                return(true);
                                             }
                                          }
                                       }
                                       
                                       return(false); 
                                    };
      
      
      int                           Index(CMorphism<TD,TC> &Value)
                                    {
                                       int _index=-1;
                                       //
                                       for(int m=0; m<Morphisms(); m++)
                                       {
                                          if(MorphismMatch(Value,morphism[m]))
                                          {
                                             _index=m; break;
                                          }
                                       }
                                       
                                       return(_index);
                                    }
      
                                    CHomomorphism(void){  Morphisms(0); };
                                    ~CHomomorphism(void){};
   };
//+------------------------------------------------------------------+
//| ONTOLOGY ENUM                                                    |
//+------------------------------------------------------------------+
enum EOntology
  {
      ONTOLOGY_PRE=-1,
      ONTOLOGY_NEW=0,
      ONTOLOGY_POST=1
  };
//+------------------------------------------------------------------+
//| ONTOLOGY STRUCT                                                  |
//+------------------------------------------------------------------+
struct SOntology
  {
      int                           in;
      int                           out;
      
                                    SOntology()
                                    {
                                       in=-1;
                                       out=-1;
                                    };
                                    ~SOntology(){};
  };
//+------------------------------------------------------------------+
//| ONTOLOGY CLASS                                                   |
//+------------------------------------------------------------------+
class COntology
  {
      protected:
      
      int                           facts;
      
      SOntology                     types[];
      SOntology                     universe[];
      
      public:
      
      string                        ontology;
      
      int                           Facts() { return(facts); }
      bool                          Facts(int Value) { if(Value>=0 && Value<INT_MAX) { facts=Value; ArrayResize(types,facts); ArrayResize(universe,facts); return(true); } return(false); }
      
      bool                          GetType(int TypeIndex,int &TypeIn,int &TypeOut) { if(TypeIndex>=0 && TypeIndex<Facts()) { TypeIn=types[TypeIndex].in; TypeOut=types[TypeIndex].out; return(true); } return(false); }
      bool                          SetType(int ValueIndex,int ValueIn,int ValueOut) 
                                    { 
                                       if(ValueIndex>=0 && ValueIndex<Facts()) 
                                       { 
                                          types[ValueIndex].in=ValueIn; types[ValueIndex].out=ValueOut; 
                                          return(true); 
                                       } 
                                       else if(ValueIndex>=0 && ValueIndex>=Facts() && ValueIndex<INT_MAX-1) 
                                       { 
                                          if(Facts(ValueIndex+1))
                                          {
                                             types[ValueIndex].in=ValueIn; types[ValueIndex].out=ValueOut; 
                                             return(true); 
                                          }
                                       } 
                                       
                                       return(false); 
                                    }
      
      bool                          GetUniverse(int UniverseIndex,int &UniverseIn,int &UniverseOut) { if(UniverseIndex>=0 && UniverseIndex<Facts()) { UniverseIn=universe[UniverseIndex].in; UniverseOut=universe[UniverseIndex].out; return(true); } return(false); }
      bool                          SetUniverse(int ValueIndex,int ValueIn,int ValueOut) 
                                    { 
                                       if(ValueIndex>=0 && ValueIndex<Facts()) 
                                       { 
                                          universe[ValueIndex].in=ValueIn; universe[ValueIndex].out=ValueOut; 
                                          return(true); 
                                       } 
                                       else if(ValueIndex>=0 && ValueIndex>=Facts() && ValueIndex<INT_MAX-1) 
                                       { 
                                          if(Facts(ValueIndex+1))
                                          {
                                             universe[ValueIndex].in=ValueIn; universe[ValueIndex].out=ValueOut; 
                                             return(true); 
                                          }
                                       } 
                                       
                                       return(false); 
                                    }
      
      string                        old_hash;
      string                        new_hash;
      
                                    COntology()
                                    {
                                       ontology="";
                                       
                                       facts=0;
                                       
                                       ArrayResize(types,facts);
                                       ArrayResize(universe,facts);
                                       
                                       old_hash="";
                                       new_hash="";
                                    };
                                    ~COntology(){};
  };
//+------------------------------------------------------------------+
//| CATEGORY CLASS                                                   |
//+------------------------------------------------------------------+
class CCategory
   {
      protected:
      
      int                           domains_datetime;
      int                           domains_string;
      int                           domains_double;
      int                           domains_int;
      
      int                           ontologies;
      
      CDomain<datetime>             domain_datetime[];
      CDomain<string>               domain_string[];
      CDomain<double>               domain_double[];
      CDomain<int>                  domain_int[];
      
      COntology                     ontology[];
      
      public:
      
      int                           Domain(string T)
                                    { 
                                       if(T=="datetime"){ return(domains_datetime); }
                                       else if(T=="string"){ return(domains_string); }
                                       else if(T=="double"){ return(domains_double); }
                                       
                                       return(domains_int);
                                    };
      
      bool                          Domain(string T,int Value)
                                    { 
                                       if(Value>=0 && Value<INT_MAX)
                                       { 
                                          if(T=="datetime")
                                          { 
                                             if(ArrayResize(domain_datetime,Value)>=Value)
                                             {
                                                domains_datetime=Value;  
                                                return(true); 
                                             } 
                                          }
                                          else if(T=="string")
                                          { 
                                             if(ArrayResize(domain_string,Value)>=Value)
                                             {
                                                domains_string=Value;  
                                                return(true); 
                                             } 
                                          }
                                          else if(T=="double")
                                          { 
                                             if(ArrayResize(domain_double,Value)>=Value)
                                             {
                                                domains_double=Value;  
                                                return(true); 
                                             } 
                                          }
                                          else //if(T=="int")
                                          { 
                                             if(ArrayResize(domain_int,Value)>=Value)
                                             {
                                                domains_int=Value;  
                                                return(true);
                                             }  
                                          }
                                       } 
                                       
                                       return(false); 
                                    };
                                    
                                    
      int                           Ontology(){ return(ontologies); };
      bool                          Ontology(int Value){ if(Value>=0 && Value<INT_MAX){ ontologies=Value; ArrayResize(ontology,ontologies); return(true); } return(false); };
      
      
                                    template <typename T>
      bool                          Set(int ValueIndex,CDomain<T> &Value)
                                    {
                                       if(Index(Value)==-1 && ValueIndex>=0)
                                       {
                                          if
                                          (
                                          ValueIndex<Domain(string(typename(T)))
                                          ||
                                          (ValueIndex>=Domain(string(typename(T))) && Domain(string(typename(T)),ValueIndex+1))
                                          )
                                          {
                                             if(string(typename(T))=="datetime")
                                             {
                                                domain_datetime[ValueIndex]=Value;
                                                return(true);
                                             }
                                             else if(string(typename(T))=="string")
                                             {
                                                domain_string[ValueIndex]=Value;
                                                
                                                return(true);
                                             }
                                             else if(string(typename(T))=="double")
                                             {
                                                domain_double[ValueIndex]=Value;
                                                return(true);
                                             }
                                             else //if(string(typename(T))=="int")
                                             {
                                                domain_int[ValueIndex]=Value;
                                                return(true);
                                             }
                                          }
                                       }
                                       //
                                       return(false);
                                    };
                                    
                                    template <typename T>
      bool                          Get(int DomainIndex,CDomain<T> &D)
                                    {
                                       if(DomainIndex>=0 && DomainIndex<Domain(string(typename(T))))
                                       {
                                          if(string(typename(T))=="datetime")
                                          {
                                             D=domain_datetime[DomainIndex];
                                             
                                             return(true);
                                          }
                                          else if(string(typename(T))=="string")
                                          {
                                             D=domain_string[DomainIndex];
                                             
                                             return(true);
                                          }
                                          else if(string(typename(T))=="double")
                                          {
                                             D=domain_double[DomainIndex];
                                             
                                             return(true);
                                          }
                                          else //if(string(typename(T))=="int")
                                          {
                                             D=domain_int[DomainIndex];
                                             
                                             return(true);
                                          }
                                       }
                                       
                                       return(false);
                                    };
                                    
      bool                          Set(int ValueIndex,COntology &Value)
                                    {
                                       if
                                       (
                                       ValueIndex>=0 && ValueIndex<Ontology()
                                       )
                                       {
                                          ontology[ValueIndex]=Value;
                                          return(true);
                                       }
                                       else if(ValueIndex>=Ontology())
                                       {
                                          if(Ontology(Ontology()+1))
                                          {
                                             ontology[Ontology()-1]=Value;
                                             return(true);
                                          }
                                       }
                                       //
                                       return(false);
                                    };
                                    
      bool                          Get(int OntologyIndex,COntology &O)
                                    {
                                       if(OntologyIndex>=0 && OntologyIndex<Ontology())
                                       {
                                          O=ontology[OntologyIndex];
                                          
                                          return(true);
                                       }
                                       
                                       return(false);
                                    };
      
      
                                    template <typename T>
      int                           Index(CDomain<T> &Value)
                                    {
                                       int _index=-1;
                                       //
                                       for(int d=0; d<Domain(string(typename(T))); d++)
                                       {
                                          if(string(typename(T))=="string")
                                          {
                                             if(DomainMatch(Value,domain_string[d]))
                                             {
                                                _index=d; break;
                                             }
                                          }
                                          else if(string(typename(T))=="datetime")
                                          {
                                             if(DomainMatch(Value,domain_int[d]))
                                             {
                                                _index=d; break;
                                             }
                                          }
                                          else if(string(typename(T))=="double")
                                          {
                                             if(DomainMatch(Value,domain_double[d]))
                                             {
                                                _index=d; break;
                                             }
                                          }
                                          else if(string(typename(T))=="int")
                                          {
                                             if(DomainMatch(Value,domain_int[d]))
                                             {
                                                _index=d; break;
                                             }
                                          }
                                       }
                                       
                                       return(_index);
                                    }
      
      
      int                           Index(COntology &Value)
                                    {
                                       int _index=-1;
                                       //
                                       for(int o=0; o<Ontology(); o++)
                                       {
                                          if(!OntologyMatch(Value,ontology[o]))
                                          {
                                             _index=o; break;
                                          }
                                       }
                                       
                                       return(_index);
                                    }
      
                                    CCategory()
                                    { 
                                       domains_datetime=0; 
                                       domains_string=0; 
                                       domains_double=0; 
                                       domains_int=0; 
                                       
                                       ontologies=0; 
                                    };
                                    ~CCategory()
                                    { 
                                    };
   };
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
class CComposition
   {
      protected:
      
      int                           projectors;
      string                        projector[];
      
      bool                          Projectors(int Value)
                                    { 
                                       if(Value>=0 && Value<INT_MAX)
                                       {
                                          projectors=Value;
                                          ArrayResize(projector,projectors);
                                          return(true);
                                       }
                                       
                                       return(false); 
                                    };
      
      int                           Projectors(){ return(projectors); };
                                    
      public:
                                    
      string                        Get(int ProjectorIndex) { string _projector=""; if(ProjectorIndex>=0 && ProjectorIndex<Projectors()) { _projector=projector[ProjectorIndex]; } return(_projector); }
      bool                          Set(int ValueIndex,string Value) { if(ValueIndex>=0 && ValueIndex<Projectors()) { projector[ValueIndex]=Value; return(true); } return(false); }
      
   
                                    CComposition(void){ projectors=0;ArrayFree(projector); };
                                    ~CComposition(void){};
   };
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
class CCone                         : public CComposition
   {              
      public:
      
      CDomain<string>               property;
      CHomomorphism<string,string>  universality;
      CDomain<string>               apex;
      
                                    CCone(void){};
                                    ~CCone(void){};
   };
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
class CProduct                      :public CCone  
   {
      protected:
      
      CDomain<string>               surjector[];
      
      public:
      
      bool                          Surjectors(int Value)
                                    { 
                                       if(Value>=0 && Value<INT_MAX)
                                       {
                                          CCone::Projectors(Value);
                                          ArrayResize(surjector,Value);
                                          return(true);
                                       }
                                       
                                       return(false); 
                                    };
      
      int                           Surjectors(){ return(CCone::projectors); };
                                    
      bool                          Get(int SurjectorIndex,CDomain<string> &Surjector) { if(SurjectorIndex>=0 && SurjectorIndex<CCone::Projectors()) { Surjector=surjector[SurjectorIndex]; return(true); } return(false); }
      bool                          Set(int ValueIndex,CDomain<string> &Value) { if(ValueIndex>=0 && ValueIndex<CCone::Projectors()) { surjector[ValueIndex]=Value; return(true); } return(false); }
      
                                    CProduct(void){ ArrayFree(surjector); };
                                    ~CProduct(void){};
   };
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
class CCoproduct                    :public CCone  
   {
      protected:
      
      CDomain<string>               injector[];
      
      public:
      
      bool                          Injectors(int Value)
                                    { 
                                       if(Value>=0 && Value<INT_MAX)
                                       {
                                          CCone::Projectors(Value);
                                          ArrayResize(injector,Value);
                                          return(true);
                                       }
                                       
                                       return(false); 
                                    };
      
      int                           Injectors(){ return(CCone::projectors); };
                                    
      bool                          Get(int InjectorIndex,CDomain<string> &Injector) { if(InjectorIndex>=0 && InjectorIndex<CCone::Projectors()) { Injector=injector[InjectorIndex]; return(true); } return(false); }
      bool                          Set(int ValueIndex,CDomain<string> &Value) { if(ValueIndex>=0 && ValueIndex<CCone::Projectors()) { injector[ValueIndex]=Value; return(true); } return(false); }
      
                                    CCoproduct(void){ ArrayFree(injector); };
                                    ~CCoproduct(void){};
   };
//+------------------------------------------------------------------+
//| INPUTS                                                           |
//+------------------------------------------------------------------+
input int __domain_elements=3;
input int __domain_morphisms=5;

input int __product_size=2;
input int __coproduct_size=3;
input ENUM_APPLIED_PRICE __product_price=PRICE_CLOSE;

#define  __DA 3 //Association domains per category
#define  __EA 5 //Association elements per domain

#define  __DC 5 //Commutation domains per category 
#define  __EC 2 //Commutation elements per domain

sinput datetime __test_start=D'2021.01.01';
sinput datetime __test_stop=D'2022.01.01';
sinput datetime __walk_start=D'2022.01.01';
sinput datetime __walk_stop=D'2022.12.01';

#define        __e_size 10
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
   {
      /*
      //Declare a Domains of natural even & odd numbers
      CDomain<int> _evens,_odds;
      
      FillDomain(_evens,__domain_elements,false);
      FillDomain(_odds,__domain_elements,true);
      
      printf(__FUNCSIG__+" evens are... "+PrintDomain(_evens));
      printf(__FUNCSIG__+" odds are... "+PrintDomain(_odds));
    
      //Enumerate possible sub-domains in even numbers domain
      int _subdomain_count=0; CDomain<int> _subdomains[];
      GetSubdomains(_evens,_subdomain_count,_subdomains);
      printf(__FUNCSIG__+" evens possible sub-domains are... "+IntegerToString(_subdomain_count));
      for(int s=0; s<_subdomain_count; s++)
      {
         printf(" with: "+PrintDomain(_subdomains[s])+", at: "+IntegerToString(s+1));
      }
      
      CDomain<int> _smaller_evens;
      FillDomain(_smaller_evens,__domain_elements-2,false);
      
      printf(__FUNCSIG__+" smaller evens are... "+PrintDomain(_smaller_evens));
      
      bool _is_subdomain=IsSubdomain(_evens,_smaller_evens);printf(__FUNCSIG__+" it is: "+string(_is_subdomain)+" that 'smaller-evens' is a subdomain of evens. ");
      _is_subdomain=IsSubdomain(_odds,_smaller_evens);printf(__FUNCSIG__+" it is: "+string(_is_subdomain)+" that 'smaller-evens' is a subdomain of odds. ");
      
      //Declare domains to store time & close prices
      CDomain<double> _close;
      CDomain<datetime> _time;
      
      MqlRates _rates[];
      
      //Fill domain with '__domain_morphisms'(number) of most recent bar time & close values from chart
      if(CopyRates(_Symbol,_Period,0,__domain_morphisms,_rates)>=__domain_morphisms && _time.Cardinality(__domain_morphisms) && _close.Cardinality(__domain_morphisms))
      {
         for(int m=0;m<__domain_morphisms;m++)
         {
            //Create uni row element
            CElement<double> _m;
            CElement<datetime> _t;
            if(_t.Cardinality(1) && _m.Cardinality(1))
            {
               datetime _t_value=_rates[m].time;//iTime(_Symbol,_Period,m);
               _t.Set(0,_t_value);
               _time.Set(m,_t);
               
               double _m_value=_rates[m].close;//iClose(_Symbol,_Period,5);//,m,MODE_SMA,PRICE_CLOSE);
               _m.Set(0,_m_value);
               _close.Set(m,_m);
            }
         }
      }
      
      //Create homomorphism from close to time
      CHomomorphism<double,datetime> _h;
      if(_h.Morphisms(__domain_morphisms))
      {
         _h.domain=_close;
         _h.codomain=_time;
         for(int m=0;m<__domain_morphisms;m++)
         {
            CMorphism<double,datetime> _m;
            
            _m.domain=_h.domain;
            _m.codomain=_h.codomain;
            
            //one on one mapping
            _m.Domain(m);_m.Codomain(m);
            
            _h.morphism[m]=_m;
         }
         
         printf(__FUNCSIG__+" homomorphisms are... "+PrintHomomorphism(_h,_Digits));
      }
      
      //Create homomorphism from time to close
      CHomomorphism<double,datetime> _h_image;
      
      if(_h_image.Morphisms(__domain_morphisms))
      {
         _h_image.domain=_close;
         _h_image.codomain=_time;
         for(int m=0;m<__domain_morphisms;m++)
         {
            CMorphism<double,datetime> _m;
            
            _m.domain=_h_image.domain;
            _m.codomain=_h_image.codomain;
            
            //choose random codomain for each domain element
            int _random_codomain=MathRand()%__domain_morphisms;
            _m.Domain(m);_m.Codomain(_random_codomain);
            
            _h_image.morphism[m]=_m;
         }
         
         printf(__FUNCSIG__+" image homomorphisms are... "+PrintHomomorphism(_h_image,_Digits));
         
         CDomain<datetime> _image;Image(_h_image,_image);
         printf(__FUNCSIG__+" image from homomorphism: "+PrintDomain(_image,_Digits)); 
      }
      
      //
      
      //IDENTITY
      CHomomorphism<int,int> _h_i[];
      //is evens isomorphic to odds?
      if(IsIsomorphic(_evens,_odds,_h_i))
      {
         printf(__FUNCSIG__+" evens can be isomorphic to odds by up to: "+IntegerToString(ArraySize(_h_i))+" homomorphisms. These could be... ");
         for(int s=0; s<ArraySize(_h_i); s++)
         {
            printf(__FUNCSIG__);
            
            string _print="";
            for(int ss=0; ss<ArraySize(_h_i[s].morphism); ss++)
            {
               _print+=PrintMorphism(_h_i[s].morphism[ss],0);
            }
            
            printf(_print+" at: "+IntegerToString(s));
         }
      }
      
      //ASSOCIATION
      CCategory _ca;
      
      string _tops[__EA]={"T-shirt","button-up","polo","sweatshirt","tank top"};          //domain 0
      string _pants[__EA]={"jeans","slacks","khakis","sweatpants","shorts"};              //domain 1
      string _shoes[__EA]={"sneakers","dress shoes","loafers","running shoes","sandals"}; //domain 2
      
      CElement<string> _et[];ArrayResize(_et,__EA);
      CElement<string> _ep[];ArrayResize(_ep,__EA);
      CElement<string> _es[];ArrayResize(_es,__EA);
      
      for(int e=0;e<__EA;e++)
      { 
         _et[e].Cardinality(1); _et[e].Set(0,_tops[e]);
         _ep[e].Cardinality(1); _ep[e].Set(0,_pants[e]);
         _es[e].Cardinality(1); _es[e].Set(0,_shoes[e]); 
      }
      
      CDomain<string> _dt,_dp,_ds;
      FillDomain(_dt,_et);FillDomain(_dp,_ep);FillDomain(_ds,_es);
      
      //
      if(_ca.Domain("string",__DA))//resize domains array to 3
      {
         if(_ca.Set(0,_dt) && _ca.Set(1,_dp) && _ca.Set(2,_ds))//assign each filled domain above to a spot (index) within the category
         {
            if(_ca.Domain("string")==__DA)//check domains count 
            {
               for(int e=0;e<__EA;e++)
               {
                  COntology _o_01_2;
                  string _aspect=" is worn with ";
                  CMorphism<string,string> _m1_01_2,_m2_01_2;
                  SetCategory(_ca,0,1,e,e,_o_01_2,_aspect,_m1_01_2);
                  SetCategory(_ca,1,2,e,e,_o_01_2,_aspect,_m2_01_2,ONTOLOGY_POST);printf(__FUNCSIG__+" (0 & 1) followed by 2 Log is: "+_o_01_2.ontology);
                  
                  COntology _o_0_12;
                  CMorphism<string,string> _m1_0_12,_m2_0_12;
                  SetCategory(_ca,1,2,e,e,_o_0_12,_aspect,_m1_0_12);
                  SetCategory(_ca,0,2,e,e,_o_0_12,_aspect,_m2_0_12,ONTOLOGY_PRE);printf(__FUNCSIG__+" 0 following (1 & 2) Log is: "+_o_0_12.ontology);
               }
            }
         }
      }
      
      //COMMUTATIVE DIAGRAM
      CCategory _cc;
      
      string _a[__EC]={"EUR","GBP"};       //domain 0
      string _b[__EC]={"USD","CAD"};       //domain 1
      string _c[__EC]={"CHF","JPY"};       //domain 2
      
      CElement<string> _e_a[];ArrayResize(_e_a,__EC);
      CElement<string> _e_b[];ArrayResize(_e_b,__EC);
      CElement<string> _e_c[];ArrayResize(_e_c,__EC);
      
      for(int e=0;e<__EC;e++)
      { 
         _e_a[e].Cardinality(1); _e_a[e].Set(0,_a[e]);
         _e_b[e].Cardinality(1); _e_b[e].Set(0,_b[e]);
         _e_c[e].Cardinality(1); _e_c[e].Set(0,_c[e]); 
      }
      
      CDomain<string> _d_a,_d_b,_d_c;
      FillDomain(_d_a,_e_a);FillDomain(_d_b,_e_b);FillDomain(_d_c,_e_c);
      
      //
      if(_cc.Domain("string",__DC))//resize domains array to 3
      {
         if(_cc.Set(0,_d_a) && _cc.Set(1,_d_b) && _cc.Set(2,_d_c))//assign each filled domain above to a spot (index) within the category
         {
            if(_cc.Domain("string")==__DC)//check domains count 
            {
               for(int e=0;e<__EC;e++)
               {
                  COntology _o_ab_bc;
                  string _ab=_a[e]+_b[e],_bc=_b[e]+_c[e];
                  double _ab_bid=SymbolInfoDouble(_ab,SYMBOL_BID),_bc_bid=SymbolInfoDouble(_bc,SYMBOL_BID);
                  string _aspect_ab=" is exchanged at: "+DoubleToString(_ab_bid,(int)SymbolInfoInteger(_ab,SYMBOL_DIGITS))+", for: ";
                  string _aspect_bc=" is exchanged at: "+DoubleToString(_bc_bid,(int)SymbolInfoInteger(_bc,SYMBOL_DIGITS))+", for: ";
                  CMorphism<string,string> _m_ab,_m_bc;
                  SetCategory(_cc,0,1,e,e,_o_ab_bc,_aspect_ab,_m_ab);
                  SetCategory(_cc,1,2,e,e,_o_ab_bc,_aspect_bc,_m_bc,ONTOLOGY_POST);printf(__FUNCSIG__+" a to b then b to c logs: "+_o_ab_bc.ontology);
                  
                  COntology _o_ac;
                  string _ac=_a[e]+_c[e];
                  string _aspect_ac=" is exchanged at: "+DoubleToString(SymbolInfoDouble(_ac,SYMBOL_BID),(int)SymbolInfoInteger(_ac,SYMBOL_DIGITS))+", for: ";
                  CMorphism<string,string> _m_ac;
                  SetCategory(_cc,0,2,e,e,_o_ac,_aspect_ac,_m_ac);printf(__FUNCSIG__+" a to c logs: "+_o_ac.ontology+" vs product of bid rate for ab and bc of: "+DoubleToString(_ab_bid*_bc_bid,(int)SymbolInfoInteger(_ac,SYMBOL_DIGITS)));//ontology
               }
            }
         }
      }
      
      //////////
      //PRODUCTS
      //////////
      
      CDomain<double> _d_p_a,_d_p_b,_d_p_c;
      _d_p_a.Cardinality(__product_size);_d_p_b.Cardinality(__product_size);_d_p_c.Cardinality(__product_size);
      
      int _rsi_handle=iRSI(_Symbol,_Period,__product_size,__product_price);
      int _cci_handle=iCCI(_Symbol,_Period,__product_size,__product_price);
      int _dmk_handle=iDeMarker(_Symbol,_Period,__product_size);
      int _wpr_handle=iWPR(_Symbol,_Period,__product_size);
      int _stc_handle=iStochastic(_Symbol,_Period,8,4,4,MODE_SMA,STO_LOWHIGH);
      int _trx_handle=iTriX(_Symbol,_Period,__product_size,__product_price);
      
      if
      (
      FillDomain(_d_p_a,0,__product_size,_rsi_handle)
      &&
      FillDomain(_d_p_a,1,__product_size,_cci_handle)
      &&
      FillDomain(_d_p_b,0,__product_size,_dmk_handle)
      &&
      FillDomain(_d_p_b,1,__product_size,_wpr_handle)
      &&
      FillDomain(_d_p_c,0,__product_size,_stc_handle)
      &&
      FillDomain(_d_p_c,1,__product_size,_trx_handle)
      )
      {
         printf(__FUNCSIG__+" domain A: "+PrintDomain(_d_p_a,2));
         printf(__FUNCSIG__+" domain B: "+PrintDomain(_d_p_b,2));
         printf(__FUNCSIG__+" domain C: "+PrintDomain(_d_p_c,5));
         
         CProduct _product;
         
         GetProduct(_d_p_a,_d_p_b,_product,2);
         printf(__FUNCSIG__+" A & B product: "+PrintDomain(_product.apex,2));
         
         GetProduct(_product.apex,_d_p_c,_product,5);
         printf(__FUNCSIG__+" A & B & C product: "+PrintDomain(_product.apex,5));
      }
      
      ////////////////////////////
      //PRODUCT UNIVERSAL-PROPERTY
      ////////////////////////////
      
      //EX no.1
      
      CDomain<string> _d_security,_d_exchanges,_d_optioncycle,_d_strikewidth,_d_p1_property;
      //
      CElement<string> _ep1;_ep1.Cardinality(1);
      //
      _d_security.Cardinality(2);
      _ep1.Set(0,"EURUSD");_d_security.Set(0,_ep1,true);
      _ep1.Set(0,"USDJPY");_d_security.Set(1,_ep1,true);
      //
      _d_exchanges.Cardinality(7);
      _ep1.Set(0,"Chicago Board Options Exchange (CBOE)");_d_exchanges.Set(0,_ep1,true);
      _ep1.Set(0,"Shanghai Stock Exchange (SSE)");_d_exchanges.Set(1,_ep1,true);
      _ep1.Set(0,"Shenzhen Stock Exchange (SZSE)");_d_exchanges.Set(2,_ep1,true);
      _ep1.Set(0,"Tokyo Stock Exchange (TSE)");_d_exchanges.Set(3,_ep1,true);
      _ep1.Set(0,"Osaka Exchange (OSE)");_d_exchanges.Set(4,_ep1,true);
      _ep1.Set(0,"Eurex Exchange");_d_exchanges.Set(5,_ep1,true);
      _ep1.Set(0,"London Stock Exchange (LSE)");_d_exchanges.Set(6,_ep1,true);
      //
      _d_optioncycle.Cardinality(3);
      _ep1.Set(0,"JAJO - January, April, July, and October");_d_optioncycle.Set(0,_ep1,true);
      _ep1.Set(0,"FMAN - February, May, August, and November");_d_optioncycle.Set(1,_ep1,true);
      _ep1.Set(0,"MJSD - March, June, September, and December");_d_optioncycle.Set(2,_ep1,true);
      //
      _d_strikewidth.Cardinality(2);
      _ep1.Set(0,"1000 points");_d_strikewidth.Set(0,_ep1,true);
      _ep1.Set(0,"1250 points");_d_strikewidth.Set(1,_ep1,true);
      //
      printf(__FUNCSIG__+" securities domain: "+PrintDomain(_d_security,0));
      printf(__FUNCSIG__+" exchanges domain: "+PrintDomain(_d_exchanges,0));
      printf(__FUNCSIG__+" option cycle domain: "+PrintDomain(_d_optioncycle,0));
      printf(__FUNCSIG__+" strike width domain: "+PrintDomain(_d_strikewidth,0));
      
      CProduct _product_1;
      
      GetProduct(_d_security,_d_exchanges,_product_1,0);
      printf(__FUNCSIG__+" securities & exchanges product: "+PrintDomain(_product_1.apex,0));
      
      CProduct _product_2;
      
      GetProduct(_d_optioncycle,_d_strikewidth,_product_2,0);
      printf(__FUNCSIG__+" securities & exchanges & optioncycle product: "+PrintDomain(_product_2.apex,0));
      
      CProduct _product_p1_all;
      
      GetProduct(_product_1.apex,_product_2.apex,_product_p1_all,0);
      printf(__FUNCSIG__+" securities & exchanges & optioncycle & strikewidth product: "+PrintDomain(_product_p1_all.apex,0));
      
      _d_p1_property.Cardinality(5);
      _ep1.Set(0,"Commodity Futures Trading Commission (CFTC)");_d_p1_property.Set(0,_ep1,true);
      _ep1.Set(0,"China Securities Regulatory Commission (CSRC)");_d_p1_property.Set(1,_ep1,true);
      _ep1.Set(0,"Financial Services Agency (FSA)");_d_p1_property.Set(2,_ep1,true);
      _ep1.Set(0,"Federal Financial Supervisory Authority (BaFin)");_d_p1_property.Set(3,_ep1,true);
      _ep1.Set(0,"Financial Conduct Authority (FCA)");_d_p1_property.Set(4,_ep1,true);
      
      //
      _product_p1_all.property=_d_p1_property;
      //
      _product_p1_all.universality.domain=_product_p1_all.property;
      _product_p1_all.universality.codomain=_product_p1_all.apex;
      //
      CMorphism<string,string> _m_p1;
      _m_p1.domain=_product_p1_all.property;
      _m_p1.codomain=_product_p1_all.apex;
      //
      
      for(int c=0;c<_product_p1_all.property.Cardinality();c++)
      {
         CElement<string> _e_property;_e_property.Cardinality(1);
         if(_product_p1_all.property.Get(c,_e_property) && _e_property.Get(0)!="")
         {
            for(int cc=0;cc<_product_p1_all.apex.Cardinality();cc++)
            {
               CElement<string> _e_cone;_e_cone.Cardinality(1);
               if(_product_p1_all.apex.Get(cc,_e_cone) && _e_cone.Get(0)!="")
               {
                  if(_e_property.Get(0)=="Commodity Futures Trading Commission (CFTC)")
                  {
                     if(StringFind(_e_cone.Get(0),"Chicago Board Options Exchange (CBOE)")>=0)
                     {
                        if(_product_p1_all.universality.Morphisms(_product_p1_all.universality.Morphisms()+1))
                        {
                           if(_m_p1.Morph(_product_p1_all.property,_product_p1_all.apex,_e_property,_e_cone))
                           {
                              if(!_product_p1_all.universality.Set(_product_p1_all.universality.Morphisms()-1,_m_p1))
                              {
                                 //printf(__FUNCSIG__+" H Domain: "+PrintDomain(_product_p1_all.universality.domain,0));
                                 //printf(__FUNCSIG__+" M Domain: "+PrintDomain(_m_p1.domain,0));
                                 //printf(__FUNCSIG__+" H Codomain: "+PrintDomain(_product_p1_all.universality.codomain,0));
                                 //printf(__FUNCSIG__+" M Codomain: "+PrintDomain(_m_p1.codomain,0));
                              }
                           }
                        }
                     }
                  }
                  else if(_e_property.Get(0)=="China Securities Regulatory Commission (CSRC)")
                  {
                     if(StringFind(_e_cone.Get(0),"Shanghai Stock Exchange (SSE)")>=0||StringFind(_e_cone.Get(0),"Shenzhen Stock Exchange (SZSE)")>=0)
                     {
                        if(_product_p1_all.universality.Morphisms(_product_p1_all.universality.Morphisms()+1))
                        {
                           if(_m_p1.Morph(_product_p1_all.property,_product_p1_all.apex,_e_property,_e_cone))
                           {
                              if(!_product_p1_all.universality.Set(_product_p1_all.universality.Morphisms()-1,_m_p1))
                              {
                              }
                           }
                        }
                     }
                  }
                  else if(_e_property.Get(0)=="Financial Services Agency (FSA)")
                  {
                     if(StringFind(_e_cone.Get(0),"Tokyo Stock Exchange (TSE)")>=0||StringFind(_e_cone.Get(0),"Osaka Exchange (OSE)")>=0)
                     {
                        if(_product_p1_all.universality.Morphisms(_product_p1_all.universality.Morphisms()+1))
                        {
                           if(_m_p1.Morph(_product_p1_all.property,_product_p1_all.apex,_e_property,_e_cone))
                           {
                              if(!_product_p1_all.universality.Set(_product_p1_all.universality.Morphisms()-1,_m_p1))
                              {
                              }
                           }
                        }
                     }
                  }
                  else if(_e_property.Get(0)=="Federal Financial Supervisory Authority (BaFin)")
                  {
                     if(StringFind(_e_cone.Get(0),"Eurex Exchange")>=0)
                     {
                        if(_product_p1_all.universality.Morphisms(_product_p1_all.universality.Morphisms()+1))
                        {
                           if(_m_p1.Morph(_product_p1_all.property,_product_p1_all.apex,_e_property,_e_cone))
                           {
                              if(!_product_p1_all.universality.Set(_product_p1_all.universality.Morphisms()-1,_m_p1))
                              {
                              }
                           }
                        }
                     }
                  }
                  else if(_e_property.Get(0)=="Financial Conduct Authority (FCA)")
                  {
                     if(StringFind(_e_cone.Get(0),"London Stock Exchange (LSE)")>=0)
                     {
                        if(_product_p1_all.universality.Morphisms(_product_p1_all.universality.Morphisms()+1))
                        {
                           if(_m_p1.Morph(_product_p1_all.property,_product_p1_all.apex,_e_property,_e_cone))
                           {
                              if(!_product_p1_all.universality.Set(_product_p1_all.universality.Morphisms()-1,_m_p1))
                              {
                              }
                           }
                        }
                     }
                  }
               }
            }
         }
      }
      
      printf(__FUNCSIG__+" universal property all: "+PrintHomomorphism(_product_p1_all.universality,0));
      
      ////////////////////////////
      //PRODUCT UNIVERSAL-PROPERTY
      ////////////////////////////
      
      //EX no.2
      
      CDomain<string> _d_hedge,_d_cover,_d_postion,_d_p2_property;
      //
      CElement<string> _ep2;_ep2.Cardinality(1);
      //
      _d_hedge.Cardinality(2);
      _ep2.Set(0,"EURUSD");_d_hedge.Set(0,_ep2,true);
      _ep2.Set(0,"GBPUSD");_d_hedge.Set(1,_ep2,true);
      //
      _d_cover.Cardinality(2);
      _ep2.Set(0,"USDCHF");_d_cover.Set(0,_ep2,true);
      _ep2.Set(0,"USDJPY");_d_cover.Set(1,_ep2,true);
      //
      _d_postion.Cardinality(4);
      _ep2.Set(0,"EURCHF");_d_postion.Set(0,_ep2,true);
      _ep2.Set(0,"EURJPY");_d_postion.Set(1,_ep2,true);
      _ep2.Set(0,"GBPCHF");_d_postion.Set(2,_ep2,true);
      _ep2.Set(0,"GBPJPY");_d_postion.Set(3,_ep2,true);
      //
      printf(__FUNCSIG__+" hedge domain: "+PrintDomain(_d_hedge,0));
      printf(__FUNCSIG__+" cover domain: "+PrintDomain(_d_cover,0));
      printf(__FUNCSIG__+" postion domain: "+PrintDomain(_d_postion,0));
      
      CProduct _product_hc;
      
      GetProduct(_d_hedge,_d_cover,_product_hc,0);
      printf(__FUNCSIG__+" hedge & cover product: "+PrintDomain(_product_hc.apex,0));
      
      CProduct _product_hcp;
      
      GetProduct(_product_hc.apex,_d_postion,_product_hcp,0);
      printf(__FUNCSIG__+" hedge & cover & postion product: "+PrintDomain(_product_hcp.apex,0));
      //
      
      CDomain<double> _d_p2_eu,_d_p2_gu,_d_p2_uc,_d_p2_uj,_d_p2_ec,_d_p2_ej,_d_p2_gc,_d_p2_gj;
      _d_p2_eu.Cardinality(1);_d_p2_gu.Cardinality(1);_d_p2_uc.Cardinality(1);_d_p2_uj.Cardinality(1);
      _d_p2_ec.Cardinality(1);_d_p2_ej.Cardinality(1);_d_p2_gc.Cardinality(1);_d_p2_gj.Cardinality(1);
      
      int _eu_handle=iATR("EURUSD",_Period,__product_size);
      int _gu_handle=iATR("GBPUSD",_Period,__product_size);
      int _uc_handle=iATR("USDCHF",_Period,__product_size);
      int _uj_handle=iATR("USDJPY",_Period,__product_size);
      int _ec_handle=iATR("EURCHF",_Period,__product_size);
      int _ej_handle=iATR("EURJPY",_Period,__product_size);
      int _gc_handle=iATR("GBPCHF",_Period,__product_size);
      int _gj_handle=iATR("GBPJPY",_Period,__product_size);
      
      if
      (
      FillDomain(_d_p2_eu,0,1,_eu_handle)
      &&
      FillDomain(_d_p2_gu,0,1,_gu_handle)
      &&
      FillDomain(_d_p2_uc,0,1,_uc_handle)
      &&
      FillDomain(_d_p2_uj,0,1,_uj_handle)
      &&
      FillDomain(_d_p2_ec,0,1,_ec_handle)
      &&
      FillDomain(_d_p2_ej,0,1,_ej_handle)
      &&
      FillDomain(_d_p2_gc,0,1,_gc_handle)
      &&
      FillDomain(_d_p2_gj,0,1,_gj_handle)
      )
      {
         CElement<double> _e_eu,_e_gu,_e_uc,_e_uj,_e_ec,_e_ej,_e_gc,_e_gj;
         //
         if
         (
         _d_p2_eu.Get(0,_e_eu) && _d_p2_gu.Get(0,_e_gu) && 
         _d_p2_uc.Get(0,_e_uc) && _d_p2_uj.Get(0,_e_uj) && 
         _d_p2_ec.Get(0,_e_ec) && _d_p2_ej.Get(0,_e_ej) && 
         _d_p2_gc.Get(0,_e_gc) && _d_p2_gj.Get(0,_e_gj)
         )
         {
            _d_p2_property.Cardinality(4);
            _ep2.Set(0,DoubleToString(_e_eu.Get(0),3)+","+DoubleToString(_e_uc.Get(0),3)+","+DoubleToString(_e_ec.Get(0),3));_d_p2_property.Set(0,_ep2,true);
            _ep2.Set(0,DoubleToString(_e_gu.Get(0),3)+","+DoubleToString(_e_uc.Get(0),3)+","+DoubleToString(_e_gc.Get(0),3));_d_p2_property.Set(1,_ep2,true);
            _ep2.Set(0,DoubleToString(_e_eu.Get(0),3)+","+DoubleToString(_e_uj.Get(0),3)+","+DoubleToString(_e_ej.Get(0),3));_d_p2_property.Set(2,_ep2,true);
            _ep2.Set(0,DoubleToString(_e_gu.Get(0),3)+","+DoubleToString(_e_uj.Get(0),3)+","+DoubleToString(_e_gj.Get(0),3));_d_p2_property.Set(3,_ep2,true);
            
            //
            _product_hcp.property=_d_p2_property;
            //
            _product_hcp.universality.domain=_product_hcp.property;
            _product_hcp.universality.codomain=_product_hcp.apex;
            //
            CMorphism<string,string> _m_p2;
            _m_p2.domain=_product_hcp.property;
            _m_p2.codomain=_product_hcp.apex;
            //
            
            for(int c=0;c<_product_hcp.property.Cardinality();c++)
            {
               CElement<string> _e_property;_e_property.Cardinality(1);
               if(_product_hcp.property.Get(c,_e_property) && _e_property.Get(0)!="")
               {
                  for(int cc=0;cc<_product_hcp.apex.Cardinality();cc++)
                  {
                     CElement<string> _e_cone;_e_cone.Cardinality(1);
                     if(_product_hcp.apex.Get(cc,_e_cone) && _e_cone.Get(0)!="")
                     {
                        if(c==0)
                        {
                           if(StringFind(_e_cone.Get(0),"EURUSD")>=0&&StringFind(_e_cone.Get(0),"USDCHF")>=0&&StringFind(_e_cone.Get(0),"EURCHF")>=0)
                           {
                              if(_product_hcp.universality.Morphisms(_product_hcp.universality.Morphisms()+1))
                              {
                                 if(_m_p2.Morph(_product_hcp.property,_product_hcp.apex,_e_property,_e_cone))
                                 {
                                    if(!_product_hcp.universality.Set(_product_hcp.universality.Morphisms()-1,_m_p2))
                                    {
                                    }
                                 }
                              }
                           }
                        }
                        else if(c==1)
                        {
                           if(StringFind(_e_cone.Get(0),"GBPUSD")>=0&&StringFind(_e_cone.Get(0),"USDCHF")>=0&&StringFind(_e_cone.Get(0),"GBPCHF")>=0)
                           {
                              if(_product_hcp.universality.Morphisms(_product_hcp.universality.Morphisms()+1))
                              {
                                 if(_m_p2.Morph(_product_hcp.property,_product_hcp.apex,_e_property,_e_cone))
                                 {
                                    if(!_product_hcp.universality.Set(_product_hcp.universality.Morphisms()-1,_m_p2))
                                    {
                                    }
                                 }
                              }
                           }
                        }
                        else if(c==2)
                        {
                           if(StringFind(_e_cone.Get(0),"EURUSD")>=0&&StringFind(_e_cone.Get(0),"USDJPY")>=0&&StringFind(_e_cone.Get(0),"EURJPY")>=0)
                           {
                              if(_product_hcp.universality.Morphisms(_product_hcp.universality.Morphisms()+1))
                              {
                                 if(_m_p2.Morph(_product_hcp.property,_product_hcp.apex,_e_property,_e_cone))
                                 {
                                    if(!_product_hcp.universality.Set(_product_hcp.universality.Morphisms()-1,_m_p2))
                                    {
                                    }
                                 }
                              }
                           }
                        }
                        else if(c==3)
                        {
                           if(StringFind(_e_cone.Get(0),"GBPUSD")>=0&&StringFind(_e_cone.Get(0),"USDJPY")>=0&&StringFind(_e_cone.Get(0),"GBPJPY")>=0)
                           {
                              if(_product_hcp.universality.Morphisms(_product_hcp.universality.Morphisms()+1))
                              {
                                 if(_m_p2.Morph(_product_hcp.property,_product_hcp.apex,_e_property,_e_cone))
                                 {
                                    if(!_product_hcp.universality.Set(_product_hcp.universality.Morphisms()-1,_m_p2))
                                    {
                                    }
                                 }
                              }
                           }
                        }
                     }
                  }
               }
            }
            
            printf(__FUNCSIG__+" universal property hcp: "+PrintHomomorphism(_product_hcp.universality,0));
         }
      }
      
      
      //UP, domain volatility levels;
      
      //multiples, domains of various asset types;
      
      //product, domain of portfolio combinations;
      
      ////////////
      //COPRODUCTS
      ////////////
      
      CDomain<double> _d_c_a,_d_c_b,_d_c_c;
      _d_c_a.Cardinality(__product_size);_d_c_b.Cardinality(__product_size);_d_c_c.Cardinality(__product_size);
      
      if
      (
      FillDomain(_d_c_a,0,__product_size,_rsi_handle)
      &&
      FillDomain(_d_c_a,1,__product_size,_cci_handle)
      &&
      FillDomain(_d_c_b,0,__product_size,_dmk_handle)
      &&
      FillDomain(_d_c_b,1,__product_size,_wpr_handle)
      &&
      FillDomain(_d_c_c,0,__product_size,_stc_handle)
      &&
      FillDomain(_d_c_c,1,__product_size,_trx_handle)
      )
      {
         printf(__FUNCSIG__+" domain A: "+PrintDomain(_d_c_a,2));
         printf(__FUNCSIG__+" domain B: "+PrintDomain(_d_c_b,2));
         printf(__FUNCSIG__+" domain C: "+PrintDomain(_d_c_c,5));
         
         CCoproduct _coproduct;
      
         GetCoproduct(_d_c_a,_d_c_b,_coproduct,2);
         printf(__FUNCSIG__+" A & B co-product: "+PrintDomain(_coproduct.apex,2));
         
         GetCoproduct(_coproduct.apex,_d_c_c,_coproduct,5);
         printf(__FUNCSIG__+" A & B & C co-product: "+PrintDomain(_coproduct.apex,5));
      }
      
      ////////////
      //EQUALIZERS
      ////////////
      
      int _e_size=5;
      CHomomorphism<string,double> _equalizer;
      
      _equalizer.Morphisms(_e_size);
      CDomain<string> _domain; _domain.Cardinality(_e_size);
      CDomain<double> _codomain; _codomain.Cardinality(_e_size);
      
      _equalizer.domain=_domain; _equalizer.codomain=_codomain;
      
      for(int f=0;f<_e_size;f++)
      {
         CMorphism<string,double> _m; 
         _m.domain=_domain; _m.codomain=_codomain;
      
         CElement<string> _e_d; _e_d.Cardinality(1);
         _e_d.Set(0,"feed_"+IntegerToString(f));
         _domain.Set(f,_e_d);
         
         CElement<double> _e_cd; _e_cd.Cardinality(1);
         _e_cd.Set(0,SymbolInfoDouble(_Symbol,SYMBOL_BID)+(f)*5*_Point);
         _codomain.Set(f,_e_cd);
         
         _m.Morph(_domain,_codomain,_e_d,_e_cd);
         
         _equalizer.Set(f,_m);
      }
      
      int _r=GetEqualizer(_equalizer);
      */
      
      double _atr[];
      MqlRates _prices[];
      int _atr_handle=iATR(_Symbol,_Period,14);
      
      ArraySetAsSeries(_prices,true);
      ArraySetAsSeries(_atr,true);
      
      int _copied_prices=CopyRates(_Symbol,_Period,__test_start,__test_stop,_prices);
      int _copied_atr=CopyBuffer(_atr_handle,0,0,_copied_prices,_atr);
      
      if(_copied_atr==_copied_prices)
      {
         ArraySetAsSeries(_prices,true);
         ArraySetAsSeries(_atr,true);
         
         CDomain<string> _d_atr; _d_atr.Cardinality(__e_size);
         CDomain<string> _d_price; _d_price.Cardinality(__e_size);
         
         CHomomorphism<string,string> _h_hypo,_h_test;
         
         _h_hypo.Morphisms(__e_size);
         _h_test.Morphisms(__e_size);
         
         int _counts[__e_size][__e_size];
         ArrayInitialize(_counts,0);
         
         for(int a=_copied_atr-3;a>=0;a--)
         {
            double _a=(_atr[a+1]-_atr[a+2])/fmax(_Point,_atr[a+2]);
            //
            double _p=((_prices[a].high-_prices[a].low)-(_prices[a+1].high-_prices[a+1].low))/fmax(_Point,(_prices[a+1].high-_prices[a+1].low));
            //
            int _a_index=-1,_p_index=-1;
            //
            if(-1.0<=_a && _a<-0.8){ _a_index=0; }
            else if(-0.8<=_a && _a<-0.6){ _a_index=1; }
            else if(-0.6<=_a && _a<-0.4){ _a_index=2; }
            else if(-0.4<=_a && _a<-0.2){ _a_index=3; }
            else if(-0.2<=_a && _a<0.0){ _a_index=4; }
            else if(0.0<=_a && _a<0.2){ _a_index=5; }
            else if(0.2<=_a && _a<0.4){ _a_index=6; }
            else if(0.4<=_a && _a<0.6){ _a_index=7; }
            else if(0.6<=_a && _a<0.8){ _a_index=8; }
            else if(0.8<=_a && _a<=1.0){ _a_index=9; }
            
            if(-1.0<=_p && _p<-0.8){ _p_index=0; }
            else if(-0.8<=_p && _p<-0.6){ _p_index=1; }
            else if(-0.6<=_p && _p<-0.4){ _p_index=2; }
            else if(-0.4<=_p && _p<-0.2){ _p_index=3; }
            else if(-0.2<=_p && _p<0.0){ _p_index=4; }
            else if(0.0<=_p && _p<0.2){ _p_index=5; }
            else if(0.2<=_p && _p<0.4){ _p_index=6; }
            else if(0.4<=_p && _p<0.6){ _p_index=7; }
            else if(0.6<=_p && _p<0.8){ _p_index=8; }
            else if(0.8<=_p && _p<=1.0){ _p_index=9; }
            
            if(_a_index!=-1 && _p_index!=-1){ _counts[_a_index][_p_index]++; }
         }
         
         //
         
         for(int s=0;s<__e_size;s++)
         {
            CElement<string> _e;_e.Cardinality(1);
            //
            int _band_start=(s*20)-100,_band_stop=(s*20)-80;
            _e.Set(0,IntegerToString(_band_start)+"%% to "+IntegerToString(_band_stop)+"%%");
            
            _d_atr.Set(s,_e);_d_price.Set(s,_e);
         }
         
         ArrayPrint(_counts,0,",");
         
         
         //
         
         _h_hypo.domain=_d_atr; _h_hypo.codomain=_d_price;
         _h_test.domain=_d_atr; _h_test.codomain=_d_price;
         
         //
         
         for(int s=0;s<__e_size;s++)
         {
            int _count=_counts[s][0],_index=0;
            //
            for(int ss=1;ss<__e_size;ss++)
            {
               if(_count<_counts[s][ss]){ _count=_counts[s][ss]; _index=ss; }
            }
            
            CMorphism<string,string> _m_test,_m_hypo;
            
            _m_test.Morph(_d_atr,_d_price,s,_index);
            _h_test.Set(s,_m_test);
            
            _m_hypo.Morph(_d_atr,_d_price,s,s);
            _h_hypo.Set(s,_m_hypo);
         }
         
         printf(__FUNCSIG__+" hypo hom-set: "+PrintHomomorphism(_h_hypo));
         printf(__FUNCSIG__+" test hom-set: "+PrintHomomorphism(_h_test));
         
         CDomain<string> _equalizer;
         
         for(int s=0;s<__e_size;s++)
         {
            CMorphism<string,string> _m_hypo,_m_test;
            if(_h_hypo.Get(s,_m_hypo) && _h_test.Get(s,_m_test))
            {
               if(_m_hypo.Codomain()==_m_test.Codomain())
               {
                  //printf(__FUNCSIG__+" hypo: "+IntegerToString(_m_hypo.Codomain())+" test: "+IntegerToString(_m_test.Codomain()));
                         
                  ResetLastError();
                  if(_equalizer.Cardinality(_equalizer.Cardinality()+1))
                  {
                     ResetLastError();
                     CElement<string> _e_dom;
                     if(!_d_atr.Get(_m_hypo.Codomain(),_e_dom) || !_equalizer.Set(_equalizer.Cardinality()-1,_e_dom))
                     {
                         printf(__FUNCSIG__+" failed to asign equalizer value, err: "+IntegerToString(GetLastError()));
                     }
                  }
                  else{ printf(__FUNCSIG__+" failed to resize equalizer domain, err: "+IntegerToString(GetLastError())); }
               }
            }
         }
         
         if(_equalizer.Cardinality()>0){ printf(__FUNCSIG__+" eq dom: "+PrintDomain(_equalizer)); }
      }
   } 
//+------------------------------------------------------------------+
//| Create Simple Domain(Set) of natural numbers                     |
//+------------------------------------------------------------------+
template <typename T>
void FillDomain(CDomain<T> &D,int Cardinal,bool Odd=false)
   {
      if(Cardinal<0||INT_MAX<=Cardinal)
      {
         return;
      }
      
      //Set its cardinal to input value
      D.Cardinality(Cardinal);
      
      //Assign numbers to the domain in ascending order
      for(int c=0;c<Cardinal*2;c++)
      {
         int _index=int(floor(c/2.0));
         //
         if(!Odd)
         {
            if(c%2==0)
            {
               CElement<T> _e;
               
               ResetLastError();
               
               if(!_e.Cardinality(1)||!_e.Set(0,c)||!D.Set(_index,_e,true))
               {
                  printf(__FUNCSIG__+" failed assigning: "+IntegerToString(c)+", at index: "+IntegerToString(_index)+" with err: "+IntegerToString(GetLastError()));
               }
            }
         }
         else
         {
            if(c%2==1)
            {
               CElement<T> _e;
               
               ResetLastError();
               
               if(!_e.Cardinality(1)||!_e.Set(0,c)||!D.Set(_index,_e,true))
               {
                  printf(__FUNCSIG__+" failed assigning: "+IntegerToString(c)+", at index: "+IntegerToString(_index)+" with err: "+IntegerToString(GetLastError()));
               }
            }
         }
      }
   }
//+------------------------------------------------------------------+
//| Fill Domain(Set) with one-cardinal elements from input E array.  |
//+------------------------------------------------------------------+
template <typename TD,typename TE>
void FillDomain(CDomain<TD> &D,CElement<TE> &E[])
   {
      if(string(typename(TD))!=string(typename(TE)))
      {
         return;
      }
      
      int _cardinal=ArraySize(E);
      //
      if(_cardinal<0||INT_MAX<=_cardinal)
      {
         return;
      }
      
      //Set its cardinal to input array size
      if(D.Cardinality(_cardinal))
      {
         for(int c=0;c<_cardinal;c++)
         {
            D.Set(c,E[c],true);
         }
      }
   }
//+------------------------------------------------------------------+
//| Fill Domain with handle data.                                    |
//+------------------------------------------------------------------+
template <typename T>
bool FillDomain(CDomain<T> &D,int Index,int Size,int &Handle,int Buffer=0)
   {
      double _buffer[];ArrayResize(_buffer,Size);ArrayInitialize(_buffer,0.0);
      
      if(CopyBuffer(Handle,Buffer,0,Size,_buffer)>=Size)
      {
         for(int p=0;p<Size;p++)
         {
            CElement<double> _e;
            if(_e.Cardinality(1))
            {
               if(_e.Set(0,_buffer[p]))
               { 
                  D.Set(p,_e); 
               }
            }
         }
      }
      
      return(true);
   }
//+------------------------------------------------------------------+
//| Element Match function                                           |
//+------------------------------------------------------------------+
template <typename TA,typename TB>
bool ElementMatch(CElement<TA> &A,CElement<TB> &B)
   {
      if(string(typename(TA))!=string(typename(TB)))
      {
         return(false);
      }
      
      if(A.Cardinality()!=B.Cardinality())
      {
         return(false);
      }
      
      if(A.Cardinality()==0||B.Cardinality()==0)
      {
         return(false);
      }
      
      bool _matched=true;
      
      for(int r=0; r<A.Cardinality(); r++)
      {
         if(string(A.Get(r))!=string(B.Get(r)))
         {
            _matched=false;
            break;
         }
      }
      
      return(_matched);
   }
//+------------------------------------------------------------------+
//| Domain Match function                                            |
//+------------------------------------------------------------------+
template <typename TA,typename TB>
bool DomainMatch(CDomain<TA> &A,CDomain<TB> &B)
   {
      if(string(typename(TA))!=string(typename(TB)))
      {
         //printf(__FUNCSIG__+" type mismatch. ");
         return(false);
      }
      
      if(A.Cardinality()!=B.Cardinality())
      {
         //printf(__FUNCSIG__+" cardinality mismatch. ");
         return(false);
      }
      
      /*if(A.Cardinality()==0||B.Cardinality()==0)
      {
         return(false);
      }*/
      
      bool _matched=true;
      
      for(int o=0; o<A.Cardinality(); o++)
      {
         CElement<TA> _a;
         CElement<TB> _b;
         
         if(A.Get(o,_a) && B.Get(o,_b) && !ElementMatch(_a,_b))
         {
            //printf(__FUNCSIG__+" element mismatch at: "+IntegerToString(o));
            _matched=false; break;
         }
      }
      
      return(_matched);
   }
//+------------------------------------------------------------------+
//| Morphism Match function                                          |
//+------------------------------------------------------------------+
template <typename TD,typename TC>
bool MorphismMatch(CMorphism<TD,TC> &A,CMorphism<TD,TC> &B)
   {
      bool _matched=true;
      
      if(A.Domain()!=B.Domain()||A.Codomain()!=B.Codomain())
      {
         _matched=false;return(_matched);
      }
      
      if(!DomainMatch(A.domain,B.domain)||!DomainMatch(A.codomain,B.codomain))
      {
         _matched=false;return(_matched);
      }
      
      return(_matched);
   }
//+------------------------------------------------------------------+
//| Homomorphism Match function                                      |
//+------------------------------------------------------------------+
template <typename TD,typename TC>
bool HomomorphismMatch(CHomomorphism<TD,TC> &A,CHomomorphism<TD,TC> &B)
   {
      if(A.Morphisms()!=B.Morphisms())
      {
         return(false);
      }
      
      bool _matched=true;
      
      for(int m=0; m<A.Morphisms(); m++)
      {
         CMorphism<TD> _a;
         CMorphism<TC> _b;
         
         if(A.Get(o,_a) && B.Get(o,_b) && !MorphismMatch(_a,_b))
         {
            _matched=false; break;
         }
      }
      
      return(_matched);
   }
//+------------------------------------------------------------------+
//| Ontology Match function                                          |
//+------------------------------------------------------------------+
bool OntologyMatch(COntology &A,COntology &B)
   {
      if(A.Facts()!=B.Facts())
      {
         return(false);
      }
      
      if(A.ontology!=B.ontology)
      {
         return(false);
      }
      
      bool _matched=true;
      
      for(int o=0; o<A.Facts(); o++)
      {
         int _a_t_in=-1,_a_t_out=-1,_a_u_in=-1,_a_u_out=-1;
         int _b_t_in=-1,_b_t_out=-1,_b_u_in=-1,_b_u_out=-1;
         
         if(A.GetType(o,_a_t_in,_a_t_out) && B.GetType(o,_b_t_in,_b_t_out) && A.GetUniverse(o,_a_u_in,_a_u_out) && B.GetUniverse(o,_b_u_in,_b_u_out))
         {
            if(_a_t_in!=_b_t_in||_a_t_out!=_b_t_out||_a_u_in!=_b_u_in||_a_u_out!=_b_u_out)
            {
               _matched=false; break;
            }
         }
      }
      
      return(_matched);
   }
//+------------------------------------------------------------------+
//| Print Element function                                           |
//+------------------------------------------------------------------+
template <typename T>
string PrintElement(CElement<T> &E,int FloatPrecision=1)
   {
      string _element="(";
      //
      for(int r=0; r<E.Cardinality(); r++)
      {
         if(string(typename(T))=="datetime")
         {
            _element+=TimeToString(datetime(E.Get(r)));
         }
         else if(string(typename(T))=="string")
         {
            _element+=string(E.Get(r));
         }
         else if(string(typename(T))=="double"||string(typename(T))=="float")
         {
            _element+=DoubleToString(double(E.Get(r)),FloatPrecision);
         }
         else //if(string(typename(T))=="int")
         {
            _element+=IntegerToString(int(E.Get(r)));
         }
         
         if(r<E.Cardinality()-1){ _element+=","; }
      }
      //
      return(_element+")");
   }
//+------------------------------------------------------------------+
//| Print Morphism function                                          |
//+------------------------------------------------------------------+
template <typename TD,typename TC>
string PrintMorphism(CMorphism<TD,TC> &M,int FloatPrecision=1)
   {
      string _morphism="";
      //
      CElement<TD> _d;
      CElement<TC> _c;
      ResetLastError();
      if(M.domain.Get(M.Domain(),_d) && M.codomain.Get(M.Codomain(),_c))
      {
         _morphism=PrintElement(_d,FloatPrecision);
         _morphism+="|----->";
         _morphism+=PrintElement(_c,FloatPrecision);
         _morphism+="\n";
      }
      else
      {
         //printf(__FUNCSIG__+" could not get element from: "+OBJECT_NAME(M.Domain)+", at domain index: "+IntegerToString(M.Domain())+" and/or "+OBJECT_NAME(M.Codomain)+", at codomain index: "+IntegerToString(M.Codomain())+", err: "+IntegerToString(GetLastError()));
      }
      //
      return(_morphism);
   }
//+------------------------------------------------------------------+
//| Print Domain function                                            |
//+------------------------------------------------------------------+
template <typename T>
string PrintDomain(CDomain<T> &D,int FloatPrecision=1)
   {
      string _domain="{";
      //
      CElement<T> _e;
      for(int o=0; o<D.Cardinality(); o++)
      {
         D.Get(o,_e);
         _domain+=PrintElement(_e,FloatPrecision);if(o<D.Cardinality()-1){ _domain+=","; }
      }
      //
      return(_domain+"}\n");
   }
//+------------------------------------------------------------------+
//| Print Homomorphism function                                      |
//+------------------------------------------------------------------+
template <typename TD,typename TC>
string PrintHomomorphism(CHomomorphism<TD,TC> &H,int FloatPrecision=1)
   {
      string _homomorphism="\n\n"+PrintDomain(H.domain,FloatPrecision);
      //
      _homomorphism+="|\n";
      
      CMorphism<TD,TC> _m;
      for(int m=0;m<H.Morphisms();m++)
      {
         if(H.Get(m,_m))
         {
            _homomorphism+=(PrintMorphism(_m,FloatPrecision));
         }
      }
      //
      _homomorphism+="|\n";
      
      _homomorphism+=PrintDomain(H.codomain,FloatPrecision);
      //
      return(_homomorphism);
   }
//+------------------------------------------------------------------+
//| Get Subdomains function                                          |
//+------------------------------------------------------------------+
template <typename T>
void GetSubdomains(CDomain<T> &D,int &SubdomainCount,CDomain<T> &Subdomains[])
   {
      for(int o=1; o<=D.Cardinality(); o++)
      {
         GetSubdomains(D,0,0,o,SubdomainCount,Subdomains);
      }
   }
//+------------------------------------------------------------------+
//| Get Subdomains function                                          |
//+------------------------------------------------------------------+
template <typename T>
void GetSubdomains(CDomain<T> &D,int Start,int Index,int Number,int &SubdomainCount,CDomain<T> &Subdomains[])
   {
      // Get domain cardinal
      int _n = D.Cardinality();
      
      int _i,_j;
      
      if(Index-Start+1==Number)
      {
         if(Number==1)
         {
            CElement<T> _e;
            
            if(_e.Cardinality(0))
            {
               for(_i=0; _i<_n; _i++)
               {
                  SubdomainCount++;
                  ArrayResize(Subdomains,SubdomainCount);
                  
                  if(ArraySize(Subdomains)==SubdomainCount && Subdomains[SubdomainCount-1].Cardinality(0) && D.Get(_i,_e) && Subdomains[SubdomainCount-1].Cardinality(1))
                  {
                     Subdomains[SubdomainCount-1].Set(0,_e,true);
                  }
               }
            }
         }
         else
         {
            for(_j=Index; _j<_n; _j++)
            {
               SubdomainCount++;
               ArrayResize(Subdomains,SubdomainCount);
               
               CElement<T> _e;
               
               if(_e.Cardinality(0) && ArraySize(Subdomains)==SubdomainCount && Subdomains[SubdomainCount-1].Cardinality(0))
               {
                  for(_i=Start; _i<Index; _i++)
                  {
                     if(D.Get(_i,_e) && Subdomains[SubdomainCount-1].Cardinality(Subdomains[SubdomainCount-1].Cardinality()+1))
                     {
                        Subdomains[SubdomainCount-1].Set(Subdomains[SubdomainCount-1].Cardinality()-1,_e,true);
                     }
                  }
                  
                  if(D.Get(_j,_e) && Subdomains[SubdomainCount-1].Cardinality(Subdomains[SubdomainCount-1].Cardinality()+1))
                  {
                     Subdomains[SubdomainCount-1].Set(Subdomains[SubdomainCount-1].Cardinality()-1,_e,true);
                  }
               }
            }
            
            if(Start!=_n-Number)
            {
               GetSubdomains(D,Start+1,Start+1,Number,SubdomainCount,Subdomains);
            }
         }
      }
      else
      {
         GetSubdomains(D,Start,Index+1,Number,SubdomainCount,Subdomains);
      }
   }
//+------------------------------------------------------------------+
//| Is Subdomain function                                            |
//+------------------------------------------------------------------+
template <typename T>
bool IsSubdomain(CDomain<T> &Domain,CDomain<T> &SubDomain)
   {
      bool _is_subdomain=false;
      
      int _subdomain_count=0; CDomain<T> _subdomains[];
      GetSubdomains(Domain,_subdomain_count,_subdomains);
      
      for(int c=0;c<_subdomain_count;c++)
      {
         if(DomainMatch(SubDomain,_subdomains[c]))
         {
            _is_subdomain=true;
            break;
         }
      }
      
      return(_is_subdomain);
   }
//+------------------------------------------------------------------+
//| Image function                                                   |
//+------------------------------------------------------------------+
template <typename TD,typename TC>
void Image(CHomomorphism<TD,TC> &H,CDomain<TC> &Output)
   {
      for(int m=0;m<H.Morphisms();m++)
      {
         CElement<TC> _e;
         CMorphism<TD,TC> _m;
         if(H.Get(m,_m) && H.codomain.Get(_m.Codomain(),_e))
         {
            bool _matched=false;
            for(int o=0;o<Output.Cardinality();o++)
            {
               CElement<TC> _ee;
               if(Output.Get(o,_ee) && ElementMatch(_e,_ee))
               {
                  _matched=true; break;
               }
            }
            
            if(!_matched)
            {
               Output.Cardinality(Output.Cardinality()+1);
               Output.Set(Output.Cardinality()-1,_e,true);
            }
         }
      }
   }
//+------------------------------------------------------------------+
//| Get Isomorphisms function                                        |
//+------------------------------------------------------------------+
template <typename TD,typename TC>
bool IsIsomorphic(CDomain<TD> &A,CDomain<TC> &B,CHomomorphism<TD,TC> &Output[])
   {
      if(A.Cardinality()!=B.Cardinality())
      {
         return(false);
      }
      
      int _cardinal=A.Cardinality();
      
      uint _factorial=MathFactorial(_cardinal);
      
      ArrayResize(Output,_factorial);
      
      for(uint f=0;f<_factorial;f++)
      {
         ArrayResize(Output[f].morphism,_cardinal);
         //
         for(int c=0;c<_cardinal;c++)
         {
            Output[f].morphism[c].domain=A;
            Output[f].morphism[c].codomain=B;
         }
      }
      
      int _index=0;
      CDomain<TC> _output[];ArrayResize(_output,_factorial);
      GetIsomorphisms(B, 0, _cardinal-1, _cardinal, _index, _output);
      
      for(uint f=0;f<_factorial;f++)
      {
         for(int c=0;c<_cardinal;c++)
         {
            CElement<TC> _ec;
            if(_output[f].Get(c,_ec))
            {
               for(int cc=0;cc<_cardinal;cc++)
               {
                  CElement<TC> _ecc;
                  if(B.Get(cc,_ecc))
                  {
                     if(ElementMatch(_ec,_ecc))
                     {
                        if(Output[f].morphism[c].Codomain(cc))
                        {
                           break;
                        }
                     }
                  }
               }
            }
            
            if(Output[f].morphism[c].Domain(c))
            {
            }
         }
      }
         
      return(true);
   }
//+------------------------------------------------------------------+
//| Get Isomorphisms function                                        |
//+------------------------------------------------------------------+
template <typename T>
void GetIsomorphisms(CDomain<T> &B,int Start,int Stop,int Cardinality,int &Index,CDomain<T> &Output[]) 
   {
      if(Start == Stop) 
      {
         Output[Index].Cardinality(0);
         Output[Index].Cardinality(B.Cardinality());
         // the permutation
         for (int i = 0; i <= Stop; i++) 
         {
            CElement<T> _e;
            if(B.Get(i,_e))
            {
               Output[Index].Set(i,_e,true);
            }
         }
         
         Index++;
      } 
      else 
      {
         CElement<T> _e;
         if(B.Get(Start,_e))
         {
            for (int i = Start; i <= Stop; i++) 
            {
               // swap the elements at indices start and i
               CElement<T> _ei;
               if(B.Get(i,_ei))
               {
                  CElement<T> _temp = _e;
                  if(B.Set(Start,_ei))
                  {
                     if(B.Set(i,_e))
                     {
                        // recursively permute the remaining elements
                        GetIsomorphisms(B, Start + 1, Stop, Cardinality, Index, Output);
                     
                        // swap the elements back to their original positions
                        if(B.Set(Start,_e))
                        {
                           B.Set(i,_ei);
                        }
                     }
                  }
               }
            }
         }
      }
   }
//+------------------------------------------------------------------+
//| Factorial function                                               |
//+------------------------------------------------------------------+
uint MathFactorial(uint N)
   {
      uint _factorial=N,_n=N-1;
      
      while(_n>0)
      {
         _factorial*=_n;
         
         _n--;
         
         if(_n<=0){ break; }
      }
      
      return(_factorial);
   }
//+------------------------------------------------------------------+
//| Set Ontology function                                            |
//+------------------------------------------------------------------+
template <typename TD,typename TC>
bool SetCategory(CCategory &C,int DomainIndex,int CodomainIndex,int TypeIndex,int CotypeIndex,COntology &Log,string Aspect,CMorphism<TD,TC> &Output,EOntology LogType=ONTOLOGY_NEW)
   {
      if(Log.Facts(Log.Facts()+1))
      {
         int _fact=Log.Facts()-1;
         
         if(Log.SetType(_fact,TypeIndex,CotypeIndex) && Log.SetUniverse(_fact,DomainIndex,CodomainIndex))
         {
            CDomain<TD> _dd;
            CDomain<TC> _dc;
            CElement<TD> _ed;
            CElement<TC> _ec;
            
            if(C.Get(DomainIndex,_dd) && C.Get(CodomainIndex,_dc))
            {
               if(_dd.Get(TypeIndex,_ed) && _dc.Get(CotypeIndex,_ec))
               {
                  string _eds="",_ecs="";
                  for(int c=0;c<_ed.Cardinality();c++){ _eds+=string(_ed.Get(c)); }
                  for(int c=0;c<_ec.Cardinality();c++){ _ecs+=string(_ec.Get(c)); }
                  
                  if(LogType==ONTOLOGY_NEW)
                  {
                     Log.ontology=_eds+Aspect+_ecs;
                  }
                  else if(LogType==ONTOLOGY_POST)
                  {
                     Log.ontology=Log.ontology+Aspect+_ecs;
                  }
                  else if(LogType==ONTOLOGY_PRE)
                  {
                     Log.ontology=_eds+Aspect+Log.ontology;
                  }
                  
                  Log.old_hash=Log.new_hash;
                  int _u_in=-1,_t_in=-1,_u_out=-1,_t_out=-1;
                  //
                  if(Log.GetUniverse(DomainIndex,_u_in,_u_out) && Log.GetType(TypeIndex,_t_in,_t_out))
                  {
                     string _encoding=IntegerToString(_u_in)+"-"+IntegerToString(_t_in)+"-"+IntegerToString(_u_out)+"-"+IntegerToString(_t_out);
                     
                     uchar _encoded_string[];
                     string _encoded=EncodeString(_encoding,_encoded_string);
                     
                     Log.new_hash=EncodeHEX(_encoded_string);
                  }
                  
                  if(Output.Morph(_dd,_dc,_ed,_ec))
                  {
                     return(true);
                  }
               }
            }
         }
      }
      
      return(false);
   }
//+------------------------------------------------------------------+
//| Encode string to HEX function                                    |
//+------------------------------------------------------------------+
string EncodeHEX(uchar &EncodedString[],int Count=-1)
   {
      string _hex="";
      
      if(Count<0 || Count>ArraySize(EncodedString)){ Count=ArraySize(EncodedString); }
      
      for(int c=0;c<Count;c++)
      {
         _hex+=StringFormat("%.2X",EncodedString[c]);
      }
      
      return(_hex);
   }
//+------------------------------------------------------------------+
//| Encode HEX to hash function                                      |
//+------------------------------------------------------------------+
string EncodeString(string RawString,uchar &EncodedString[])
   {
      uchar _source[],_key[],_hashkey[];
      ArrayResize(_key,8);
      for(int k=0;k<8;k++){ _key[k]=uchar((k*5)%13); }
      
      StringToCharArray(TimeToString(TimeCurrent()),_source,0,fmin(StringLen(TimeToString(TimeCurrent())),StringLen(RawString)));
      
      ResetLastError();
      if(CryptEncode(CRYPT_HASH_SHA1,_source,_key,_hashkey)<1)
      {
         printf(__FUNCSIG__+" encode err: "+IntegerToString(GetLastError()));
      }
      
      StringToCharArray(RawString,_source,0,StringLen(RawString));
      
      ResetLastError();
      if(CryptEncode(CRYPT_HASH_SHA1,_source,_hashkey,EncodedString)<1)
      {
         printf(__FUNCSIG__+" encode err: "+IntegerToString(GetLastError()));
      }
      
      return(CharArrayToString(EncodedString));
   }
//+------------------------------------------------------------------+
//| Get Product function                                             |
//+------------------------------------------------------------------+
template <typename TA,typename TB>
void GetProduct(CDomain<TA> &A,CDomain<TB> &B,CProduct &Output,int FloatPrecision=2)
   {
      int _cardinal_a=A.Cardinality(),_cardinal_b=B.Cardinality();
      
      if(_cardinal_a==0||_cardinal_b==0)
      {
         return;
      }
      //
      CDomain<string> _a,_b;
      bool _a_match=false,_b_match=false;
      if(DomainToString(A,_a) && DomainToString(B,_b))
      {
         for(int s=0;s<Output.Surjectors();s++)
         {
            CDomain<string> _d;
            if(Output.Get(s,_d))
            {
               if(DomainMatch(_a,_d))
               {
                  _a_match=true;
               }
               //
               if(DomainMatch(_b,_d))
               {
                  _b_match=true;
               }
            }
            //
            if(_a_match && _b_match)
            {
               break;
            }
         }
         //
         if(_a_match && _b_match)
         {
            return;
         }
         //
         int _cardinality=(_cardinal_a*_cardinal_b)-1;
         //
         if(Output.apex.Cardinality(Output.apex.Cardinality()+_cardinality+1))
         {
            for(int a=0;a<_cardinal_a;a++)
            {
               CElement<TA> _e_a;
               _e_a.Cardinality(1);
               if(A.Get(a,_e_a) && string(_e_a.Get(0))!="")
               {
                  for(int b=0;b<_cardinal_b;b++)
                  {
                     CElement<TB> _e_b;
                     _e_b.Cardinality(1);
                     if(B.Get(b,_e_b) && string(_e_b.Get(0))!="")
                     {
                        CElement<string> _product; _product.Cardinality(1);
                        string _a_out=PrintElement(_e_a,FloatPrecision);
                        string _b_out=PrintElement(_e_b,FloatPrecision);
                        if(_product.Set(0,string(_a_out+","+_b_out)))
                        {
                           if(Output.apex.Set(_cardinality,_product,true))
                           {
                              _cardinality--;
                              if(_cardinality<0){ break; }
                           }
                        }
                     }  
                  }
               }
               //
               if(_cardinality<0){ break; }
            }
            //
            if(!_a_match)
            {
               if(Output.Surjectors(Output.Surjectors()+1))
               {
                  Output.Set(Output.Surjectors()-1,_a);
               }
            }
            //
            if(!_b_match)
            {
               if(Output.Surjectors(Output.Surjectors()+1))
               {
                  Output.Set(Output.Surjectors()-1,_b);
               }
            }
         }
      }
   }
//+------------------------------------------------------------------+
//| Get Coproduct function                                           |
//+------------------------------------------------------------------+
template <typename TA,typename TB>
void GetCoproduct(CDomain<TA> &A,CDomain<TB> &B,CCoproduct &Output,int FloatPrecision=2)
   {
      int _cardinal_a=A.Cardinality(),_cardinal_b=B.Cardinality();
      
      if(_cardinal_a==0||_cardinal_b==0)
      {
         return;
      }
      //
      CDomain<string> _a,_b;
      bool _a_match=false,_b_match=false;
      if(DomainToString(A,_a) && DomainToString(B,_b))
      {
         for(int s=0;s<Output.Injectors();s++)
         {
            CDomain<string> _d;
            if(Output.Get(s,_d))
            {
               if(DomainMatch(_a,_d))
               {
                  _a_match=true;
               }
               //
               if(DomainMatch(_b,_d))
               {
                  _b_match=true;
               }
            }
            //
            if(_a_match && _b_match)
            {
               break;
            }
         }
         //
         if(_a_match && _b_match)
         {
            return;
         }
         //
         int _cardinality=(_cardinal_a+_cardinal_b)-1;
         //
         if(Output.apex.Cardinality(Output.apex.Cardinality()+_cardinality+1))
         {
            for(int a=0;a<_cardinal_a;a++)
            {
               CElement<TA> _e_a;
               _e_a.Cardinality(1);
               if(A.Get(a,_e_a) && string(_e_a.Get(0))!="")
               {
                  CElement<string> _product; _product.Cardinality(1);
                  string _a_out=PrintElement(_e_a,FloatPrecision);
                  if(_product.Set(0,string(_a_out)))
                  {
                     if(Output.apex.Set(_cardinality,_product,true))
                     {
                        _cardinality--;
                        if(_cardinality<0){ break; }
                     }
                  }
               }
            }
            //
            for(int b=0;b<_cardinal_b;b++)
            {
               CElement<TB> _e_b;
               _e_b.Cardinality(1);
               if(B.Get(b,_e_b) && string(_e_b.Get(0))!="")
               {
                  CElement<string> _product; _product.Cardinality(1);
                  string _b_out=PrintElement(_e_b,FloatPrecision);
                  if(_product.Set(0,string(_b_out)))
                  {
                     if(Output.apex.Set(_cardinality,_product,true))
                     {
                        _cardinality--;
                        if(_cardinality<0){ break; }
                     }
                  }
               }  
            }
            //
            if(!_a_match)
            {
               if(Output.Injectors(Output.Injectors()+1))
               {
                  Output.Set(Output.Injectors()-1,_a);
               }
            }
            //
            if(!_b_match)
            {
               if(Output.Injectors(Output.Injectors()+1))
               {
                  Output.Set(Output.Injectors()-1,_b);
               }
            }
         }
      }
   }
//+------------------------------------------------------------------+
//| Get Coproduct function                                           |
//+------------------------------------------------------------------+
template <typename T>
bool DomainToString(CDomain<T> &D,CDomain<string> &Output)
   {
      if(D.Cardinality()<=0){ return(false); }
      
      bool _set=true;
      //
      if(Output.Cardinality(D.Cardinality()))
      {
         for(int d=0;d<D.Cardinality();d++)
         {
            CElement<T> _e_get;
            CElement<string> _e_set;
            if(D.Get(d,_e_get))
            {
               if(_e_set.Cardinality(_e_get.Cardinality()))
               {
                  for(int e=0;e<_e_get.Cardinality();e++)
                  {
                     if(!_e_set.Set(e,string(_e_get.Get(e))))
                     {
                        _set=false;break;
                     }
                  }
                  //
                  if(_set)
                  {
                     Output.Set(d,_e_set,true);
                  }
                  else{ break; }
               }
            }
         }
      }
      
      return(_set);
   }
//+------------------------------------------------------------------+
//| Get Coproduct function                                           |
//+------------------------------------------------------------------+
template <typename TD,typename TC>
int GetEqualizer(CHomomorphism<TD,TC> &H)
   {
      int _equal=-1;
      
      for(int d=1;d<=_Digits;d++)
      {
         CElement<double> _e;
         if(H.codomain.Get(0,_e))
         {
            double _base=_e.Get(0);
            
            for(int c=1;c<H.codomain.Cardinality();c++)
            {
               CElement<double> _e_1;
               if(H.codomain.Get(c,_e_1))
               {
                  if(NormalizeDouble(_e_1.Get(0),d)!=_base)
                  {
                     break;
                  }
                  else if(c==H.codomain.Cardinality()-1)
                  {
                     _equal=d; break;
                  }
               }
            }
            
            if(_equal!=-1){ break; }
         }
         
         if(_equal!=-1){ break; }
      }
      
      return(_equal);
   }
//+------------------------------------------------------------------+
