//+------------------------------------------------------------------+
//|                                Window Functions for Advanced.mq5 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/en/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/en/users/aleksej1966"
#property version   "1.00"
#property script_show_inputs
#include <Graphics\Graphic.mqh>

input ushort iPeriod=25;
input double iCenter=0;
input uchar C0=1;
input uchar C1=0;
input double P1=0;
input uchar C2=0;
input double P2=0;
input uchar C3=0;
input double P3=0;
input uchar C4=0;
input double P4=0;
input uchar C5=0;
input double P5=0;
//---
input uchar Width=5,
            ViewDuration=5;
input bool ScreenShot=true;
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
//---
   int period=MathMax(2,iPeriod),step=(int)MathRound(2*iCenter);

   double center=0.5*step;
   if(center<1 || center>period)
      center=0.5*(period+1);

   int width=(int)(2*center),shift=1;
   if(2*center<=period)
     {
      width=2*period-(int)(2*center)+2;
      shift=period-(int)(2*center)+2;
     }

   int c0=MathMax(C0,C1+C2+C3+C4+C5);
   double weight[],denom=0;
   ArrayResize(weight,period);
   ArrayInitialize(weight,0);

   for(int i=0; i<period; i++)
     {
      double var=MathAbs(2.0*(i+shift)-width)/width;
      weight[i]=c0-C1*MathPow(var,P1)-C2*MathPow(var,P2)-C3*MathPow(var,P3)-C4*MathPow(var,P4)-C5*MathPow(var,P5);
      denom=denom+weight[i];
     }

   if(denom==0)
     {
      ArrayInitialize(weight,1);
      denom=period;
     }
   for(int i=0; i<period; i++)
      weight[i]=weight[i]/denom;
//---
   ChartSetInteger(0,CHART_SHOW,false);
   int w=(int)ChartGetInteger(0,CHART_WIDTH_IN_PIXELS,0),
       h=(int)ChartGetInteger(0,CHART_HEIGHT_IN_PIXELS,0);

   CGraphic graphic;
   graphic.Create(0,"WF",0,0,0,w,h);
   CCurve *curve=graphic.CurveAdd(weight,CURVE_HISTOGRAM);
   curve.HistogramWidth(Width);
   graphic.CurvePlotAll();
   graphic.Update();
   if(ScreenShot==true)
      ChartScreenShot(0,"WindowFunctions.png",w,h);
   Sleep(ViewDuration*1000);
   graphic.Destroy();
   ChartSetInteger(0,CHART_SHOW,true);
//---
   string res;
   for(int i=0; i<period; i++)
     {
      res=res+DoubleToString(weight[i],6);
      if(i<period-1)
         res=res+",";
     }

   int handle=FileOpen("WindowFunctions.txt",FILE_WRITE|FILE_TXT);
   FileWrite(handle,res);
   FileClose(handle);
//---
  }
//+------------------------------------------------------------------+
