//+------------------------------------------------------------------+
//|                                                         OEIS.mq5 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/en/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/en/users/aleksej1966"
#property version   "1.00"
#property indicator_chart_window
#property indicator_buffers 1
#property indicator_plots   1

#property indicator_type1  DRAW_LINE
#property indicator_label1 "OEIS"
#property indicator_color1 clrBlue
#property indicator_width1 1
#property indicator_style1 STYLE_SOLID

#property indicator_applied_price PRICE_CLOSE

enum type
  {
   A229037,//forest fire
   A235265,
   A235383
  };
input type TypeIS=A229037;
input ushort iPeriod=15;
int size=2;
double buffer[],coeff[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
   SetIndexBuffer(0,buffer,INDICATOR_DATA);
   ArraySetAsSeries(buffer,true);
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);

   if(TypeIS==A229037)
     {
      uchar array[]=
        {
         1,1,2,1,1,2,2,4,4,1,1,2,1,1,2,2,4,4,2,4,4,5,5,8,5,5,9,1,1,2,1,1,2,2,4,4,1,1,2,1,1,2,2,4,4,2,4,4,5,5,8,5,5,9,9,4,4,5,5,10,5,5,10,2,10,13,11,10,8,11,13,10,
         12,10,10,12,10,11,14,20,13,1,1,2,1,1,2,2,4,4,2,1,1,13,3,1,2,4,2,4,4,2,3,3,1,5,3,4,10,10,1,1,10,4,1,1,5,10,5,8,6,1,2,9,4,8,2,9,4,5,8,10,10,5,5,9,4,10,5,
         13,4,5,9,7,20,13,11,17,8,18,11,20,11,11,12,5,5,11,12,12,9,14,15,8,8,12,11,13,10,18,12,10,22,20,8,20,1,23,14,2,21,10,10,2,10,10,20,21,9,20,23,23,10,27,3,
         16,24,24,20,24,13,28,26,4,6,11,3,13,4,10,23,4,25,17,10,26,13,13,11,19,4,10,2,26,24,25,5,7,2,5,3,2,28,26,18,1,1,7,3,5,13,10,8,1,1,28,1,23,5,10,4,2,22,3,
         23,2,20,4,2,4,29,26,11,12,10,1,1,2,5,1,13,4,5,11,29,1,1,27,27,4,24,5,1,24,13,11,7,7,9,37,12,4,11,1,34,4,3,6,6,27,1,1,13,31,27,29,17,2,2,6,13,13,26,4,13,
         27,20,21,8,37,3,4,13,10,27,23,12,14,9,8,12,10,11,23,9,5,14,3,12,22,14,8,8,5,20,11,1,23,4,8,2,15,14,23,29,12,23,11,20,21,27,39,10,14,27,37,12,2,23,21,17,
         18,23,30,20,15,27,13,36,26,14,7,26,5,14,6,32,29,24,28,8,2,14,14,13,27,8,17,29,13,27,27,23,28,10,28,54,13,9,27,24,7,28,23,28,31,30,12,23,38,27,8,29,32,12,
         31,36,27,32,10,8,32,8,37,28,15,13,9,25,25,29,28,31,10,29,10,35,17,31,7,28,11,18,35,57,32,13,17,17,15,30,29,25,26,11,5,55,13,24,26,30,16,38,38,17,18,10,8,
         20,27,8,32,28,31,52,13,24,30,10,10,34,25,30,30,46,39,17,10,16,5,51,36,46,34,57,40,11,54,23,30,19,26,29,37,41,64,38,31,22,43,4,32,58,57,38,40,27,34,24,39,
         23,14,46,37,26,28,22,59,9,36,37,40,63,58,5,29,36,27,56,4,65,5,39,59,31,8,29,1,15,16,53,40,29,57,40,2,46,35,9,40,31,56,30,5,46,27,56,35,62,63,60,9,17,31,
         13,39,27,9,63,21,56,8,32,47,55,2,62,30,30,11,4,10,27,4,59,10,5,7,29,7,71,56,35,59,4,8,2,31,30,41,10,34,18,58,34,60,62,1,10,61,10,52,22,64,3,34,61,1,27,4,
         68,29,67,39,33,1,1,7,1,16,2,3,32,52,1,58,22,34,4,3,73,10,65,67,10,30,3,4,1,8,58,21,14,1,67,10,69,2,9,3,9,7,39,36,1,1,28,62,21,63,23,70,43,10,71,6,39,17,
         6,13,11,14,6,43,17,7,43,9,1,35,27,4,66,17,61,63,5,6,21,60,7,1,2,62,14,58,28,67,4,40,29,60,20,28,5,38,10,1,64,36,31,62,7,69,64,14,64,35,5,1,17,18,2,48,17,
         19,30,2,3,28,28,64,19,35,38,20,22,7,4,67,78,40,1,1,4,2,1,6,13,2,7,17,5,10,5,23,1,1,8,3,10,29,14,5,16,14,2,33,13,21,22,28,8,32,6,34,31,33,1,65,26,33,63,
         24,60,4,23,70,3,56,2,32,48,36,11,65,31,3,66,17,66,21,27,3,13,44,18,24,21,5,13,52,18,13,19,4,24,5,34,40,10,44,17,36,11,58,7,11,21,39,23,5,78,11,24,23,27,
         41,20,19,34,36,9,7,2,8,65,42,23,12,16,14,38,49,7,20,37,23,27,20,14,30,11,8,4,17,10,41,43,23,14,28,15,22,9,64,28,14,37,27,52,5,46,23,61,47,11,18,28,26,25,
         32,13,19,46,23,42,6,35,28,13,27,23,76,80,26,24,66,34,5,45,17,30,30,42,68,4,41,37,27,13,1,26,38,25,20,64,50,32,11,35,20,82,80,37,57,1,17,75,27,51,57,74,
         63,10,74,62,24,24,8,36,80,53,78,18,29,21,5,23,46,29,46,36,23,44,10,11,7,28,55,50,39,61,69,40,77,71,36,16,31,67,76,56,43,83,40,32,2,63,17,38,16,8,63,66,
         22,34,30,65,30,10,17,15,22,38,59,81,32,77,59,52,64,54,35,82,23,67,95,84,80,25,28,34,77,36,28,62,34,50,30,65,66,60,30,28,13,28,81,23,46,12,37,51,22,12,84,
         8,20,35,20,80,3,35,31,36,20,27,37,26,80,22,11,51,77,22,85,63,63,50,51,39,35,47,35,70,20,37,3,34,25,42,27,40,19,23,48,70,20,58,62,63,56,30,72,62,61,34,60,
         74,75,70,68,75,2,6,3,8,23,5,70,34,58,25,66,47,70,79,83,82,63,57,20,39,26,71,35,28,70,40,70,37,23,71,63,75,70,71,20,71,57,40,67,39,76,52,87,38,20,38,77,
         50,36,66,104,78,48,39,14,48,25,79,81,48,53,64,81,66,78,79,38,26,88,26,72,48,46,64,50,91,78,71,45,38,83,72,46,22,78,74,22,8,35,72,46,70,68,71,40,55,28,57,
         77,81,48,97,61,72,7,79,35,77,75,85,25,68,39,36,4,64,91,37,53,102,80,35,108,41,51,6,7,15,19,18,35,89,68,113,95,53,15,27,69,89,128,31,46,72,89,60,88,46,19,
         93,75,77,70,25,37,20,69,95,93,24,73,23,49,20,37,77,27,73,38,53,36,75,43,35,84,39,61,95,82,39,47,63,63,88,7,54,70,83,54,80,47,97,45,77,72,60,92,80,84,77,
         36,109,63,49,84,25,77,90,11,92,34,75,27,95,52,71,12,92,42,110,51,20,35,20,83,86,73,34,27,46,83,5,23,53,74,56,20,82,43,60,129,137,99,49,62,21,132,81,104,
         56,103,49,80,4,47,86,64,84,20,85,76,73,98,132,58,85,34,46,78,20,90,101,11,79,18,73,131,39,65,88,99,82,106,17,63,47,28,135,74,77,89,83,23,92,31,149,30,81,
         94,90,102,88,89,85,109,101,104,81,85,80,98,81,109,77,134,42,66,134,61,91,25,59,83,84,14,55,79,46,92,134,61,141,89,79,37,79,140,141,82,133,113,76,87,48,
         81,1,97,77,105,51,45,22,94,88,96,125,48,6,100,96,36,91,152,134,101,97,68,85,125,90,35,88,129,12,103,84,50,151,14,28,82,65,80,8,35,89,26,10,99,102,72,108,
         74,112,87,109,86,125,55,89,31,11,77,81,47,32,13,7,97,55,65,63,71,88,102,65,69,64,111,61,144,76,46,34,57,143,6,163,97,151,22,113,145,124,151,49,21,88,48,
         30,2,29,72,54,57,45,119,126,126,19,116,129,10,15,75,96,80,96,6,100,144,107,137,81,88,48,157,158,46,82,26,84,166,143,133,90,55,48,158,88,14,56,152,104,41,
         17,82,55,142,1,106,2,134,133,106,1,41,121,161,7,28,163,85,6,95,26,56,21,2,14,99,8,145,147,22,126,148,145,151,3,2,81,85,166,114,161,146,48,67,55,88,59,97,
         115,148,50,23,122,50,51,1,106,80,163,29,60,1,67,93,3,158,101,88,19,98,51,166,143,158,143,117,154,59,108,54,8,128,1,111,86,160,149,97,1,3,10,1,69,73,4,2,
         3,34,1,58,85,116,61,108,103,91,153,4,7,4,2,3,76,57,161,52,5,31,58,31,21,166,7,170,11,147,142,31,143,67,1,77,77,4,52,107,54,4,18,163,1,7,15,40,153,5,1,22,
         22,4,57,32,160,107,20,101,94,158,24,21,10,72,11,9,2,89,68,24,80,10,110,12,90,18,22,5,41,111,3,111,2,5,28,80,74,51,2,60,76,132,3,5,67,9,14,105,54,30,9,3,
         170,4,90,79,19,145,3,28,1,13,83,4,1,27,5,166,62,169,33,95,79,139,13,28,1,2,85,1,26,80,6,12,36,39,166,36,3,6,8,75,9,81,2,31,25,27,40,142,18,23,35,72,16,
         135,2,5,28,5,116,77,26,3,10,4,16,55,118,10,3,11,10,28,28,1,34,94,73,6,4,27,15,29,14,181,78,84,5,5,3,3,10,32,76,5,133,86,58,6,24,57,7,81,5,168,27,65,40,
         51,112,12,79,25,68,13,45,14,178,59,12,86,58,78,76,32,44,25,4,127,6,3,13,10,17,98,77,81,97,87,26,3,166,26,13,78,81,85,86,2,10,23,95,11,34,56,72,5,74,8,17,
         70,6,23,85,56,8,81,70,76,107,64,83,81,6,53,85,18,21,21,173,9,167,12,2,1,84,81,104,3,10,107,83,6,14,44,129,41,143,178,137,21,13,32,14,18,5,47,50,54,9,105,
         22,6,2,21,80,44,38,12,2,109,71,6,74,2,16,5,33,60,57,166,61,65,3,54,81,112,11,93,11,84,15,21,112,1,15,61,26,37,22,93,13,11,26,10,78,56,185,27,15,60,7,17,
         37,83,10,175,81,164,21,8,34,22,85,10,164,17,103,14,114,25,11,156,16,38,13,9,163,14,103,76,11,4,126,20,48,88,26,101,13,36,65,11,1,37,53,7,108,4,110,147,
         22,43,20,24,54,52,32,3,8,18,74,25,29,103,29,116,30,13,28,17,27,40,81,5,79,71,87,12,24,22,34,8,13,119,17,5,16,54,40,6,75,117,107,98,83,78,74,34,23,14,55,
         4,17,18,37,172,34,92,27,56,24,65,11,59,118,13,84,54,19,67,106,97,24,16,56,13,78,20,22,5,65,41,38,17,46,27,35,107,2,60,26,75,142,19,89,54,49,47,40,173,96,
         68,52,56,5,12,43,46,22,102,18,84,13,48,28,142,93,28,54,17,12,62,95,13,22,57,48,33,7,41,3,31,50,31,122,35,30,22,50,35,30,63,52,179,52,12,106,77,28,17,8,
         12,52,120,123,7,79,49,91,50,3,53,28,193,44,7,8,55,25,126,61,6,49,109,73,45,26,59,55,24,14,32,46,66,49,64,81,60,61,12,53,53,63,54,5,78,121,20,129,35,192,
         83,81,86,118,38,49,5,51,26,22,13,44,24,63,97,179,92,57,58,57,109,9,53,18,72,18,106,40,53,99,39,35,19,8
        };

      size=MathMax(size,MathMin(iPeriod,2363));
      ArrayResize(coeff,size);

      for(int i=0; i<size; i++)
         coeff[i]=array[size-i-1];
     }

   if(TypeIS==A235265)
     {
      ushort array[]=
        {
         3,13,31,37,271,283,733,757,769,1009,1093,2281,2467,2521,2551,2917,3001,3037,3163,3169,3187,3271,
         6673,7321,7573,9001,9103,9733,19801,19963,20011,20443,20521,20533,20749,21871,21961,22123,22639
        };
      size=MathMax(size,MathMin(iPeriod,39));
      ArrayResize(coeff,size);

      for(int i=0; i<size; i++)
         coeff[i]=array[size-i-1];
     }

   if(TypeIS==A235383)
     {
      ArrayResize(coeff,size);
      coeff[0]=144;
      coeff[1]=8;
     }

   double denom=0;
   for(int i=0; i<size; i++)
      denom=denom+coeff[i];

   for(int i=0; i<size; i++)
      coeff[i]=coeff[i]/denom;
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const int begin,
                const double &price[])
  {
//---
   ArraySetAsSeries(price,true);

   int bars=prev_calculated>0? rates_total-prev_calculated:rates_total-size-1;

   for(int i=bars; i>=0; i--)
     {
      double sum=0;
      for(int j=0; j<size; j++)
         sum=sum+coeff[j]*price[i+j];

      buffer[i]=sum;
     }
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
