//+------------------------------------------------------------------+
//|                                                 EA Indicator.mq5 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/en/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/en/users/aleksej1966"
#property version   "1.00"

enum indicator {SMA,TMA,MT4,MT5,Crazy};
input indicator TypeInd=SMA;

enum control {Single,Dual};
input control Control=Single;

input ENUM_APPLIED_PRICE iPrice=PRICE_CLOSE;

double lot,fast[],slow[];
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//---
   lot=SymbolInfoDouble(_Symbol,SYMBOL_VOLUME_MIN);

   if(TypeInd==SMA)
     {
      ArrayResize(fast,11);
      ArrayInitialize(fast,1);
      ArrayResize(slow,22);
      ArrayInitialize(slow,1);
     }

   if(TypeInd==TMA)
     {
      double a1[]= {11,10,9,8,7,6,5,4,3,2,1},a2[]= {1,2,3,4,5,6,7,8,9,10,11,11,10,9,8,7,6,5,4,3,2,1};
      ArrayCopy(fast,a1);
      ArrayCopy(slow,a2);
     }

   if(TypeInd==MT4)
     {
      double a1[]= {13,5,20,1,20,18,1,4,5,18,4},a2[]= {13,5,20,1,17,21,15,20,5,19,19,15,6,20,23,1,18,5,3,15,18,16};
      ArrayCopy(fast,a1);
      ArrayCopy(slow,a2);
     }

   if(TypeInd==MT5)
     {
      double a1[]= {13,5,20,1,20,18,1,4,5,18,5},a2[]= {13,5,20,1,17,21,15,20,5,19,19,15,6,20,23,1,18,5,3,15,18,16};
      ArrayCopy(fast,a1);
      ArrayCopy(slow,a2);
     }

   if(TypeInd!=Crazy)
     {
      double denom1=0,denom2=0;
      for(int i=0; i<22; i++)
        {
         if(i<11)
            denom1=denom1+fast[i];
         denom2=denom2+slow[i];
        }
      for(int i=0; i<22; i++)
        {
         if(i<11)
            fast[i]=fast[i]/denom1;
         slow[i]=slow[i]/denom2;
        }
     }
   else
      MathSrand(GetTickCount());

   CalculationIndicator();
   NewBar();
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//---
//---
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
//---
   if(NewBar()==true)
     {
      char signal=CalculationIndicator();
      if(signal==-1)
         PutPosition(ORDER_TYPE_SELL);
      if(signal==1)
         PutPosition(ORDER_TYPE_BUY);
     }
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
char CalculationIndicator()
  {
//---
   static double old_fast,old_slow;

   char shift=iPrice==PRICE_OPEN? 0:1,signal=0;
   double cur_fast=0,cur_slow=0;

   if(TypeInd!=Crazy)
     {
      for(int i=0; i<22; i++)
        {
         double price=CPrice(i+shift);
         if(i<11)
            cur_fast=cur_fast+fast[i]*price;
         cur_slow=cur_slow+slow[i]*price;
        }
     }
   else
     {
      int d1=0,d2=0,r=0;
      for(int i=0; i<22; i++)
        {
         double price=CPrice(i+shift);
         if(i<11)
           {
            r=MathRand();
            cur_fast=cur_fast+r*price;
            d1=d1+r;
           }
         r=MathRand();
         cur_slow=cur_slow+r*price;
         d2=d2+r;
        }
      cur_fast=cur_fast/d1;
      cur_slow=cur_slow/d2;
     }
//---
   if(Control==Single)
     {
      if(cur_fast<cur_slow && old_fast>old_slow)
         signal=-1;
      if(cur_fast>cur_slow && old_fast<old_slow)
         signal=1;
     }
   else
     {
      if(cur_fast<cur_slow && old_fast>old_slow && cur_fast<old_fast && cur_slow>old_slow)
         signal=-1;
      if(cur_fast>cur_slow && old_fast<old_slow && cur_fast>old_fast && cur_slow<old_slow)
         signal=1;
     }
//---
   old_fast=cur_fast;
   old_slow=cur_slow;
   return(signal);
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void PutPosition(ENUM_ORDER_TYPE type)
  {
//---
   double price=type==ORDER_TYPE_BUY? SymbolInfoDouble(_Symbol,SYMBOL_ASK):SymbolInfoDouble(_Symbol,SYMBOL_BID),margin;
   if(OrderCalcMargin(type,_Symbol,lot,price,margin)==false)
      return;
   if(margin>AccountInfoDouble(ACCOUNT_MARGIN_FREE))
     {
      Print("Not enough money for ",EnumToString(type)," ",lot," ",_Symbol," Error code=",GetLastError());
      return;
     }
   MqlTradeRequest request= {};
   MqlTradeResult result= {};
   request.action=TRADE_ACTION_DEAL;
   request.symbol=_Symbol;
   request.volume=lot;
   request.price=price;
   request.deviation=MathMax(SymbolInfoInteger(_Symbol,SYMBOL_SPREAD)/2,3);
   request.type=type;
   if(OrderSend(request,result)==false)
      PrintFormat("OrderSend error %d",GetLastError());
//---
   for(int pos=PositionsTotal()-1; pos>=0; pos--)
     {
      ulong ticket=PositionGetTicket(pos);
      if(ticket>0 && PositionSelectByTicket(ticket)==true && PositionGetString(POSITION_SYMBOL)==_Symbol)
        {
         if(type==ORDER_TYPE_SELL && PositionGetInteger(POSITION_TYPE)==POSITION_TYPE_BUY)
            ClosePosition(POSITION_TYPE_BUY,ticket);
         if(type==ORDER_TYPE_BUY && PositionGetInteger(POSITION_TYPE)==POSITION_TYPE_SELL)
            ClosePosition(POSITION_TYPE_SELL,ticket);
        }
     }
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void ClosePosition(ENUM_POSITION_TYPE type_pos,ulong ticket)
  {
//---
   MqlTradeRequest request= {};
   MqlTradeResult result= {};
   request.action=TRADE_ACTION_DEAL;
   request.position=ticket;
   request.symbol=_Symbol;
   request.volume=lot;
   request.deviation=MathMax(SymbolInfoInteger(_Symbol,SYMBOL_SPREAD)/2,3);
   request.price=type_pos==POSITION_TYPE_BUY? SymbolInfoDouble(_Symbol,SYMBOL_BID):SymbolInfoDouble(_Symbol,SYMBOL_ASK);
   request.type=type_pos==POSITION_TYPE_BUY? ORDER_TYPE_SELL:ORDER_TYPE_BUY;
   if(OrderSend(request,result)==false)
      PrintFormat("OrderSend error %d",GetLastError());
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double CPrice(int i)
  {
//---
   if(iPrice==PRICE_CLOSE)
      return(iClose(_Symbol,PERIOD_CURRENT,i));
   if(iPrice==PRICE_OPEN)
      return(iOpen(_Symbol,PERIOD_CURRENT,i));
   if(iPrice==PRICE_HIGH)
      return(iHigh(_Symbol,PERIOD_CURRENT,i));
   if(iPrice==PRICE_LOW)
      return(iLow(_Symbol,PERIOD_CURRENT,i));
   if(iPrice==PRICE_MEDIAN)
      return((iHigh(_Symbol,PERIOD_CURRENT,i)+iLow(_Symbol,PERIOD_CURRENT,i))/2);
   if(iPrice==PRICE_TYPICAL)
      return((iHigh(_Symbol,PERIOD_CURRENT,i)+iLow(_Symbol,PERIOD_CURRENT,i)+iClose(_Symbol,PERIOD_CURRENT,i))/3);
   return((iHigh(_Symbol,PERIOD_CURRENT,i)+iLow(_Symbol,PERIOD_CURRENT,i)+2*iClose(_Symbol,PERIOD_CURRENT,i))/4);
//---
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
bool NewBar()
  {
//---
   static long last_bar;
   long cur_bar=SeriesInfoInteger(_Symbol,PERIOD_CURRENT,SERIES_LASTBAR_DATE);
   if(last_bar<cur_bar)
     {
      last_bar=cur_bar;
      return(true);
     }
   return(false);
//---
  }
//+------------------------------------------------------------------+
