//+------------------------------------------------------------------+
//|                                                        Crazy.mq5 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/en/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/en/users/aleksej1966"
#property version   "1.00"
#property indicator_chart_window
#property indicator_buffers 1
#property indicator_plots   1

#property indicator_type1  DRAW_LINE
#property indicator_label1 "Crazy"
#property indicator_color1 clrBlue
#property indicator_width1 1
#property indicator_style1 STYLE_SOLID

#property indicator_applied_price PRICE_CLOSE

input ushort iPeriod=25;
int size=2;
double buffer[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
   SetIndexBuffer(0,buffer,INDICATOR_DATA);
   ArraySetAsSeries(buffer,true);
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);

   MathSrand(GetTickCount());

   size=MathMax(size,iPeriod);
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const int begin,
                const double &price[])
  {
//---
   ArraySetAsSeries(price,true);

   int bars=prev_calculated>0? rates_total-prev_calculated:rates_total-size-1;

   for(int i=bars; i>=0; i--)
     {
      int denom=0;
      double sum=0;
      for(int j=0; j<size; j++)
        {
         int k=MathRand()+1;
         sum=sum+k*price[i+j];
         denom=denom+k;
        }

      buffer[i]=sum/denom;
     }
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
