//+------------------------------------------------------------------+
//|                                             Basic Oscillator.mq5 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/en/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/en/users/aleksej1966"
#property version   "1.00"
#property indicator_separate_window
#property indicator_buffers 1
#property indicator_plots   1

#property indicator_type1  DRAW_LINE
#property indicator_label1 "Basic Oscillator"
#property indicator_color1 clrBlue
#property indicator_width1 1
#property indicator_style1 STYLE_SOLID

#property indicator_applied_price PRICE_CLOSE

input string InpCoefficient1="1,1,1,1,1",
             InpCoefficient2="1,2,3,2,1";
int period;
double buffer[],coeff[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
   SetIndexBuffer(0,buffer,INDICATOR_DATA);
   ArraySetAsSeries(buffer,true);
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);

   string s1[],s2[];
   int size1=StringSplit(InpCoefficient1,StringGetCharacter(",",0),s1),
       size2=StringSplit(InpCoefficient2,StringGetCharacter(",",0),s2);
   double array1[],array2[],denom=0;
//---
   ArrayResize(array1,size1);
   for(int i=0; i<size1; i++)
     {
      array1[i]=StringToDouble(s1[i]);
      denom=denom+array1[i];
     }

   if(denom==0)
     {
      Alert("Wrong Coefficient1!");
      return(INIT_FAILED);
     }

   for(int i=0; i<size1; i++)
      array1[i]=array1[i]/denom;
//---
   denom=0;
   ArrayResize(array2,size2);
   for(int i=0; i<size2; i++)
     {
      array2[i]=StringToDouble(s2[i]);
      denom=denom+array2[i];
     }

   if(denom==0)
     {
      Alert("Wrong Coefficient2!");
      return(INIT_FAILED);
     }

   for(int i=0; i<size2; i++)
      array2[i]=array2[i]/denom;
//---
   period=MathMax(size1,size2);
   ArrayResize(coeff,period);
   ArrayInitialize(coeff,0);
   for(int i=0; i<size1; i++)
      coeff[i]=array1[i];
   for(int i=0; i<size2; i++)
      coeff[i]=coeff[i]-array2[i];
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const int begin,
                const double &price[])
  {
//---
   ArraySetAsSeries(price,true);

   int bars=prev_calculated>0? rates_total-prev_calculated:rates_total-period-1;

   for(int i=bars; i>=0; i--)
     {
      double sum=0;
      for(int j=0; j<period; j++)
         sum=sum+coeff[j]*price[i+j];

      buffer[i]=sum;
     }
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
