//+------------------------------------------------------------------+
//|                                             Basic Oscillator.mq4 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/en/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/en/users/aleksej1966"
#property version   "1.00"
#property strict
#property indicator_separate_window
#property indicator_buffers 1
#property indicator_plots   1

#property indicator_type1  DRAW_LINE
#property indicator_label1 "Basic Oscillator"
#property indicator_color1 clrBlue
#property indicator_width1 1
#property indicator_style1 STYLE_SOLID

input ENUM_APPLIED_PRICE iPrice=PRICE_CLOSE;
input string InpCoefficient1="1,1,1,1,1",
             InpCoefficient2="1,2,3,2,1";
int period;
double buffer[],coeff[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
   SetIndexBuffer(0,buffer,INDICATOR_DATA);
   ArraySetAsSeries(buffer,true);
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);

   string s1[],s2[];
   int size1=StringSplit(InpCoefficient1,StringGetCharacter(",",0),s1),
       size2=StringSplit(InpCoefficient2,StringGetCharacter(",",0),s2);
   double array1[],array2[],denom=0;
//---
   ArrayResize(array1,size1);
   for(int i=0; i<size1; i++)
     {
      array1[i]=StringToDouble(s1[i]);
      denom=denom+array1[i];
     }

   if(denom==0)
     {
      Alert("Wrong Coefficient1!");
      return(INIT_FAILED);
     }

   for(int i=0; i<size1; i++)
      array1[i]=array1[i]/denom;
//---
   denom=0;
   ArrayResize(array2,size2);
   for(int i=0; i<size2; i++)
     {
      array2[i]=StringToDouble(s2[i]);
      denom=denom+array2[i];
     }

   if(denom==0)
     {
      Alert("Wrong Coefficient2!");
      return(INIT_FAILED);
     }

   for(int i=0; i<size2; i++)
      array2[i]=array2[i]/denom;
//---
   period=MathMax(size1,size2);
   ArrayResize(coeff,period);
   ArrayInitialize(coeff,0);
   for(int i=0; i<size1; i++)
      coeff[i]=array1[i];
   for(int i=0; i<size2; i++)
      coeff[i]=coeff[i]-array2[i];
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---
   ArraySetAsSeries(open,true);
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(close,true);

   int bars=prev_calculated>0? rates_total-prev_calculated:rates_total-period-1;

   for(int i=bars; i>=0; i--)
     {
      double sum=0;
      for(int j=0; j<period; j++)
        {
         int p=i+j;
         double pr=price(open[p],high[p],low[p],close[p]);
         sum=sum+coeff[j]*pr;
        }

      buffer[i]=sum;
     }
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
double price(double o,double h,double l,double c)
  {
   if(iPrice==PRICE_CLOSE)
      return(c);
   if(iPrice==PRICE_OPEN)
      return(o);
   if(iPrice==PRICE_HIGH)
      return(h);
   if(iPrice==PRICE_LOW)
      return(l);
   if(iPrice==PRICE_MEDIAN)
      return((h+l)/2);
   if(iPrice==PRICE_TYPICAL)
      return(h+l+c)/3;
   return(h+l+2*c)/4;
  }
//+------------------------------------------------------------------+
