//+------------------------------------------------------------------+
//|                                               Base Indicator.mq5 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/en/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/en/users/aleksej1966"
#property version   "1.00"
#property indicator_chart_window
#property indicator_buffers 1
#property indicator_plots   1

#property indicator_type1  DRAW_LINE
#property indicator_label1 "Base Indicator"
#property indicator_color1 clrBlue
#property indicator_width1 1
#property indicator_style1 STYLE_SOLID

#property indicator_applied_price PRICE_CLOSE

input string InpCoefficient="1,1,1,1,1";
int size=0;
double buffer[],coeff[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
   SetIndexBuffer(0,buffer,INDICATOR_DATA);
   ArraySetAsSeries(buffer,true);
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);

   string s[];
   size=StringSplit(InpCoefficient,StringGetCharacter(",",0),s);
   ArrayResize(coeff,size);

   double denom=0,center=0;
   for(int i=0; i<size; i++)
     {
      coeff[i]=StringToDouble(s[i]);
      denom=denom+coeff[i];
     }

   if(denom==0)
     {
      Alert("Wrong odds!");
      return(INIT_FAILED);
     }

   for(int i=0; i<size; i++)
     {
      coeff[i]=coeff[i]/denom;
      center=center+coeff[i]*(i+1);
     }

   Print((int)MathRound(center));
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const int begin,
                const double &price[])
  {
//---
   ArraySetAsSeries(price,true);

   int bars=prev_calculated>0? rates_total-prev_calculated:rates_total-size-1;

   for(int i=bars; i>=0; i--)
     {
      double sum=0;
      for(int j=0; j<size; j++)
         sum=sum+coeff[j]*price[i+j];

      buffer[i]=sum;
     }
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
