//+------------------------------------------------------------------+
//|                                  Arithmetic Geometric Filter.mq5 |
//|                                                        AIS Forex |
//|                        https://www.mql5.com/en/users/aleksej1966 |
//+------------------------------------------------------------------+
#property copyright "AIS Forex"
#property link      "https://www.mql5.com/en/users/aleksej1966"
#property version   "1.00"
#property indicator_chart_window
#property indicator_buffers 1
#property indicator_plots   1

#property indicator_type1  DRAW_LINE
#property indicator_label1 "AGF"
#property indicator_color1 clrBlue
#property indicator_width1 1
#property indicator_style1 STYLE_SOLID

#property indicator_applied_price PRICE_CLOSE

input ushort PeriodG=10;//Period Geometric
input double CoefficientG=0.1;//Coefficient Geometric

input ushort PeriodA=25;//Period Arithmetic
input double CoefficientA=0.5;//Coefficient Arithmetic

int period=0;
double buffer[],weight[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
   SetIndexBuffer(0,buffer,INDICATOR_DATA);
   ArraySetAsSeries(buffer,true);
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);

   period=MathMax(PeriodG,PeriodA);
   if(period==0)
     {
      Alert("Incorrect parameters!");
      return(INIT_FAILED);
     }
   ArrayResize(weight,period);
   ArrayInitialize(weight,0);

   if(PeriodG>0)
     {
      int size=PeriodG;
      double array[],c=1-MathMin(MathAbs(CoefficientG),1),denom=1;
      size=c==0?1:PeriodG;
      ArrayResize(array,size);
      array[0]=1;
      for(int i=1; i<size; i++)
        {
         array[i]=array[i-1]*c;
         denom=denom+array[i];
        }
      for(int i=0; i<size; i++)
         weight[i]=array[i]/denom;
     }

   if(PeriodA>0)
     {
      int size=PeriodA;
      double array[],c=MathMin(MathAbs(CoefficientA),1),denom=1;
      ArrayResize(array,size);
      array[size-1]=1;
      for(int i=size-2; i>=0; i--)
        {
         array[i]=array[i+1]+c;
         denom=denom+array[i];
        }
      for(int i=0; i<size; i++)
         weight[i]=weight[i]+array[i]/denom;
     }

   double denom=0;
   for(int i=0; i<period; i++)
      denom=denom+weight[i];
   for(int i=0; i<period; i++)
      weight[i]=weight[i]/denom;
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const int begin,
                const double &price[])
  {
//---
   ArraySetAsSeries(price,true);

   int bars=prev_calculated>0? rates_total-prev_calculated:rates_total-period-1;

   for(int i=bars; i>=0; i--)
     {
      double sum=0;
      for(int j=0; j<period; j++)
         sum=sum+weight[j]*price[i+j];

      buffer[i]=sum;
     }
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
