//+------------------------------------------------------------------+
//|                                                     testfunc.mqh |
//|                                                           DC2008 |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "DC2008"
#property link      "http://www.mql5.com"

#include <Object.mqh>
#include <MovingAverages.mqh>
#include <Files\FileTxt.mqh>

#define TEST "test it"
#define NOTEST "DON'T test it"
#define OK_VARIANT "...................................OK"
#define OK_MODE "           OK"
#define NA_VARIANT " -                n/a"
#define NA_MODE "                n/a"

ENUM_MA_METHOD    mode=MODE_SMA;

double      buf[],close[],arr[];
int         periodMA;            //MA period
double      time;
int         total,count;
CFileTxt    DetailedStatement,Statement;

input int povtor=1;        //test repeats (from 1 to 5)
//+------------------------------------------------------------------+
//| CTest base class                                                 |
//+------------------------------------------------------------------+
class CTest : public CObject
  {
private:
protected:
   int               povtoral;
   int               povtorconst;
   int               cycle;
   uint              startGTC;
   uint              endGTC;
   double            sum;
   double            N;
   string            prcod;
   string            Probar(int bar);
public:
   //+---------------------------------------------------------------+
   // class constructor
   void              CTest();
   void              Run(string strTest,string strMode,ENUM_MA_METHOD mode);
   virtual     // Testing method
   void              Test(){return;};
  };
//+------------------------------------------------------------------+
//| CTest class constructor                                          |
//+------------------------------------------------------------------+
void CTest::CTest()
  {
   povtoral=povtor;
   if(povtoral<1) povtoral=1;
   if(povtoral>5) povtoral=5;
   povtorconst=povtoral-1;
   cycle=1;
   startGTC=endGTC=0;
   sum=0;
   N=povtoral;
   ushort cod=0x25A0;
   prcod=ShortToString(cod);
  }
//+------------------------------------------------------------------+
//| Probar method                                                    |
//+------------------------------------------------------------------+
string CTest::Probar(int bar)
  {
   string str="";
   for(int i=1;i<=bar;i++) str=str+prcod;
   return(str);
  }
//+------------------------------------------------------------------+
//| Run method                                                       |
//+------------------------------------------------------------------+
void CTest::Run(string strTest,string strMode,ENUM_MA_METHOD model)
  {
   string str;
   int n_mode;

   string strMetod;
   if(model==MODE_SMA)
     {
      n_mode=0;
      mode=MODE_SMA;
      str=Probar(n_mode+1);
      strMetod="MODE_SMA";
     }
   if(model==MODE_EMA)
     {
      n_mode=5;
      mode=MODE_EMA;
      str=Probar(n_mode+1);
      strMetod="MODE_EMA";
     }
   if(model==MODE_SMMA)
     {
      n_mode=10;
      mode=MODE_SMMA;
      str=Probar(n_mode+1);
      strMetod="MODE_SMMA";
     }
   if(model==MODE_LWMA)
     {
      n_mode=15;
      mode=MODE_LWMA;
      str=Probar(n_mode+1);
      strMetod="MODE_LWMA";
     }
   ObjectSetString(0,strTest,OBJPROP_TEXT,Probar(n_mode+1));
   DetailedStatement.WriteString("  Calculation model: "+strMetod+"\n\n");
   Statement.WriteString("  Calculation model: "+strMetod+"\n\n");

   while(endGTC-startGTC<10001)
     {
      time=(double)(endGTC-startGTC)/1000/cycle;
      DetailedStatement.WriteString("     Optimization: number of passes = "+(string)cycle+
                                    "\n        Estimated time [msec] = "+(string)(endGTC-startGTC)+
                                    "\n        Estimated performance [sec] = "+(string)time+"\n\n");
      ObjectSetString(0,strMode,OBJPROP_TEXT," ~ "+DoubleToString(time,10));
      ChartRedraw();
      if(endGTC-startGTC<=0) cycle=cycle*5;
      if(endGTC-startGTC>0)
        {
         cycle=(int)(11000.0/((double)(endGTC-startGTC)/cycle));
        }
      //--- Tester: start
      startGTC=GetTickCount();
      for(int j=0;j<cycle;j++)
        {
         Test();
        }
      endGTC=GetTickCount();
      //--- Tester: finish
     }

   time=(double)(endGTC-startGTC)/1000/cycle;
   DetailedStatement.WriteString("\n     Number of passes = "+(string)cycle+" pass "+(string)povtorconst+
                                 "     Total time [msec] = "+(string)(endGTC-startGTC)+
                                 "     Performance [sec] = "+(string)time+"\n");
   sum+=time;
   ObjectSetString(0,strTest,OBJPROP_TEXT,Probar(n_mode+3));
   ObjectSetString(0,strMode,OBJPROP_TEXT,DoubleToString(time,10)+" ("+(string)(povtorconst--)+")");
   ChartRedraw();
   while(povtoral>1)
     {
      //--- Tester: start
      startGTC=GetTickCount();
      for(int j=0;j<cycle;j++)
        {
         Test();
        }
      endGTC=GetTickCount();
      //--- Tester: finish
      time=(double)(endGTC-startGTC)/1000/cycle;
      DetailedStatement.WriteString("     Number of passes = "+(string)cycle+" pass "+(string)povtorconst+
                                    "     Total time [msec] = "+(string)(endGTC-startGTC)+
                                    "     Performance [sec] = "+(string)time+"\n");
      sum+=time;
      ObjectSetString(0,strTest,OBJPROP_TEXT,Probar(n_mode+4));
      ObjectSetString(0,strMode,OBJPROP_TEXT,DoubleToString(time,10)+" ("+(string)(povtorconst--)+")");
      ChartRedraw();
      povtoral--;
     }
//--- TESTER RESULTS
   ObjectSetString(0,strTest,OBJPROP_TEXT,Probar(n_mode+5));
   if(mode==MODE_LWMA) ObjectSetString(0,strTest,OBJPROP_TEXT,OK_VARIANT);
   ObjectSetString(0,strMode,OBJPROP_TEXT,DoubleToString(sum/N,10)+OK_MODE);
   ChartRedraw();
   DetailedStatement.WriteString("\n     RESULTS for model "+strMetod+": \n"+
                                 "     Average performance [sec] = "+DoubleToString(sum/N,10)+"\n\n\n");
   Statement.WriteString("     RESULTS: \n"+
                         "     Average performance [sec] = "+DoubleToString(sum/N,10)+"\n\n\n");
  }
//+------------------------------------------------------------------+
//| CTest1                                                           |
//+------------------------------------------------------------------+
class CTest1:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_SMA(144,PERIOD_M1);};
  };
//+------------------------------------------------------------------+
//| CTest2                                                           |
//+------------------------------------------------------------------+
class CTest2:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_EMA(144,PERIOD_M1);};
  };
//+------------------------------------------------------------------+
//| CTest3                                                           |
//+------------------------------------------------------------------+
class CTest3:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_SMMA(144,PERIOD_M1);};
  };
//+------------------------------------------------------------------+
//| CTest4                                                           |
//+------------------------------------------------------------------+
class CTest4:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_LWMA(144,PERIOD_M1);};
  };
//+------------------------------------------------------------------+
//| CTest5                                                           |
//+------------------------------------------------------------------+
class CTest5:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_SMA(144,PERIOD_M5);};
  };
//+------------------------------------------------------------------+
//| CTest6                                                           |
//+------------------------------------------------------------------+
class CTest6:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_EMA(144,PERIOD_M5);};
  };
//+------------------------------------------------------------------+
//| CTest7                                                           |
//+------------------------------------------------------------------+
class CTest7:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_SMMA(144,PERIOD_M5);};
  };
//+------------------------------------------------------------------+
//| CTest8                                                           |
//+------------------------------------------------------------------+
class CTest8:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_LWMA(144,PERIOD_M5);};
  };
//+------------------------------------------------------------------+
//| CTest9                                                           |
//+------------------------------------------------------------------+
class CTest9:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_SMA(144,PERIOD_M15);};
  };
//+------------------------------------------------------------------+
//| CTest10                                                          |
//+------------------------------------------------------------------+
class CTest10:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_EMA(144,PERIOD_M15);};
  };
//+------------------------------------------------------------------+
//| CTest11                                                          |
//+------------------------------------------------------------------+
class CTest11:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_SMMA(144,PERIOD_M15);};
  };
//+------------------------------------------------------------------+
//| CTest12                                                          |
//+------------------------------------------------------------------+
class CTest12:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_LWMA(144,PERIOD_M15);};
  };
//+------------------------------------------------------------------+
//| CTest13                                                          |
//+------------------------------------------------------------------+
class CTest13:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_SMA(144,PERIOD_M30);};
  };
//+------------------------------------------------------------------+
//| CTest14                                                          |
//+------------------------------------------------------------------+
class CTest14:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_EMA(144,PERIOD_M30);};
  };
//+------------------------------------------------------------------+
//| CTest15                                                          |
//+------------------------------------------------------------------+
class CTest15:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_SMMA(144,PERIOD_M30);};
  };
//+------------------------------------------------------------------+
//| CTest16                                                          |
//+------------------------------------------------------------------+
class CTest16:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_LWMA(144,PERIOD_M30);};
  };
//+------------------------------------------------------------------+
//| CTest17                                                          |
//+------------------------------------------------------------------+
class CTest17:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_SMA(21,PERIOD_M1);};
  };
//+------------------------------------------------------------------+
//| CTest18                                                          |
//+------------------------------------------------------------------+
class CTest18:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_EMA(21,PERIOD_M1);};
  };
//+------------------------------------------------------------------+
//| CTest19                                                          |
//+------------------------------------------------------------------+
class CTest19:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_SMMA(21,PERIOD_M1);};
  };
//+------------------------------------------------------------------+
//| CTest20                                                          |
//+------------------------------------------------------------------+
class CTest20:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_LWMA(21,PERIOD_M1);};
  };
//+------------------------------------------------------------------+
//| CTest21                                                          |
//+------------------------------------------------------------------+
class CTest21:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_SMA(34,PERIOD_M1);};
  };
//+------------------------------------------------------------------+
//| CTest22                                                          |
//+------------------------------------------------------------------+
class CTest22:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_EMA(34,PERIOD_M1);};
  };
//+------------------------------------------------------------------+
//| CTest23                                                          |
//+------------------------------------------------------------------+
class CTest23:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_SMMA(34,PERIOD_M1);};
  };
//+------------------------------------------------------------------+
//| CTest24                                                          |
//+------------------------------------------------------------------+
class CTest24:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_LWMA(34,PERIOD_M1);};
  };
//+------------------------------------------------------------------+
//| CTest25                                                          |
//+------------------------------------------------------------------+
class CTest25:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_SMA(55,PERIOD_M1);};
  };
//+------------------------------------------------------------------+
//| CTest26                                                          |
//+------------------------------------------------------------------+
class CTest26:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_EMA(55,PERIOD_M1);};
  };
//+------------------------------------------------------------------+
//| CTest27                                                          |
//+------------------------------------------------------------------+
class CTest27:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_SMMA(55,PERIOD_M1);};
  };
//+------------------------------------------------------------------+
//| CTest28                                                          |
//+------------------------------------------------------------------+
class CTest28:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_LWMA(55,PERIOD_M1);};
  };
//+------------------------------------------------------------------+
//| CTest29                                                          |
//+------------------------------------------------------------------+
class CTest29:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_SMA(89,PERIOD_M1);};
  };
//+------------------------------------------------------------------+
//| CTest30                                                          |
//+------------------------------------------------------------------+
class CTest30:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_EMA(89,PERIOD_M1);};
  };
//+------------------------------------------------------------------+
//| CTest31                                                          |
//+------------------------------------------------------------------+
class CTest31:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_SMMA(89,PERIOD_M1);};
  };
//+------------------------------------------------------------------+
//| CTest32                                                          |
//+------------------------------------------------------------------+
class CTest32:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_LWMA(89,PERIOD_M1);};
  };
//+------------------------------------------------------------------+
//| CTest33                                                          |
//+------------------------------------------------------------------+
class CTest33:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_SMA(233,PERIOD_M1);};
  };
//+------------------------------------------------------------------+
//| CTest34                                                          |
//+------------------------------------------------------------------+
class CTest34:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_EMA(233,PERIOD_M1);};
  };
//+------------------------------------------------------------------+
//| CTest35                                                          |
//+------------------------------------------------------------------+
class CTest35:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_SMMA(233,PERIOD_M1);};
  };
//+------------------------------------------------------------------+
//| CTest36                                                          |
//+------------------------------------------------------------------+
class CTest36:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_LWMA(233,PERIOD_M1);};
  };
//+------------------------------------------------------------------+
//| CTest37                                                          |
//+------------------------------------------------------------------+
class CTest37:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_SMA(377,PERIOD_M1);};
  };
//+------------------------------------------------------------------+
//| CTest38                                                          |
//+------------------------------------------------------------------+
class CTest38:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_EMA(377,PERIOD_M1);};
  };
//+------------------------------------------------------------------+
//| CTest39                                                          |
//+------------------------------------------------------------------+
class CTest39:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_SMMA(377,PERIOD_M1);};
  };
//+------------------------------------------------------------------+
//| CTest40                                                          |
//+------------------------------------------------------------------+
class CTest40:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_LWMA(377,PERIOD_M1);};
  };
//+------------------------------------------------------------------+
//| CTest41                                                          |
//+------------------------------------------------------------------+
class CTest41:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_SMA(610,PERIOD_M1);};
  };
//+------------------------------------------------------------------+
//| CTest42                                                          |
//+------------------------------------------------------------------+
class CTest42:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_EMA(610,PERIOD_M1);};
  };
//+------------------------------------------------------------------+
//| CTest43                                                          |
//+------------------------------------------------------------------+
class CTest43:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_SMMA(610,PERIOD_M1);};
  };
//+------------------------------------------------------------------+
//| CTest44                                                          |
//+------------------------------------------------------------------+
class CTest44:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_LWMA(610,PERIOD_M1);};
  };
//+------------------------------------------------------------------+
//| CTest45                                                          |
//+------------------------------------------------------------------+
class CTest45:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_SMA(987,PERIOD_M1);};
  };
//+------------------------------------------------------------------+
//| CTest46                                                          |
//+------------------------------------------------------------------+
class CTest46:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_EMA(987,PERIOD_M1);};
  };
//+------------------------------------------------------------------+
//| CTest47                                                          |
//+------------------------------------------------------------------+
class CTest47:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_SMMA(987,PERIOD_M1);};
  };
//+------------------------------------------------------------------+
//| CTest48                                                          |
//+------------------------------------------------------------------+
class CTest48:public CTest
  {
public:
   virtual     // Testing method
   void              Test(){Test_LWMA(987,PERIOD_M1);};
  };
//////////////////////////////////////////////////////////////////////
//+------------------------------------------------------------------+
//| The MovingAverages tester functions                              |
//+------------------------------------------------------------------+
//+------------------------------------------------------------------+
//| Test_SMA                                      Model : MODE_SMA   |
//+------------------------------------------------------------------+
void Test_SMA(int periodMA,ENUM_TIMEFRAMES periodTF)
  {
   CopyClose(_Symbol,periodTF,0,count,close);
   int total=ArrayCopy(arr,close);
   SimpleMAOnBuffer(total,0,0,periodMA,arr,buf);
  }
//+------------------------------------------------------------------+
//| Test_EMA                                       Model: MODE_EMA   |
//+------------------------------------------------------------------+
void Test_EMA(int periodMA,ENUM_TIMEFRAMES periodTF)
  {
   CopyClose(_Symbol,periodTF,0,count,close);
   int total=ArrayCopy(arr,close);
   ExponentialMAOnBuffer(total,0,0,periodMA,arr,buf);
  }
//+------------------------------------------------------------------+
//| Test_SMMA                                      Model: MODE_SMMA  |
//+------------------------------------------------------------------+
void Test_SMMA(int periodMA,ENUM_TIMEFRAMES periodTF)
  {
   CopyClose(_Symbol,periodTF,0,count,close);
   int total=ArrayCopy(arr,close);
   SmoothedMAOnBuffer(total,0,0,periodMA,arr,buf);
  }
//+------------------------------------------------------------------+
//| Test_LWMA                                      Model: MODE_LWMA  |
//+------------------------------------------------------------------+
void Test_LWMA(int periodMA,ENUM_TIMEFRAMES periodTF)
  {
   CopyClose(_Symbol,periodTF,0,count,close);
   int total=ArrayCopy(arr,close);
   LinearWeightedMAOnBuffer(total,0,0,periodMA,arr,buf);
  }
//+------------------------------------------------------------------+
