//+------------------------------------------------------------------+
//|                                                     ClassRow.mqh |
//|                                                 Copyright DC2008 |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "DC2008"
#property link      "http://www.mql5.com"
//--- constants
#define  DELTA   1     // delta between the interface elements
//--- include file with classes
#include <ClassUnit.mqh>
#include <Arrays\ArrayString.mqh>
//////////////////////////////////////////////////////////////////////
//+------------------------------------------------------------------+
//| CRow base class                                                  |
//+------------------------------------------------------------------+
class CRow
  {
protected:
   bool              on_event;      // event processing flag
public:
   string            name;          // name of a row
   WinCell           Property;      // row properties
   //+---------------------------------------------------------------+
   // class constructor
   void              CRow();
   virtual     // Method: draw
   void              Draw(string m_name,
                          int m_xdelta,
                          int m_ydelta,
                          int m_bsize);
   virtual     // OnChartEvent event processing method
   void              OnEvent(const int id,
                             const long &lparam,
                             const double &dparam,
                             const string &sparam);
  };
//+------------------------------------------------------------------+
//| CRow class constructor                                           |
//+------------------------------------------------------------------+
void CRow::CRow()
  {
   Property.TextColor=White;
   Property.BGColor=SteelBlue;
   Property.BGEditColor=DimGray;
   Property.Corner=CORNER_LEFT_UPPER;
   Property.Corn=1;
   Property.H=18;
   on_event=false;   // disable event processing
  }
//+------------------------------------------------------------------+
//| Draw method                                                      |
//+------------------------------------------------------------------+
void CRow::Draw(string m_name,
                int m_xdelta,
                int m_ydelta,
                int m_bsize)
  {
   on_event=true;   // enable event processing
  }
//+------------------------------------------------------------------+
//| OnChartEvent event processing method                             |
//+------------------------------------------------------------------+
void CRow::OnEvent(const int id,
                   const long &lparam,
                   const double &dparam,
                   const string &sparam)
  {
   if(on_event) // event processing is enabled
     {
      //---
     }
  }
//+------------------------------------------------------------------+
//////////////////////////////////////////////////////////////////////
//+------------------------------------------------------------------+
//| CRowType1 class                                                  |
//+------------------------------------------------------------------+
class CRowType1:public CRow
  {
public:
   CCellText         Text;
   CCellButtonType   Hide,Close;
   //+---------------------------------------------------------------+
   // class constructor
   void              CRowType1();
   virtual     // Draw method
   void              Draw(string m_name,
                          int m_xdelta,
                          int m_ydelta,
                          int m_bsize,
                          int m_type,
                          string m_text);
   virtual     // OnChartEvent event processing method
   void              OnEvent(const int id,
                             const long &lparam,
                             const double &dparam,
                             const string &sparam);
  };
//+------------------------------------------------------------------+
//| CRowType1 class constructor                                      |
//+------------------------------------------------------------------+
void CRowType1::CRowType1()
  {
   on_event=false;   // disable event processing
  }
//+------------------------------------------------------------------+
//| OnChartEvent event processing method                             |
//+------------------------------------------------------------------+
void CRowType1::OnEvent(const int id,
                        const long &lparam,
                        const double &dparam,
                        const string &sparam)
  {
   if(on_event) // event processing is enabled
     {
      Text.OnEvent(id,lparam,dparam,sparam);
      Hide.OnEvent(id,lparam,dparam,sparam);
      Close.OnEvent(id,lparam,dparam,sparam);
     }
  }
//+------------------------------------------------------------------+
//| Draw method                                                      |
//+------------------------------------------------------------------+
void CRowType1::Draw(string m_name,
                     int m_xdelta,
                     int m_ydelta,
                     int m_bsize,
                     int m_type,
                     string m_text)
  {
   int      X,B;
   Text.Property=Property;
   Hide.Property=Property;
   Close.Property=Property;
//--- type 0: m_type=0
   if(m_type<=0)
     {
      name=m_name+".RowType1(0)";
      B=m_bsize-2*(Property.H+DELTA);
      Text.Draw(name,m_xdelta,m_ydelta,B,m_text);
      //---
      X=m_xdelta+Property.Corn*(B+DELTA);
      Hide.Draw(name,X,m_ydelta,0);
      //---
      X=X+Property.Corn*(Property.H+DELTA);
      Close.Draw(name,X,m_ydelta,1);
     }
//--- type 1: m_type=1
   if(m_type==1)
     {
      name=m_name+".RowType1(1)";
      B=m_bsize-(Property.H+DELTA);
      Text.Draw(name,m_xdelta,m_ydelta,B,m_text);
      //---
      X=m_xdelta+Property.Corn*(B+DELTA);
      Close.Draw(name,X,m_ydelta,1);
     }
//--- type 2: m_type=2
   if(m_type==2)
     {
      name=m_name+".RowType1(2)";
      B=m_bsize-(Property.H+DELTA);
      Text.Draw(name,m_xdelta,m_ydelta,B,m_text);
      //---
      X=m_xdelta+Property.Corn*(B+DELTA);
      Hide.Draw(name,X,m_ydelta,0);
     }
//--- type 3: m_type=3
   if(m_type>=3)
     {
      name=m_name+".RowType1(3)";
      B=m_bsize;
      Text.Draw(name,m_xdelta,m_ydelta,B,m_text);
     }
//---
   on_event=true;   // enable event processing
  }
//+------------------------------------------------------------------+
//////////////////////////////////////////////////////////////////////
//+------------------------------------------------------------------+
//| CRowType2 class                                                  |
//+------------------------------------------------------------------+
class CRowType2:public CRow
  {
public:
   CCellText         Text;
   CCellEdit         Edit;
   //+---------------------------------------------------------------+
   // class constructor
   void              CRowType2();
   virtual     // Draw method
   void              Draw(string m_name,
                          int m_xdelta,
                          int m_ydelta,
                          int m_bsize,
                          int m_tsize,
                          string m_text,
                          string m_edit);
   virtual     // OnChartEvent event processing method
   void              OnEvent(const int id,
                             const long &lparam,
                             const double &dparam,
                             const string &sparam);
  };
//+------------------------------------------------------------------+
//| CRowType2 class constructor                                      |
//+------------------------------------------------------------------+
void CRowType2::CRowType2()
  {
   on_event=false;   // disable event processing
  }
//+------------------------------------------------------------------+
//| OnChartEvent event processing method                             |
//+------------------------------------------------------------------+
void CRowType2::OnEvent(const int id,
                        const long &lparam,
                        const double &dparam,
                        const string &sparam)
  {
   if(on_event) // enable event processing
     {
      Text.OnEvent(id,lparam,dparam,sparam);
      Edit.OnEvent(id,lparam,dparam,sparam);
     }
  }
//+------------------------------------------------------------------+
//| Draw method                                                      |
//+------------------------------------------------------------------+
void CRowType2::Draw(string m_name,
                     int m_xdelta,
                     int m_ydelta,
                     int m_bsize,
                     int m_tsize,
                     string m_text,
                     string m_edit)
  {
   int      X,B;
   Text.Property=Property;
   Edit.Property=Property;
   name=m_name+".RowType2";
   Text.Draw(name,m_xdelta,m_ydelta,m_tsize,m_text);
//---
   B=m_bsize-m_tsize-DELTA;
   X=m_xdelta+Property.Corn*(m_tsize+DELTA);
   Edit.Draw(name,X,m_ydelta,B,m_edit,false);
//---
   on_event=true;   // enable event processing
  }
//+------------------------------------------------------------------+
//////////////////////////////////////////////////////////////////////
//+------------------------------------------------------------------+
//| CRowType3 class                                                  |
//+------------------------------------------------------------------+
class CRowType3:public CRow
  {
public:
   CCellText         Text;
   CCellEdit         Edit;
   CCellButtonType   Plus,Minus;
   //+---------------------------------------------------------------+
   // class constructor
   void              CRowType3();
   virtual     // Draw method
   void              Draw(string m_name,
                          int m_xdelta,
                          int m_ydelta,
                          int m_bsize,
                          int m_tsize,
                          string m_text,
                          string m_edit);
   virtual     // OnChartEvent event processing method
   void              OnEvent(const int id,
                             const long &lparam,
                             const double &dparam,
                             const string &sparam);
  };
//+------------------------------------------------------------------+
//| CRowType3 class constructor                                      |
//+------------------------------------------------------------------+
void CRowType3::CRowType3()
  {
   on_event=false;   // disable event processing
  }
//+------------------------------------------------------------------+
//| OnChartEvent event processing method                             |
//+------------------------------------------------------------------+
void CRowType3::OnEvent(const int id,
                        const long &lparam,
                        const double &dparam,
                        const string &sparam)
  {
   if(on_event) // enable event processing
     {
      Text.OnEvent(id,lparam,dparam,sparam);
      Edit.OnEvent(id,lparam,dparam,sparam);
      Plus.OnEvent(id,lparam,dparam,sparam);
      Minus.OnEvent(id,lparam,dparam,sparam);
     }
  }
//+------------------------------------------------------------------+
//| Draw method                                                      |
//+------------------------------------------------------------------+
void CRowType3::Draw(string m_name,
                     int m_xdelta,
                     int m_ydelta,
                     int m_bsize,
                     int m_tsize,
                     string m_text,
                     string m_edit)
  {
   int      X,B;
   Text.Property=Property;
   Edit.Property=Property;
   Plus.Property=Property;
   Minus.Property=Property;
   name=m_name+".RowType3";
   Text.Draw(name,m_xdelta,m_ydelta,m_tsize,m_text);
//---
   B=m_bsize-(m_tsize+DELTA)-2*(Property.H+DELTA);
   X=m_xdelta+Property.Corn*(m_tsize+DELTA);
   Edit.Draw(name,X,m_ydelta,B,m_edit,true);
//---
   X=X+Property.Corn*(B+DELTA);
   Plus.Draw(name,X,m_ydelta,3);
//---
   X=X+Property.Corn*(Property.H+DELTA);
   Minus.Draw(name,X,m_ydelta,4);
//---
   on_event=true;   // enable event processing
  }
//+------------------------------------------------------------------+
//////////////////////////////////////////////////////////////////////
//+------------------------------------------------------------------+
//| CRowType4 class                                                  |
//+------------------------------------------------------------------+
class CRowType4:public CRow
  {
public:
   CCellText         Text;
   CCellEdit         Edit;
   CCellButtonType   Plus,Minus,Up,Down;
   //+---------------------------------------------------------------+
   // Class constructor
   void              CRowType4();
   virtual     // Draw method
   void              Draw(string m_name,
                          int m_xdelta,
                          int m_ydelta,
                          int m_bsize,
                          int m_tsize,
                          string m_text,
                          string m_edit);
   virtual     // OnChartEvent event processing method
   void              OnEvent(const int id,
                             const long &lparam,
                             const double &dparam,
                             const string &sparam);
  };
//+------------------------------------------------------------------+
//| CRowType4 class constructor                                      |
//+------------------------------------------------------------------+
void CRowType4::CRowType4()
  {
   on_event=false;   // disable event processing
  }
//+------------------------------------------------------------------+
//| OnChartEvent event processing method                             |
//+------------------------------------------------------------------+
void CRowType4::OnEvent(const int id,
                        const long &lparam,
                        const double &dparam,
                        const string &sparam)
  {
   if(on_event) // enable event processing
     {
      Text.OnEvent(id,lparam,dparam,sparam);
      Edit.OnEvent(id,lparam,dparam,sparam);
      Plus.OnEvent(id,lparam,dparam,sparam);
      Minus.OnEvent(id,lparam,dparam,sparam);
      Up.OnEvent(id,lparam,dparam,sparam);
      Down.OnEvent(id,lparam,dparam,sparam);
     }
  }
//+------------------------------------------------------------------+
//| Draw method                                                      |
//+------------------------------------------------------------------+
void CRowType4::Draw(string m_name,
                     int m_xdelta,
                     int m_ydelta,
                     int m_bsize,
                     int m_tsize,
                     string m_text,
                     string m_edit)
  {
   int      X,B;
   Text.Property=Property;
   Edit.Property=Property;
   Plus.Property=Property;
   Minus.Property=Property;
   Up.Property=Property;
   Down.Property=Property;
   name=m_name+".RowType4";
   Text.Draw(name,m_xdelta,m_ydelta,m_tsize,m_text);
//---
   B=m_bsize-(m_tsize+DELTA)-4*(Property.H+DELTA);
   X=m_xdelta+Property.Corn*(m_tsize+DELTA);
   Edit.Draw(name,X,m_ydelta,B,m_edit,true);
//---
   X=X+Property.Corn*(B+DELTA);
   Plus.Draw(name,X,m_ydelta,3);
//---
   X=X+Property.Corn*(Property.H+DELTA);
   Minus.Draw(name,X,m_ydelta,4);
//---
   X=X+Property.Corn*(Property.H+DELTA);
   Up.Draw(name,X,m_ydelta,5);
//---
   X=X+Property.Corn*(Property.H+DELTA);
   Down.Draw(name,X,m_ydelta,6);
//---
   on_event=true;   // enable event processing
  }
//+------------------------------------------------------------------+
//////////////////////////////////////////////////////////////////////
//+------------------------------------------------------------------+
//| CRowType5 class                                                  |
//+------------------------------------------------------------------+
class CRowType5:public CRow
  {
public:
   CCellText         Text;
   CCellButton       Button;
   //+---------------------------------------------------------------+
   // class constructor
   void              CRowType5();
   virtual     // draw method
   void              Draw(string m_name,
                          int m_xdelta,
                          int m_ydelta,
                          int m_bsize,
                          int m_csize,
                          string m_text,
                          string m_button);
   virtual     // OnChartEvent event processing method
   void              OnEvent(const int id,
                             const long &lparam,
                             const double &dparam,
                             const string &sparam);
  };
//+------------------------------------------------------------------+
//| CRowType5 class constructor                                      |
//+------------------------------------------------------------------+
void CRowType5::CRowType5()
  {
   on_event=false;   // disable event processing
  }
//+------------------------------------------------------------------+
//| OnChartEvent event processing method                             |
//+------------------------------------------------------------------+
void CRowType5::OnEvent(const int id,
                        const long &lparam,
                        const double &dparam,
                        const string &sparam)
  {
   if(on_event) // enable event processing
     {
      Text.OnEvent(id,lparam,dparam,sparam);
      Button.OnEvent(id,lparam,dparam,sparam);
     }
  }
//+------------------------------------------------------------------+
//| Draw method                                                      |
//+------------------------------------------------------------------+
void CRowType5::Draw(string m_name,
                     int m_xdelta,
                     int m_ydelta,
                     int m_bsize,
                     int m_csize,
                     string m_text,
                     string m_button)
  {
   int      X,B;
   Text.Property=Property;
   Button.Property=Property;
   name=m_name+".RowType5";
   Text.Draw(name,m_xdelta,m_ydelta,m_csize,m_text);
//---
   B=m_bsize-m_csize-DELTA;
   X=m_xdelta+Property.Corn*(m_csize+DELTA);
   Button.Draw(name,X,m_ydelta,B,m_button);
//---
   on_event=true;   // enable event processing
  }
//+------------------------------------------------------------------+
//////////////////////////////////////////////////////////////////////
//+------------------------------------------------------------------+
//| CRowType6 class                                                  |
//+------------------------------------------------------------------+
class CRowType6:public CRow
  {
public:
   CCellButton       Button;
   //+---------------------------------------------------------------+
   // class constructor
   void              CRowType6();
   virtual     // method: draw row
   void              Draw(string m_name,
                          int m_xdelta,
                          int m_ydelta,
                          int m_bsize,
                          int m_b1size,
                          int m_b2size,
                          string m_button1,
                          string m_button2,
                          string m_button3);
   virtual     // OnChartEvent event processing method
   void              OnEvent(const int id,
                             const long &lparam,
                             const double &dparam,
                             const string &sparam);
  };
//+------------------------------------------------------------------+
//| CRowType6 class constructor                                      |
//+------------------------------------------------------------------+
void CRowType6::CRowType6()
  {
   on_event=false;   // disable event processing
  }
//+------------------------------------------------------------------+
//| OnChartEvent event processing method                             |
//+------------------------------------------------------------------+
void CRowType6::OnEvent(const int id,
                        const long &lparam,
                        const double &dparam,
                        const string &sparam)
  {
   if(on_event) // enable event processing
     {
      Button.OnEvent(id,lparam,dparam,sparam);
     }
  }
//+------------------------------------------------------------------+
//| Draw method                                                      |
//+------------------------------------------------------------------+
void CRowType6::Draw(string m_name,
                     int m_xdelta,
                     int m_ydelta,
                     int m_bsize,
                     int m_b1size,
                     int m_b2size,
                     string m_button1,
                     string m_button2,
                     string m_button3
                     )
  {
   int      X,B;
   Button.Property=Property;
//---
   name=m_name+".RowType6(1)";
   B=m_b1size;
   X=m_xdelta;
   Button.Draw(name,X,m_ydelta,B,m_button1);
//---
   name=m_name+".RowType6(2)";
   B=m_b2size;
   X=X+Property.Corn*(m_b1size+DELTA);
   Button.Draw(name,X,m_ydelta,B,m_button2);
//---
   name=m_name+".RowType6(3)";
   B=m_bsize-(m_b1size+DELTA)-(m_b2size+DELTA);
   X=X+Property.Corn*(m_b2size+DELTA);
   Button.Draw(name,X,m_ydelta,B,m_button3);
//+------------------------------------------------------------------+
   on_event=true;   // enable event processing
  }
//+------------------------------------------------------------------+
