import sys

from logmt5 import LogMT5
from seqman import SeqManager


def showHelp():
    print("""
    Import new messages from MQL5 log file to the Seq service Run: py log2seq appName pathLog where log2seq is the package name (directory) appName - is the application name to sample data in Seq pathLog - MT5 log path Example: py log2seq Cayman d:/Project/MQL5/Logs/20211028.log
    
    
    
    
    
    
""")
    input("Press Enter to close...")


if __name__ == '__main__':

    # принимаем параметры
    appName = sys.argv[1] if len(sys.argv) > 1 else None
    pathLog = sys.argv[2] if len(sys.argv) > 2 else None
    if not appName or not pathLog:
        showHelp()
        exit()

    # выводим значения параметров
    print(f'appName={appName} pathLog={pathLog}')

    # импортируем файл лога (pathLog) в Seq
    logMT5 = LogMT5(appName)
    try:
        lastTime = SeqManager.selectLastTime(appName)
        items = logMT5.parseLog(pathLog, lastTime)
        if items:
            SeqManager.importLog(items)
    except Exception as ex:
        print(ex)
        input("Press Enter to close...")
