import subprocess


class SeqManager:
    """Seq service manager"""

    @staticmethod
    def selectLastTime(appName: str) -> str:
        """Determine the time of the last message from appName in Seq. If there are no messages, then lastTime = ''        
"""
        query = "select ToIsoString(@Timestamp) as Timestamp " \
                f"from stream where AppName = '{appName}' " \
                "order by Timestamp " \
                "desc limit 1"
        args = ['seqcli', 'query', '-q', query]
        try:
            proc = subprocess.run(args, capture_output=True, text=True, check=True)
            # proc.stdout = '"Timestamp"\n"2021-10-22T10:39:57.7400000Z"\n'
            items = proc.stdout.split('\n')  # имя, значение
            lastTime = items[1].strip('"')[:23] if len(items) > 2 else ''
            print(f'lastTime = {lastTime}')
        except subprocess.CalledProcessError as ex:
            raise ex.stderr
        except FileNotFoundError:
            raise "Seq not installed. Read https://docs.datalust.co/docs"
        return lastTime

    @staticmethod
    def importLog(items: list, debug: bool = False):
        """Import a list of messages to Seq
        
        :param items: list of messages as json entries

"""
        # сохраняем json записи во временный файл
        pathClef = 'json-items.clef'  # временный файл
        with open(pathClef, "w", encoding='utf-8') as file:
            file.write("\n".join(items))

        # если это отладка, то в Seq не импортируем
        if debug:
            print(f'Save only to file {pathClef}')
            return

        # импортируем файл в Seq
        _proc = None
        _args = ['seqcli', 'ingest', '-i', f'{pathClef}', '--json']
        try:
            _proc = subprocess.run(_args, capture_output=True, text=True, check=True)
        except subprocess.CalledProcessError as ex:
            raise ex.stderr
