from dataclasses import dataclass

# словарь расшифровки уровней
dictLevel: dict = {
    "DBG:": "Debug",
    "INF:": "Information",
    "WRN:": "Warning",
    "ERR:": "Error",
    "FTL:": "Fatal"}


@dataclass
class LogItem:
    """Log file entry structure"""
    stime: str  # время сообщения
    module: str  # имя модуля(файла) отправителя сообщения
    sender: str  # имя функции отправителя сообщения
    symbol: str  # символ
    period: str  # период
    level: str  # уровень сообщения
    message: str  # текст сообщения

    def toJson(self, appName: str) -> str:
        """Convert log entry to JSON format
        
        :param appName: application name :return: json representation of the entry
        

"""
        json = ' '.join(
            (f'"@t": "{self.stime}Z", "AppName": "{appName}",',
             f'"Symbol": "{self.symbol}", "Period": "{self.period}",',
             f'"Module": "{self.module}", "Sender": "{self.sender}",',
             f'"Level": "{self.level}", "@l": "{dictLevel[self.level]}", "Message": "{self.message}",',
             f'"@m": "{self.symbol}, {self.period} / {self.module} / {self.sender} / {self.message}"')
        )
        return "{" + json + "}"
