// 
//|                        Digital Low Pass (FATL/SATL, KGLP) Filter          |
//|                      Copyright (c) Sergey Iljukhin, Novosibirsk.          |
//|                       email sergey[at]tibet.ru http://fx.qrz.ru/          |
//|    faa1947:                                                 |
//|                                                 |
//|                                                                  |
//|                                                                |
//|     24.02.2010                                                    |
// 
#property copyright "Copyright (c) 2005, Sergey Iljukhin, Novosibirsk"
#property link      "http://fx.qrz.ru/"
// ----------------   ----------------------------------
#import  "DF.dll"
int      DigitalFilter(int      FType,
                       int      P1,
                       int      D1,
                       int      A1,
                       int      P2,
                       int      D2,
                       int      A2,
                       double   Ripple,
                       int      Delay,
                       double  &arr[]);
#import
//  --------------     ----------------------------------
#property indicator_chart_window
// ---------------- -    -------------------------
#property indicator_buffers               4
// ----------------    --------------------------------
#property   indicator_color1              Gold
#property   indicator_color2              Red
#property   indicator_color3              LightSeaGreen
#property   indicator_color4              LightSeaGreen
// ----------------    -----------------------------------
#property   indicator_width1              2
#property   indicator_width2              2
#property   indicator_width3              1
#property   indicator_width4              1
//-----------------    ==========--------------------
extern   double   BandsDeviations         =  0.7;     //   
extern   int      BadsPeriod              =  14;      //     
int      BandsShift              =  0;       //   
                                             // -------------------    ------------------------------
int      FType=0;
//                                            : 
//                                              0 -  (FATL/SATL/KGLP), 
//                                              1 -  (KGHP), 
//                                              2 -  (RBCI/KGBP), 
//                                              3 -  (KGBS)
extern   int      P1          =  40;   //  
extern   int      D1          =  31;   //    , 
extern   int      A1          =  50;   //     , 
int      P2          =  0;    //  , 
int      D2          =  0;    //     ,
int      A2          =  0;    //    , 
double   Ripple=0.0864; //    , 
extern   int      Delay       =  0;    //   
int      BarShift    =  0;    //  , .  - ,  - 
extern   int      Deviation   =  0;    //   -           
string   _pr         =  " 0-cl,1-op,2-hi,3-lo,4-med,5-typ,6-wtd";
extern   int      _price      =  0;

// ---------------   -------------------------------------------
double   FilterBuffer[];
double   long1[];
double   short1[];
double   UpperBuffer[];
double   LowerBuffer[];
double   trend[];
// ---------------   -----------------------------------------
int      FilterOrder;
double   F[1000];
int      tf;
// 
//| Digital filter indicator initialization function                          |
// 
int init()
  {
// ------------------------      ---
   FilterOrder=DigitalFilter(FType,
                             P1,
                             D1,
                             A1,
                             P2,
                             D2,
                             A2,
                             Ripple,
                             Delay,
                             F);
// --------------- -   ----------------------------------   
   IndicatorBuffers(6);
//----------    -----------------------------------
   SetIndexStyle(0,DRAW_LINE,STYLE_SOLID,2);
   SetIndexStyle(1,DRAW_LINE,STYLE_SOLID,2);

   SetIndexDrawBegin(0,FilterOrder);
   SetIndexDrawBegin(1,FilterOrder);

   SetIndexStyle(2,DRAW_LINE);
   SetIndexDrawBegin(2,FilterOrder);
   SetIndexStyle(3,DRAW_LINE);
   SetIndexDrawBegin(3,FilterOrder+1);

// -----------------      -----------------------
   SetIndexBuffer          (0,   long1);               //  
   SetIndexBuffer          (1,   short1);              //  

   SetIndexBuffer          (2,   UpperBuffer);        //  
   SetIndexBuffer          (3,   LowerBuffer);        //  

   SetIndexBuffer          (4,   FilterBuffer);       //  
   SetIndexBuffer          (5,   trend);              //  

   SetIndexEmptyValue      (0,   0.0);
   SetIndexEmptyValue      (1,   0.0);
   SetIndexEmptyValue      (2,   0.0);
   SetIndexEmptyValue      (3,   0.0);

   IndicatorShortName("FilterBands");
//------------------     ---------------------
   SetIndexLabel(0,"SATL-long");
   SetIndexLabel(1,"SATL_short");
   SetIndexLabel(2,"long");
   SetIndexLabel(3,"short");
//----
   tf=Period();
   return(0);
  }
// 
//| Digital filter main function                                              |
// 
int start()
  {
   static   int      prevTF=0;
   int      i,j,k;
   double   res               =  0;
   double   deviation;
   double   sum,
   oldval,
   newres;
//----
   if(Bars<=FilterOrder) return(0);
//----
   int counted_bars = IndicatorCounted();
   if(counted_bars < 0)  return(-1);
   if(counted_bars > 0)   counted_bars--;
   int limit = Bars - counted_bars;
   if(counted_bars==0) limit-=1+FilterOrder+1;   
   
// ---    -     -----

   i=limit;
   if(iTime(NULL,tf,1)!=prevTF)
     {
      prevTF=iTime(NULL,tf,1);
      while(i>=0)
        {
         res=0;
         for(j=0; j<FilterOrder; j++)
            res+=F[j]  *price(i+j);
         // ---------------- ,   Deviation ---------------------------
         //         FilterBuffer[i]    =  (1.5  *  response             + 
         //                                1.0  *  FilterBuffer[i+1]    + 
         //                                0.5  *  FilterBuffer[i+2])   / 3;
         // ---------------------   ------------------------------------         
         FilterBuffer[i]=NormalizeDouble(res,Digits);
         if(MathAbs(FilterBuffer[i]-FilterBuffer[i+1])<
            Deviation   *Point)
            FilterBuffer[i]=FilterBuffer[i+1];
/*
// -------------------  ----------------------------------------------
            if(FilterBuffer[i]   <=  FilterBuffer[i+1])
            {
               long[i]             =  0.0;
               short[i]             =  response;
            }
            else
            {
               long[i]             =  response;
               short[i]             =  0.0;
            }
 --------------------   ---------------------------------------*/
         sum               =  0.0;
         k                 =  i  +  BadsPeriod -  1;
         oldval            =  FilterBuffer[i];
         while(k>=i)
           {
            newres=price(k)-oldval;
            sum+=newres   *newres;
            k--;
           }
         deviation         =  BandsDeviations   *  MathSqrt(sum   /  BadsPeriod);
         UpperBuffer[i]    =  oldval   +  deviation;
         LowerBuffer[i]    =  oldval   -  deviation;
         i--;
        }
      // <--  
      for(int x=limit; x>=0; x--)
        {
         trend[x]=trend[x+1];
         if(FilterBuffer[x]>FilterBuffer[x+1])
            trend[x]=1;
         if(FilterBuffer[x]<FilterBuffer[x+1])
            trend[x]=-1;

         if(trend[x]>0)
           {
            long1[x]=FilterBuffer[x];
            if(trend[x+1]<0)
               long1[x+1]                  =  FilterBuffer[x+1];
            short1[x]                      =  0.0;
           }
         else
         if(trend[x]<0)
           {
            short1[x]=FilterBuffer[x];
            if(trend[x+1]>0)
               short1[x+1]              =  FilterBuffer[x+1];
            long1[x]                    =  0.0;
           }
        }
      //  -->
      //-------------------------------------------------------------------------
     }
   return(0);
  }
// -------------       ----------------------------
double price(int i=0)
  {
   double   rrr;
   if(_price==0)
      return(iClose(Symbol(),tf,i));
   if(_price==1)
      return(iOpen(Symbol(),tf,i));
   if(_price==2)
      return(iHigh(Symbol(),tf,i));
   if(_price==3)
      return(iLow(Symbol(),tf,i));
   if(_price==4)
     {
      rrr=(iLow(Symbol(),tf,i)+
           iHigh(Symbol(),tf,i))/2;
      return(rrr);
     }
   if(_price==5)
     {
      rrr=(iLow(Symbol(),tf,i)+
           iClose(Symbol(),tf,i)+
           iHigh(Symbol(),tf,i))/3;  // 
      return(rrr);
     }
   if(_price==6)
     {
      rrr=(iLow(Symbol(),tf,i)+
           iClose(Symbol(),tf,i)+
           iClose(Symbol(),tf,i)+
           iHigh(Symbol(),tf,i))/4; //   
      return(rrr);
     }
   return(iClose(Symbol(),tf,i));
  }

// 

/*

     MetaTrader 4.
 
  !      DLL 
      - bdsp.dll, lapack.dll, mkl_sport.dll,
       C:\Windows\System32\ 
     DF.dll  \experts\libraries\
 
    :
  
  1.    "Allow DLL import"  "Confirm DLL function's call"   Options->Expert Advisors
  2.    C:\Windows\System32\  Bdsp.dll, lapack.dll, mkl_support.dll -   . 
 
    :
  
  Ftype -  : 0 -  (FATL/SATL/KGLP), 1 -  (KGHP), 
          2 -  (RBCI/KGBP), 3 -  (KGBS)
  P1 -      P1, 
  D1 -        D1, 
  A1 -        1, 
  P2 -      P2, 
  D2 -        D2, 
  A2 -        2, 
  Ripple -    , 
  Delay - , 

        P2,D2,A2 
   :
  : P1>D1
  : P1<D1
    : D2>P2>P1>D1

*/
//+------------------------------------------------------------------+
