//+------------------------------------------------------------------+
//|                                              HighLowRainbow1.mq4 |
//|                                Copyright  2010, Investors Haven |
//|                                    http://www.InvestorsHaven.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2010, Investors Haven"
#property link      "http://www.InvestorsHaven.com"

#property indicator_chart_window
#property indicator_buffers 8
#property indicator_color1 Purple            // Sets the colors of the first
#property indicator_color2 Purple            // 8 lines of the 24 line set
#property indicator_color3 MediumTurquoise
#property indicator_color4 MediumTurquoise
#property indicator_color5 Lime
#property indicator_color6 Lime
#property indicator_color7 Gold
#property indicator_color8 Gold
#property indicator_width1 3           // Sets the width of the lins in pixels
#property indicator_width2 3
#property indicator_width3 3
#property indicator_width4 3
#property indicator_width5 3
#property indicator_width6 3
#property indicator_width7 3
#property indicator_width8 3


int BandsPeriod = 20;                        // sets an initial amount on the
//---- buffers                               // lines prior to displaying them
double MonthHigh[];                          // Array buffer for Months High
double MonthLow[];                           // Array buffer for Months Low
double WeekHigh[];                           // Array buffer for Weeks High
double WeekLow[];                            // Array buffer for Weeks low
double DailyHigh[];                          // Array buffer for Days High
double DailyLow[];                           // Array buffer for Days low
double Hour4High[];                          // Array buffer for 4 Hour high
double Hour4Low[];                           // Array buffer for 4 Hour Low
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0,DRAW_LINE);         // Section draws the lines for each
   SetIndexBuffer(0,MonthHigh);
   SetIndexStyle(1,DRAW_LINE);
   SetIndexBuffer(1,MonthLow);
   SetIndexStyle(2,DRAW_LINE);
   SetIndexBuffer(2,WeekHigh);
   SetIndexStyle(3,DRAW_LINE);
   SetIndexBuffer(3,WeekLow);
   SetIndexStyle(4,DRAW_LINE);
   SetIndexBuffer(4,DailyHigh);
   SetIndexStyle(5,DRAW_LINE);
   SetIndexBuffer(5,DailyLow);
   SetIndexStyle(6,DRAW_LINE);
   SetIndexBuffer(6,Hour4High);
   SetIndexStyle(7,DRAW_LINE);
   SetIndexBuffer(7,Hour4Low);
   
   SetIndexDrawBegin(0,BandsPeriod);      // Sets the lines starting point
   SetIndexDrawBegin(1,BandsPeriod);
   SetIndexDrawBegin(2,BandsPeriod);
   SetIndexDrawBegin(3,BandsPeriod);
   SetIndexDrawBegin(4,BandsPeriod);
   SetIndexDrawBegin(5,BandsPeriod);
   SetIndexDrawBegin(6,BandsPeriod);
   SetIndexDrawBegin(7,BandsPeriod);
   
   SetIndexLabel(0,"Month High");         // Label the lines for easy reading
   SetIndexLabel(1,"Month Low");
   SetIndexLabel(2,"Week High");
   SetIndexLabel(3,"Week Low");
   SetIndexLabel(4,"Daily High");
   SetIndexLabel(5,"Daily Low");
   SetIndexLabel(6,"4Hour High");
   SetIndexLabel(7,"4Hour Low");
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
//----
   if(Bars<=BandsPeriod) return(0);     // exit if we don't have enough bars
   
   int    i,counted_bars=IndicatorCounted();   // Init variables
   
   //---- initial zero
   if(counted_bars<1)                        // No bars have been counted
   {
      for(i=1;i<=BandsPeriod;i++)            // Loop through assigning
        {                                    // all lines to empty
            MonthHigh[Bars-i]=EMPTY_VALUE;   // so lines are  clean
            MonthLow[Bars-i]=EMPTY_VALUE;
            WeekHigh[Bars-i]=EMPTY_VALUE;
            WeekLow[Bars-i]=EMPTY_VALUE;
            DailyHigh[Bars-i]=EMPTY_VALUE;
            DailyLow[Bars-i]=EMPTY_VALUE;
            Hour4High[Bars-i]=EMPTY_VALUE;
            Hour4Low[Bars-i]=EMPTY_VALUE;        
        }
     }
     
   int limit=Bars-counted_bars;              // determine our limit
   if(counted_bars>0) limit++;               // Track our limit as we count
   for(i=0; i<limit; i++)                    // Now loop through and assign
   {                                         // price values to lines via buffers
      MonthHigh[i]= iHigh(NULL,PERIOD_MN1,0);// get high for month
      MonthLow[i]= iLow(NULL,PERIOD_MN1,0);  // get low for month
      WeekHigh[i]= iHigh(NULL,PERIOD_W1,0);  // get high for week
      WeekLow[i]= iLow(NULL,PERIOD_W1,0);    // get low for week
      DailyHigh[i]= iHigh(NULL,PERIOD_D1,0); // get high for daily
      DailyLow[i]= iLow(NULL,PERIOD_D1,0);   // get low for daily
      Hour4High[i]= iHigh(NULL,PERIOD_H4,0); // get high for 4 hour
      Hour4Low[i]= iLow(NULL,PERIOD_H4,0);   // get low for 4 hour
  }

   
//----
   return(0);
  }
//+------------------------------------------------------------------+