//+------------------------------------------------------------------+
//|                                               HighLowRainbow.mq4 |
//|                                Copyright  2010, Investors Haven |
//|                                    http://www.InvestorsHaven.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2010, Investors Haven"
#property link      "http://www.InvestorsHaven.com"

#property indicator_chart_window
#property indicator_buffers 8
#property indicator_color1 Purple            // Sets the colors of the last
#property indicator_color2 MediumTurquoise   // 8 lines of the 24 line set
#property indicator_color3 Lime
#property indicator_color4 Gold
#property indicator_color5 Blue
#property indicator_color6 HotPink
#property indicator_color7 Orange
#property indicator_color8 Orchid

#property indicator_width1 1        // Sets the width of the lins in pixels
#property indicator_width2 1
#property indicator_width3 1
#property indicator_width4 1
#property indicator_width5 1
#property indicator_width6 1
#property indicator_width7 1
#property indicator_width8 1


int BandsPeriod = 20;                  // sets an initial amount on the
//---- buffers                         // lines prior to displaying them
double MonthMedian[];                  // Array buffer for Months median
double WeekMedian[];                   // Array buffer for Weeks median
double DailyMedian[];                  // Array buffer for Days median
double Hour4Median[];                  // Array buffer for 4 Hour median
double Hour1Median[];                  // Array buffer for 1 Hour median
double M30Median[];                    // Array buffer for 30 Minute median
double M15Median[];                    // Array buffer for 15 Minute median
double M5Median[];                     // Array buffer for 5 Minute median
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0,DRAW_LINE, 1);         // Section draws the lines for each
   SetIndexBuffer(0,MonthMedian);
      SetIndexStyle(1,DRAW_LINE, 1);
   SetIndexBuffer(1,WeekMedian);
   SetIndexStyle(2,DRAW_LINE, 1);
   SetIndexBuffer(2,DailyMedian);
   SetIndexStyle(3,DRAW_LINE, 1);
   SetIndexBuffer(3,Hour4Median);
   SetIndexStyle(4,DRAW_LINE, 1);
   SetIndexBuffer(4,Hour1Median);
   SetIndexStyle(5,DRAW_LINE, 1);
   SetIndexBuffer(5,M30Median);
   SetIndexStyle(6,DRAW_LINE, 1);
   SetIndexBuffer(6,M15Median);
   SetIndexStyle(7,DRAW_LINE, 1);
   SetIndexBuffer(7,M5Median);


   
   SetIndexDrawBegin(0,BandsPeriod);         // Sets the lines starting point
   SetIndexDrawBegin(1,BandsPeriod);
   SetIndexDrawBegin(2,BandsPeriod);
   SetIndexDrawBegin(3,BandsPeriod);
   SetIndexDrawBegin(4,BandsPeriod);
   SetIndexDrawBegin(5,BandsPeriod);
   SetIndexDrawBegin(6,BandsPeriod);
   SetIndexDrawBegin(7,BandsPeriod);

   SetIndexLabel(0,"Month Median");    // Label the lines for easy reading
   SetIndexLabel(1,"Week Median");
   SetIndexLabel(2,"Daily Median");
   SetIndexLabel(3,"4Hour Median");
   SetIndexLabel(4,"1Hour Median");
   SetIndexLabel(5,"30Min Median");
   SetIndexLabel(6,"15Min Median");
   SetIndexLabel(7,"5Min Median");
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
//----
   if(Bars<=BandsPeriod) return(0);    // exit if we don't have enough bars
   
   int    i,counted_bars=IndicatorCounted();          // Init variables
   
   //---- initial zero
   if(counted_bars<1)                       // No bars have been counted
   {
      for(i=1;i<=BandsPeriod;i++)            // Loop through assigning
        {                                    // all lines to empty
            MonthMedian[Bars-i]=EMPTY_VALUE; // so lines are  clean
            WeekMedian[Bars-i]=EMPTY_VALUE;
            DailyMedian[Bars-i]=EMPTY_VALUE;
            Hour4Median[Bars-i]=EMPTY_VALUE;
            Hour1Median[Bars-i]=EMPTY_VALUE;
            M30Median[Bars-i]=EMPTY_VALUE;
            M15Median[Bars-i]=EMPTY_VALUE;
            M5Median[Bars-i]=EMPTY_VALUE;
        }
     }
     
   int limit=Bars-counted_bars;              // determine our limit
   if(counted_bars>0) limit++;               // Track our limit as we count
   for(i=0; i<limit; i++)                    // price values to lines via buffers
   {
   
      /*
         To get to the median, we take the value of the high and subtract the value of the low, then we
         divide the result by 2 and then add it to the low.
         (High - Low)/2 + Low
     */
                                       // get median for month
      MonthMedian[i]= (((iHigh(NULL,PERIOD_MN1,0) - iLow(NULL,PERIOD_MN1,0))/2) + iLow(NULL,PERIOD_MN1,0));
                                       // get median for week
      WeekMedian[i]= (((iHigh(NULL,PERIOD_W1,0) - iLow(NULL,PERIOD_W1,0))/2) + iLow(NULL,PERIOD_W1,0));
                                       // get median for daily
      DailyMedian[i]= (((iHigh(NULL,PERIOD_D1,0) - iLow(NULL,PERIOD_D1,0))/2) + iLow(NULL,PERIOD_D1,0));
                                       // get median for 4 hour
      Hour4Median[i]= (((iHigh(NULL,PERIOD_H4,0) - iLow(NULL,PERIOD_H4,0))/2) + iLow(NULL,PERIOD_H4,0));
                                       // get median for 1 hour
      Hour1Median[i]= (((iHigh(NULL,PERIOD_H1,0) - iLow(NULL,PERIOD_H1,0))/2) + iLow(NULL,PERIOD_H1,0));
                                       // get median for 30 min
      M30Median[i]= (((iHigh(NULL,PERIOD_M30,0) - iLow(NULL,PERIOD_M30,0))/2) + iLow(NULL,PERIOD_M30,0));
                                       // get median for 15 min
      M15Median[i]= (((iHigh(NULL,PERIOD_M15,0) - iLow(NULL,PERIOD_M15,0))/2) + iLow(NULL,PERIOD_M15,0));
                                       // get median for 5 min
      M5Median[i]= (((iHigh(NULL,PERIOD_M5,0) - iLow(NULL,PERIOD_M5,0))/2) + iLow(NULL,PERIOD_M5,0));
  }

   
//----
   return(0);
  }
//+------------------------------------------------------------------+