//+------------------------------------------------------------------+
//|                                                         test.mq5 |
//|                        Copyright 2012, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2012, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"

#include <Statistics.mqh>
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
//--- specifying two values samples.
   double arrX[10]={3,4,5,2,3,4,5,6,4,7};
   double arrY[10]={7,4,1,2,1,6,9,2,1,5};
//--- calculating the mean
   double mx=Average(arrX);
   double my=Average(arrY);
//--- using the mean to calculate the variance
   double dx = Variance(arrX,mx);
   double dy = Variance(arrY,my);
//--- asymmetry value and excess
   double as=Asymmetry(arrX,mx,dx);
   double exc=Excess(arrX,mx,dx);
//--- covariation and correlation values
   double cov=Cov(arrX,arrY,mx,my);
   double corr=Corr(cov,dx,dy);
//--- showing results in the log file
   PrintFormat("mx=%.6e",mx);
   PrintFormat("my=%.6e",my);
   PrintFormat("dx=%.6e",dx);
   PrintFormat("dy=%.6e",dy);
   PrintFormat("As=%.6e",as);
   PrintFormat("exc=%.6e",exc);
   PrintFormat("cov=%.6e",cov);
   PrintFormat("corr=%.6e",corr);
  }
//+------------------------------------------------------------------+
