//+------------------------------------------------------------------+
//|                                    |
//|                                      ObjectGetValueByCurrent.mq4 |
//|                                          Aleksandr Pak, Alma-Ata |
//|                                                   ekr-ap@mail.ru |
//+------------------------------------------------------------------+
#property copyright "Aleksandr Pak, Alma-Ata"
#property link      "ekr-ap@mail.ru"

//+------------------------------------------------------------------+
//| script program start function                                    |
//+------------------------------------------------------------------+
/*
       
*/

string d="Demo Line";
int init()
{
      if(ObjectFind(d)!=0)
      ObjectCreate(d,OBJ_TREND,0, iTime(NULL,0,7),WindowPriceMax(0), iTime(NULL,0,0)+15*60*Period(),WindowPriceMin(0));
      WindowRedraw();
}

int deinit()
{
ObjectDelete("Demo");
ObjectDelete("Demo Line");
return (0);
}


int start()
  {
 
   double t2,t=TimeLocal()-5;
   int i=0;
   
   while(i<300)
   { if(IsStopped()) return(0);
   
  
   t2=TimeLocal();
   if(t2-t>=5) 
      { 
      
      i+=1;
      t=TimeLocal();
      RefreshRates();  
      double rb=ObjectGetValueByShift (d,0);
      if(rb!=0) rb+=ObjectGetDelta_PerBar(d);
      
      Print( "[0]=",iTime(Symbol(),0,0), 
      " [0]=", ObjectGetValueByShift (d,0),
      "    0 =",DoubleToStr(ObjectGetValue_ByCurrent (d,0),Digits+2),
      "  (- 1)=",DoubleToStr(rb,Digits+2),
      " delta  (1) =",DoubleToStr(ObjectGetDelta_PerBar(d),Digits+2),
      " delta  (2) =",DoubleToStr(ObjectGetDelta_ByTimeShift(d,2*60*Period()),Digits+2));
      }
   }  
   Print(" ");
   return(0);
  }
//+------------------------------------------------------------------+
//*******************************
double ObjectGetValue_ByCurrent(string c, int shift) //Value of 
{

double r=ObjectGetValueByShift (c,shift);
      if(r!=0) return(NormalizeDouble(r+ObjectGetDelta_ByCurrent(c),Digits)); else return(0);
}
//*******************************

double ObjectGetDelta_PerBar(string c) //Increment of Y-ordinate per Bar
{ 
 double p= ObjectGet(c,OBJPROP_PRICE1);
 double p2= ObjectGet(c,OBJPROP_PRICE2);
 double tf=60*Period();
 double b=ObjectGet(c,OBJPROP_TIME1);
 double b2=ObjectGet(c,OBJPROP_TIME2);
 double z=(b2-b)/tf;
       if(z!=0)
         {
         double delta=(p2-p)/z;
         }
 
 return(delta);
 
}

//***************************************
double ObjectGetDelta_ByCurrent(string c)
{ 
 
      double t=TimeCurrent()-iTime(Symbol(),0,0);
      double tf=60*Period();
      double delta=ObjectGetDelta_PerBar(c);
      double r=delta*(t/tf);
/* */      Print("                =",DoubleToStr(100*t/tf,0),"%", 
/* */      "                                   =",DoubleToStr(r,Digits+2));

 return(r);
 
}
//****************************************************************************
double ObjectGetDelta_ByTimeShift(string c, double t) //t=TimeShift  
{ 
      double tf=60*Period();
      double delta=ObjectGetDelta_PerBar(c);
      double r=delta*(t/tf); 
 return(r);
 
}











