//+------------------------------------------------------------------+
//|                                                    Z-include.mq4 |
//|                      Copyright  2007, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.ru/ |
//+------------------------------------------------------------------+
#property copyright "Copyright  2007, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.ru/"
#property strict
#include <Arrays\ArrayInt.mqh>
#include <Arrays\ArrayDouble.mqh>
//+------------------------------------------------------------------+
//|   : (0)  (1).                     |
//+------------------------------------------------------------------+
int Sign(const double x)
  {
   if(x>=0)
     {
      //---  ,  '0'
      return (0);
     }
   else
     {
      //---  ,  '1'
      return (1);
     }
  }
//+------------------------------------------------------------------+
//|                                     |
//+------------------------------------------------------------------+
CArrayDouble *GetStatFromSeria(double &Array[])
  {
   CArrayDouble *Results=new CArrayDouble();
   int N=ArraySize(Array);
   if(N==0)
     {
      //---  
      return (NULL);
     }
   double Skewness;                                   // 
   double Kurtosis;                                   // 
   double mA;                                         //   
   double mE;                                         //   
   double Max=Array[ArrayMaximum(Array)];             // 
   double Min=Array[ArrayMinimum(Array)];             // 
   double MO=iMAOnArray(Array,0,N,0,MODE_SMA,0);      //  
   double Std=iStdDevOnArray(Array,0,N,0,MODE_SMA,0); //                              
   double Sigma;                                      //  
   double Sum_In2=MathPow(Array[0]-MO,2.0);           //  
   double Sum_In3=MathPow(Array[0]-MO,3.0);           //  
   double Sum_In4=MathPow(Array[0]-MO,4.0);           //    
   CArrayInt *Seria=new CArrayInt();                  //    
   Seria.Add(Sign(Array[0]));
   for(int i=1,j=1;i<N;i++,j++)
     {
      Sum_In2+=MathPow(Array[i]-MO,2.0);
      Sum_In3+=MathPow(Array[i]-MO,3.0);
      Sum_In4+=MathPow(Array[i]-MO,4.0);
      if(Sign(Array[i])!=Seria.At(j-1))
        {
         Seria.Add(Sign(Array[i]));
        }
      else
        {
         j--;
        }
     }
   int R=Seria.Total();                               //  
   int W=0;                                           //      
   int L=0;                                           //      
   for(int i=0; i<N; i++)
     {
      if(Array[i]>0)
        {
         W++;
        }
      if(Array[i]<0)
        {
         L++;
        }
     }
   double P=2.0*W*L;
   double Z=0.0;                                         // Z-
//---  R<=0,     ,     Z    
   if(R>1)
     {
      Z=(N*(R-0.5)-P)/MathSqrt((P*(P-N))/(N-1));
     }
   Sigma=MathSqrt(Sum_In2/((double)N-1.0));
   Skewness=Sum_In3/(N*MathPow(Sigma,3));
   Kurtosis=Sum_In4/(N*MathPow(Sigma,4))-3;
   mA=MathSqrt(6.0/(double)N);
   mE=2.0*MathSqrt(6.0/(double)N);
   Results.Add(Min);
   Results.Add(Max);
   Results.Add(MO);
   Results.Add(Std);
   Results.Add(Sigma);
   Results.Add(Skewness);
   Results.Add(Kurtosis);
   Results.Add(mA);
   Results.Add(mE);
   Results.Add(Z);
   if((MathAbs(Skewness)>=3*mA) && (MathAbs(Kurtosis)>=3*mE))
     {
      Print("  .");
     }
   if((MathAbs(Skewness)<3*mA) && (MathAbs(Kurtosis)<3*mE))
     {
      Print(" .");
     }
   delete Seria;
//---             
   return(Results);
  }
//+------------------------------------------------------------------+
//|  Z-                 |
//+------------------------------------------------------------------+
double getZ()
  {
   CArrayDouble *result;
   double Returns[];
   int counter=0;
   int total=OrdersHistoryTotal();
   double Z=0;
//----
   if((IsTesting() && !IsOptimization()) || !IsTesting())
     {
      if(OrdersHistoryTotal()>0)
        {
         //---
         for(int i=0;i<=total;i++)
            if(OrderSelect(i,SELECT_BY_POS,MODE_HISTORY))
              {
               if(OrderType()==OP_BUY || OrderType()==OP_SELL)
                 {
                  ArrayResize(Returns,counter+1);
                  Returns[counter]=OrderProfit();
                  counter++;
                 }
              }
        }
      else
        {
         //---  
         return (0);
        }
      Print(" counter = ",counter,", total = ",total);
      result=GetStatFromSeria(Returns);
      if(result!=NULL)
        {
         Z=result.At(9);
        }
     }
   delete result;
//----  Z
   return(Z);
  }
//+------------------------------------------------------------------+
