//+------------------------------------------------------------------+
//|                                                  wlxFractals.mq5 |
//|         Copyright  2004, by konKop, GOODMAN, Mstera, af + wellx |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
//----  
#property copyright "Copyright  2004, by konKop, GOODMAN, Mstera, af + wellx"
//----    
#property link      "http://www.metaquotes.net"
//----   
#property version   "1.00"
#property description "  "
//----     
#property indicator_chart_window 
//----        
#property indicator_buffers 2
//----     
#property indicator_plots   2
//+----------------------------------------------+
//|          |
//+----------------------------------------------+
//----   1   
#property indicator_type1   DRAW_ARROW
//----       
#property indicator_color1  clrBlue
//----    1  3
#property indicator_width1  3
//----    
#property indicator_label1  "Up Fractal"
//+----------------------------------------------+
//|           |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_ARROW
//----       
#property indicator_color2  clrMagenta
//----    2  3
#property indicator_width2  3
//----    
#property indicator_label2 "Down Fractal"

//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint Equals=5;
input uint nLeftUp=2;
input uint nRightUp=2;
input uint nLeftDown=2;
input uint nRightDown=2;
input int  UpLable=217;//  
input int  DnLable=218;//  
//+----------------------------------------------+

//----   ,    
//      
double UpBuffer[];
double DnBuffer[];
//---
int min_rates_total;
int cntup,cntdown,cnt,r,l,e,fup,fdown;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
void OnInit()
  {
//----    
   r=0;
   l=0;
   e=0;
   fup=0;
   fdown=0;
   cntup=int(nLeftUp+nRightUp+Equals)+1;
   cntdown=int(nLeftDown+nRightDown+Equals)+1;
   if(cntup>=cntdown) cnt=cntup;
   if(cntup<cntdown) cnt=cntdown;
   min_rates_total=MathMax(cntup,cntdown);

//----      
   SetIndexBuffer(0,UpBuffer,INDICATOR_DATA);
//----       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   
   PlotIndexSetInteger(0,PLOT_ARROW,UpLable);
//----       
   ArraySetAsSeries(UpBuffer,true);
//----      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----      
   SetIndexBuffer(1,DnBuffer,INDICATOR_DATA);
//----       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   
   PlotIndexSetInteger(1,PLOT_ARROW,DnLable);
//----       
   ArraySetAsSeries(DnBuffer,true);
//----      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,EMPTY_VALUE);

//----     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----         
   string short_name="wlxFractals";
   IndicatorSetString(INDICATOR_SHORTNAME,short_name);
//----   
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(0);

//----    
   int limit,bar,i,j;
   double;

//----      
//  limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
      limit=rates_total-min_rates_total-1; //      
   else limit=rates_total-prev_calculated; //      

//----         
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);

   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      UpBuffer[bar]=EMPTY_VALUE;
      DnBuffer[bar]=EMPTY_VALUE;
     }

//----    
   for(bar=limit+(int)nRightUp; bar>=(int)nRightUp && !IsStopped(); bar--)
     {
      // 
      r=(int)nRightUp; //   
      //----
      for(i=1; i<=r; i++) if(high[bar]<=high[bar-i]) break;
      //     i    r+1
      if(i==r+1)
        {
         l=(int)nLeftUp;  //   
         e=(int)Equals;
         //----
         for(j=1; j<=l+(int)Equals; j++)
           {
            if(high[bar]<high[bar+j]) break;
            //----
            if(high[bar]>high[bar+j]) l--;
            //----
            if(high[bar]==high[bar+j]) e--;
            //----
            if(!l)
              {
               UpBuffer[bar]=high[bar];
               break;
              }
            //----
            if(e<0) break;
           }
        }
     }

//----    
   for(bar=limit+(int)nRightDown; bar>=(int)nRightDown && !IsStopped(); bar--)
     {
      // 
      r=(int)nRightDown; //   
      //----
      for(i=1; i<=r; i++) if(low[bar]>=low[bar-i]) break;
      //----
      if(i==r+1)
        {
         l=(int)nLeftDown;  //   
         e=(int)Equals;
         //----
         for(j=1; j<=l+(int)Equals; j++)
           {
            if(low[bar]>low[bar+j]) break;
            //----
            if(low[bar]<low[bar+j]) l--;
            //----
            if(low[bar]==low[bar+j]) e--;
            //----
            if(l==0)
              {
               DnBuffer[bar]=low[bar];
               break;
              }
            if(e<0) break;
           }
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
