//+------------------------------------------------------------------+
//|                                           Test_StdDevOnArray.mq5 |
//|                        Copyright 2011, MetaQuotes Software Corp. |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2011, MetaQuotes Software Corp."
#property link      "http://www.mql5.com"
#property version   "1.00"
#property indicator_separate_window
#property indicator_buffers 3
#property indicator_plots   1
//--- plot Label1
#property indicator_label1  "Label1"
#property indicator_type1   DRAW_LINE
#property indicator_color1  clrRed
#property indicator_style1  STYLE_SOLID
#property indicator_width1  1
//--- input parameters
input int      SDPeriod=20;
//--- indicator buffers
double         SDBuffer[];
double         MABuffer[];
double         data[];

#include <IncOnArray/IncStdDevOnArray.mqh>
CStdDevOnArray sd;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
   sd.Init(SDPeriod);

//--- indicator buffers mapping
   SetIndexBuffer(0,SDBuffer,INDICATOR_DATA);
   SetIndexBuffer(1,MABuffer,INDICATOR_CALCULATIONS);
   SetIndexBuffer(2,data,INDICATOR_CALCULATIONS);

   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,sd.BarsRequired());
   PlotIndexSetString(0,PLOT_LABEL,sd.Name());
//---
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const int begin,
                const double &price[])
  {
   int start;
   if(prev_calculated>0)
     {
      start=prev_calculated-1;
     }
   else
     {
      start=0;
     }
   for(int i=start;i<rates_total;i++)
     {
      data[i]=price[i];
     }

   sd.Solve(rates_total,prev_calculated,data,MABuffer,SDBuffer);

   return(rates_total);
  }
//+------------------------------------------------------------------+
