//+------------------------------------------------------------------+
//|                                             IncStdDevOnArray.mqh |
//|                                                          Integer |
//|                          https://login.mql5.com/en/users/Integer |
//+------------------------------------------------------------------+
#property copyright "Integer"
#property link      "https://login.mql5.com/en/users/Integer"
#property version   "1.00"
/*
   External parameters:
   input int      SDPeriod=20;

   Declaration:
   #include <IncOnArray/IncStdDevOnArray.mqh>
   CStdDevOnArray sd;

   In OnInit:  
   sd.Init(SDPeriod);

   In OnCalculate:
   sd.Solve(rates_total,prev_calculated,data,MABuffer,SDBuffer);
*/

#include <IncOnArray/IncMAOnArray.mqh>
//+------------------------------------------------------------------+
//| CStdDevOnArray                                                   |
//+------------------------------------------------------------------+
class CStdDevOnArray
  {
private:
   int               m_Period;
   ENUM_MA_METHOD    m_Method;
   string            m_Name;
   CMAOnArray        m_ma;
   int               m_br;
public:
   void Init(int aPeriod=20,ENUM_MA_METHOD aMethod=MODE_SMA)
     {
      m_Period=aPeriod;
      m_Method=aMethod;
      m_ma.Init(m_Period,m_Method);
      m_Name="StdDev("+IntegerToString(m_Period)+","+m_ma.NameMethod()+")";
      m_br=m_ma.BarsRequired();
     }
   void Solve(const int aRatesTotal,
              const int aPrevCalc,
              double  &aData[],
              double  &aMA[],
              double  &aStdDev[])
     {
      m_ma.Solve(aRatesTotal,aPrevCalc,aData,aMA);
      int Start=0;
      if(aPrevCalc==0)
        {
         for(int i=0;i<aRatesTotal;i++)
           {
            if(aMA[i]!=0 && aMA[i]!=EMPTY_VALUE)
              {
               Start=i+m_Period;
               break;
              }
           }
        }
      else
        {
         Start=aPrevCalc-1;
        }
      for(int i=Start;i<aRatesTotal;i++)
        {
         aStdDev[i]=0;
         for(int j=i;j>i-m_Period;j--)
           {
            aStdDev[i]+=MathPow(aData[j]-aMA[i],2);
           }
         aStdDev[i]=MathSqrt(aStdDev[i]/m_Period);
        }
     }
   int BarsRequired()
     {
      return(m_br);
     }
   string Name()
     {
      return(m_Name);
     }
   string About()
     {
      return("Integer's StdDevOnArray class. https://login.mql5.com/en/users/Integer");
     }
  };
//+------------------------------------------------------------------+
