//+------------------------------------------------------------------+
//|                                     Test_PriceChannelOnArray.mq5 |
//|                                                          Integer |
//|                          https://login.mql5.com/ru/users/Integer |
//+------------------------------------------------------------------+
#property copyright "Integer"
#property link      "https://login.mql5.com/ru/users/Integer"
#property version   "1.00"
#property indicator_chart_window
#property indicator_buffers 5
#property indicator_plots   3
//--- plot Label1
#property indicator_label1  "Label1"
#property indicator_type1   DRAW_LINE
#property indicator_color1  clrRed
#property indicator_style1  STYLE_SOLID
#property indicator_width1  1
//--- plot Label2
#property indicator_label2  "Label2"
#property indicator_type2   DRAW_LINE
#property indicator_color2  clrRed
#property indicator_style2  STYLE_SOLID
#property indicator_width2  1
//--- plot Label3
#property indicator_label3  "Label3"
#property indicator_type3   DRAW_LINE
#property indicator_color3  clrRed
#property indicator_style3  STYLE_SOLID
#property indicator_width3  1
//--- input parameters
input int  PCHPeriod=34;
//--- indicator buffers
double         UBuffer[];
double         LBuffer[];
double         CBuffer[];
double         DataHigh[];
double         DataLow[];
//---
#include <IncOnArray/IncPriceChannelOnArray.mqh>
CPriceChannelOnArray pch;
//---
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
   pch.Init(PCHPeriod);

//--- indicator buffers mapping
   SetIndexBuffer(0,UBuffer,INDICATOR_DATA);
   SetIndexBuffer(1,LBuffer,INDICATOR_DATA);
   SetIndexBuffer(2,CBuffer,INDICATOR_DATA);

   SetIndexBuffer(3,DataHigh,INDICATOR_CALCULATIONS);
   SetIndexBuffer(4,DataLow,INDICATOR_CALCULATIONS);

   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,pch.BarsRequired());
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,pch.BarsRequired());
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,pch.BarsRequired());

   PlotIndexSetString(0,PLOT_LABEL,pch.Name()+" Upper");
   PlotIndexSetString(1,PLOT_LABEL,pch.Name()+" Lower");
   PlotIndexSetString(2,PLOT_LABEL,pch.Name()+" Central");
//---
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {

   int start;
   if(prev_calculated>0)
     {
      start=prev_calculated-1;
     }
   else
     {
      start=0;
     }
   for(int i=start;i<rates_total;i++)
     {
      DataHigh[i]=high[i];
      DataLow[i]=low[i];
     }

   pch.Solve(rates_total,prev_calculated,DataHigh,DataLow,UBuffer,LBuffer,CBuffer);

   return(rates_total);
  }
//+------------------------------------------------------------------+
