//+------------------------------------------------------------------+
//|                                       IncPriceChannelOnArray.mq5 |
//|                                                          Integer |
//|                          https://login.mql5.com/ru/users/Integer |
//+------------------------------------------------------------------+
#property copyright "Integer"
#property link      "https://login.mql5.com/ru/users/Integer"
#property version   "1.00"
/*
   External parameters:
   input int  PCHPeriod=34;

   Declaration:
   #include <IncOnArray/IncPriceChannelOnArray.mqh>
   CPriceChannelOnArray pch;

   In OnInit:
   pch.Init(PCHPeriod);

   In OnCalculate:
   pch.Solve(rates_total,prev_calculated,DataHigh,DataLow,UBuffer,LBuffer,CBuffer);
*/
//+------------------------------------------------------------------+
//| CPriceChannelOnArray                                             |
//+------------------------------------------------------------------+
class CPriceChannelOnArray
  {
private:
   int               m_Period;
   string            m_Name;
   int               m_br;
public:
   void Init(int aPeriod=34)
     {
      m_Period=aPeriod;
      m_Name="PriceChannel("+IntegerToString(m_Period)+")";
      m_br=m_Period;
     }
   void Solve(const int aRatesTotal,
              const int aPrevCalc,
              double  &aDataHigh[],
              double  &aDataLow[],
              double  &aUpper[],
              double  &aLower[],
              double  &aMiddle[])
     {
      int Start=0;
      if(aPrevCalc==0)
        {
         for(int i=0;i<aRatesTotal;i++)
           {
            if(aDataHigh[i]!=0 && aDataHigh[i]!=EMPTY_VALUE && aDataLow[i]!=0 && aDataLow[i]!=EMPTY_VALUE)
              {
               Start=i+m_Period-1;
               break;
              }
           }
        }
      else
        {
         Start=aPrevCalc-1;
        }
      for(int i=Start;i<aRatesTotal;i++)
        {
         aUpper[i]=aDataHigh[ArrayMaximum(aDataHigh,i-m_Period+1,m_Period)];
         aLower[i]=aDataLow[ArrayMinimum(aDataLow,i-m_Period+1,m_Period)];
         aMiddle[i]=(aUpper[i]+aLower[i])/2;
        }
     }
   int BarsRequired()
     {
      return(m_br);
     }
   string Name()
     {
      return(m_Name);
     }
   string About()
     {
      return("Integer's PriceChannelOnArray class. https://login.mql5.com/ru/users/Integer");
     }
  };
//+------------------------------------------------------------------+
