//+------------------------------------------------------------------+
//|                                            BrainTrend2Signal.mqh |
//|                                                    2011, etrader |
//|                                             http://efftrading.ru |
//+------------------------------------------------------------------+
#property copyright "2011, etrader"
#property link      "http://efftrading.ru"
//+------------------------------------------------------------------+
//| Include files                                                    |
//+------------------------------------------------------------------+
#property tester_indicator "BrainTrend2.ex5"
#include <Expert\ExpertSignal.mqh>

// wizard description start
//+------------------------------------------------------------------+
//| Description of the class                                         |
//| Title=Signals based on BrainTrend2 indicator                     |
//| Type=SignalAdvanced                                              |
//| Name=BrainTrend2                                                 |
//| Class=CBrainTrend2Signal                                         |
//| Page=                                                            |
//| Parameter=ATR_Period,int,7,ATR period                            |
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
// wizard description end
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+
//| CBrainTrend2Signal class                                         |
//| Purpose: Trade Signals class, based on BrainTrend2 indicator     |
//|          http://www.mql5.com/en/code/394                         |
//+------------------------------------------------------------------+
class CBrainTrend2Signal : public CExpertSignal{
  private:
    CiCustom m_indicator; // object of BrainTrend custom indicator
    int m_atr_period;     // ATR period of BrainTrend indicator
  public:
   virtual int       ShortCondition();      // checks conditions to open a short position
   virtual int       LongCondition();       // checks conditions to open a long position
   void CBrainTrendSignal(){ 
     m_used_series=USE_SERIES_OPEN+USE_SERIES_HIGH+USE_SERIES_LOW+USE_SERIES_CLOSE+USE_SERIES_TIME;
     m_atr_period = 7;  
   }
   void ATR_Period( int passedperiod ){ m_atr_period = passedperiod;  }  // sets the value of ATR_Period
   virtual bool      InitIndicators(CIndicators* indicators);            // initialization of indicators
   bool              InitBrainTrend(CIndicators* indicators);            // initialization of BrainTrend2 indicator
};


//+------------------------------------------------------------------+
//| Initialization of indicators                                     |
//| INPUT:  indicators - pointer to indicators collection            |
//| OUTPUT: true if successful, otherwise false                      |
//| REMARK: none                                                     |
//+------------------------------------------------------------------+
bool CBrainTrend2Signal::InitIndicators(CIndicators* indicators){
//--- checking of pointer
   if(indicators==NULL)                           return(false);
//--- initialization of indicators, timeseries and additional filters
   if(!CExpertSignal::InitIndicators(indicators)) return(false);
//--- creation and initialization of BrainTrend2 indicator
   if(!InitBrainTrend(indicators))                return(false);
//--- ok
   return(true);
}


//+------------------------------------------------------------------+
//| Initialization of BrainTrend2 indicator                          |
//| INPUT: indicators - pointer to indicators collection             |
//| OUTPUT: true if successful, otherwise false                      |
//| REMARK: none                                                     |
//+------------------------------------------------------------------+
bool CBrainTrend2Signal::InitBrainTrend(CIndicators* indicators) {
//--- checking of pointer
   if(indicators==NULL) return(false);
//--- adding the object to collection
   if(!indicators.Add(GetPointer(m_indicator))){
      printf(__FUNCTION__+": error in adding of object to collection");
      return(false);
   }
//--- setting input parameters of BrainTrend2 indicator
   MqlParam parameters[2];
   parameters[0].type = TYPE_STRING;
   parameters[0].string_value = "BrainTrend2.ex5";
   parameters[1].type = TYPE_INT;
   parameters[1].integer_value = m_atr_period;
 //--- object initialization
   if(!m_indicator.Create(m_symbol.Name(),m_period,IND_CUSTOM, 2, parameters )){
      printf(__FUNCTION__+": error in object initialization");
      return(false);
   }
//--- ok
   return(true);
}


//+------------------------------------------------------------------+
//| Checks conditions to open a short position                       |
//| INPUT:  none                                                     |
//| OUTPUT: Voting weight from 0 to 100                              |
//| REMARK: none.                                                    |
//+------------------------------------------------------------------+
int CBrainTrend2Signal::ShortCondition(){
//--- Trend Direction is defined by the 4th buffer of BrainTrend2 indicator
//--- 1 - trend upward
//--- 2 - trend downward
   if( m_indicator.GetData( 4, 1 ) == 2 ) return( 100 );
//--- condition is not satisfied
   return(0); 
   
}


//+------------------------------------------------------------------+
//| Checks conditions to open a long position                        |
//| INPUT:  none                                                     |
//| OUTPUT: Voting weight from 0 to 100                              |
//| REMARK: none.                                                    |
//+------------------------------------------------------------------+
int CBrainTrend2Signal::LongCondition(){
//--- Trend Direction is defined by the 4th buffer of BrainTrend2 indicator
//--- 1 - trend upward
//--- 2 - trend downward
  if( m_indicator.GetData( 4, 1 ) == 1 ) return( 100 );
//--- condition is not satisfied
   return(0);  
}

//+------------------------------------------------------------------+