//+------------------------------------------------------------------+
//|                                                    MergeSort.mqh |
//|                                     2019-2020,dimitri pecheritsa |
//|                                                 792112@gmail.com |
//+------------------------------------------------------------------+
#include "ASorter.mqh"
template<typename TKey,typename TItem>
class CMergeSort : public ASorter<TKey,TItem>
  {
public:
                     CMergeSort(void) {}
                    ~CMergeSort(void) {}

   void              Sort(void);
protected:
   void              TopDownMergeSort(TKey& a[],TKey& b[],int n);
   void              TopDownSplitMerge(TKey& b[],int ibegin,int iend,TKey& a[]);
   void              TopDownMerge(TKey& a[],int ibegin,int imiddle,int iend,TKey& b[]);
   void              CopyArray(TKey& a[],int ibegin,int iend,TKey& b[]);
  };


//+------------------------------------------------------------------+
//| sort                                                             |
//+------------------------------------------------------------------+
template<typename TKey,typename TItem>
void CMergeSort::Sort(void)
  {
   TKey b[];
//---sorting the entire array
   TopDownMergeSort(keys,b,ArraySize(keys));
  }


//+------------------------------------------------------------------+
//| top down merge sort                                              |
//| array a has the items to sort; array b is a work array           |
//+------------------------------------------------------------------+
template<typename TKey,typename TItem>
void CMergeSort::TopDownMergeSort(TKey& a[],TKey& b[],int n)
  {
//---one time copy of a to b
   CopyArray(a,0,n,b);
//---sort data from b into a
   TopDownSplitMerge(b,0,n,a);
  }


//+------------------------------------------------------------------+
//| top down split merge                                             |
//| sort the given run of array a using array b as a source          |
//| ibegin is inclusive; iend is exclusive (a[iend] is not in the    |
//| set)                                                             |
//+------------------------------------------------------------------+
template<typename TKey,typename TItem>
void CMergeSort::TopDownSplitMerge(TKey& b[],int ibegin,int iend,TKey& a[])
  {
//---consider sorted if run size is 1
   if(iend-ibegin<=1)
      return;
//---split the run longer than 1 item into halves
   int imiddle=(iend+ibegin)/2;
//---recursively sort both runs from a into b
   TopDownSplitMerge(a,ibegin,imiddle,b);  //sort the left run
   TopDownSplitMerge(a,imiddle,iend,b);  //sort the right run
//---merge the resulting runs from array b into a
   TopDownMerge(b,ibegin,imiddle,iend,a);
  }


//+------------------------------------------------------------------+
//| top down merge                                                   |
//| left source half is  a[ibegin:imiddle-1]                         |
//| right source half is a[imiddle:iend-1]                           |
//| result is            b[ibegin:iend-1]                            |
//+------------------------------------------------------------------+
template<typename TKey,typename TItem>
void CMergeSort::TopDownMerge(TKey& a[],int ibegin,int imiddle,int iend,TKey& b[])
  {
   int i=ibegin,j=imiddle;
//---while there are elements in the left or right runs...
   for(int k=ibegin; k<iend; k++)
     {
      //---if left run head exists and is <= existing right run head
      if(i<imiddle && (j>=iend || a[i]<=a[j]))
        {
         b[k]=a[i];
         i=i+1;
        }
      else
        {
         b[k]=a[j];
         j=j+1;
        }
     }
  }

//+------------------------------------------------------------------+
//| copy array                                                       |
//+------------------------------------------------------------------+
template<typename TKey,typename TItem>
void CMergeSort::CopyArray(TKey& a[],int ibegin,int iend,TKey& b[])
  {
   ArrayResize(b,ArraySize(a));
   for(int k=ibegin; k<iend; k++)
      b[k]=a[k];
  }


//+------------------------------------------------------------------+
