//+------------------------------------------------------------------+
//|                                                    QuickSort.mqh |
//|                                    2019-2020, dimitri pecheritsa |
//|                                                 792112@gmail.com |
//+------------------------------------------------------------------+
template<typename TKey,typename TItem>
class CQuickSort
  {
protected:
   TKey              m_keys[];
   TItem             m_items[];
public:
                     CQuickSort(void) {}
                    ~CQuickSort(void) {}
   //---sorting
public:
   void              Sort(TKey& keys[],TItem& items[],bool accending_order=true);
protected:
   void              InternalSort(int left,int right);
   int               Partition(int left,int right,TKey pivot);
   virtual void      Swap(int a,int b);
  };


//+------------------------------------------------------------------+
//| sort                                                             |
//+------------------------------------------------------------------+
template<typename TKey,typename TItem>
void CQuickSort::Sort(TKey& keys[],TItem& items[],bool accending_order=true)
  {
//---prepare sorter
   ArrayFree(m_keys);
   ArrayFree(m_items);
   ArrayCopy(m_keys,keys);
   ArrayCopy(m_items,items);
//---sort
   InternalSort(0,ArraySize(keys)-1);
//---save sorted keys and items
   ArrayCopy(keys,m_keys);
   ArrayCopy(items,m_items);
//---keep order
   if(!accending_order)
     {
      ArrayReverse(keys);
      ArrayReverse(items);
     }
  }


//+------------------------------------------------------------------+
//| sort internal                                                    |
//+------------------------------------------------------------------+
template<typename TKey,typename TItem>
void CQuickSort::InternalSort(int left,int right)
  {
   if(right-left<=0)
      return;
   else
     {
      TKey pivot=m_keys[right];
      int partition=Partition(left,right,pivot);
      InternalSort(left,partition-1);
      InternalSort(partition+1,right);
     }
  }


//+------------------------------------------------------------------+
//| sort partition                                                   |
//+------------------------------------------------------------------+
template<typename TKey,typename TItem>
int CQuickSort::Partition(int left,int right,TKey pivot)
  {
   int left_pointer=left-1;
   int right_pointer=right;
   while(true)
     {
      while(m_keys[++left_pointer]<pivot) {}
      while(right_pointer>0 && m_keys[--right_pointer]>pivot) {}
      if(left_pointer>=right_pointer)
         break;
      else
         Swap(left_pointer,right_pointer);
     }
   Swap(left_pointer,right);
   return left_pointer;
  }


//+------------------------------------------------------------------+
//| sort swap                                                        |
//+------------------------------------------------------------------+
template<typename TKey,typename TItem>
void CQuickSort::Swap(int a,int b)
  {
   TKey key=m_keys[a];
   m_keys[a]=m_keys[b];
   m_keys[b]=key;
   if(ArraySize(m_items)!=NULL)
     {
      TItem item=m_items[a];
      m_items[a]=m_items[b];
      m_items[b]=item;
     }
  }


//+------------------------------------------------------------------+
