//+------------------------------------------------------------------+
//|                                                      Context.mqh |
//|                                    2019-2020, dimitri pecheritsa |
//|                                                 792112@gmail.com |
//+------------------------------------------------------------------+
#include "State.mqh"
class Context
  {
public:
                     Context(State& state);
                    ~Context(void);

   State*            State(void) {return m_state;}
   void              State(State& state);

   void              Request(void);

protected:
   State*            m_state;
  };


//+------------------------------------------------------------------+
//|                                                      constructor |
//+------------------------------------------------------------------+
Context::Context(State& state):
   m_state(&state)
  {
  }


//+------------------------------------------------------------------+
//|                                                       destructor |
//+------------------------------------------------------------------+
Context::~Context(void)
  {
   if(CheckPointer(m_state)==1)
      delete m_state;
  }


//+------------------------------------------------------------------+
//|                                                        set state |
//+------------------------------------------------------------------+
void Context::State(State& state)
  {
   Print("context state changed to: ",&state);
   delete m_state;
   m_state=&state;
  }


//+------------------------------------------------------------------+
//|                                                          request |
//+------------------------------------------------------------------+
void Context::Request(void)
  {
   Print("context is requesting its state ",m_state,
         " which will handle this context");
   m_state.Handle(this);
  }


//+------------------------------------------------------------------+
