//+------------------------------------------------------------------+
//|                                                        State.mq5 |
//|                                    2019-2020, dimitri pecheritsa |
//|                                                 792112@gmail.com |
//+------------------------------------------------------------------+
//
//   state - behavioral design pattern
//   
//   from: design patterns: elements of reusable object-oriented software
//   by gof: erich gamma, richard helm, ralph johnson, john vlissides
//   published in 1994
//
//   intent
//
//   allow an object to alter its behavior when its internal state changes.
//the object will appear to change its class
//
//   applicability
//
//   an object's behavior depends on its state, and it must change its
//behavior at run-time depending on that state
//   operations have large, multipart conditional statements that depend
//on the object's state. this state is usually represented by one or more
//enumerated constants. often, several operations will contain this same
//conditional structure. the state pattern puts each branch of the conditional
//in a separate class. this lets you treat the object's state as an object
//in its own right that can vary independently from other objects
//
//   structure
//   
//                       state
//     |Context        |o------------------>|State   |
//     |---------------|                    |--------|
//     |Request()      |                    |Handle()|
//     | state.Handle()|                         |
//                          +--------------------+--- - - - -
//                          |                    |
//                  |ConcreteStateA|     |ConcreteStateB|
//                  |--------------|     |--------------|
//                  |Handle()      |     |Handle()      |
//
//   participants
//
//   context
//      defines the interface of interest to clients
//      maintains an instance of a concrete state subclass that defines
//the current state
//   state
//      defines an interface for encapsulating the behavior associated
//with a particular state of the context
//   concrete state subclasses
//      each subclass implements a behavior associated with a state of
//the context
//
//   collaborations
//   
//   context delegates state-specific requests to the current concrete
//state object
//   a context may pass itself as an argument to the state object handling
//the request. this lets the state object access the context if necessary
//   context is the primary interface for clients. clients can configure
//a context with state objects. once a context is configured, its clients
//don't have to deal with the state objects directly
//   either context or the concrete state subclasses can decide which
//state succeeds another and under what circumstances

//+------------------------------------------------------------------+
//| client                                                           |
//+------------------------------------------------------------------+
#include <Mqh\Patterns\State\State.mqh>
#include <Mqh\Patterns\State\Context.mqh>
#include <Mqh\Patterns\State\ConcreteStateA.mqh>
#include <Mqh\Patterns\State\ConcreteStateB.mqh>
void OnStart(void)
  {
   Context context(new ConcreteStateA);
   context.Request();
   context.Request();
  }

//   output
//   
//   context is requesting its state 2097152 which will handle this context
//   concrete state a (2097152) is handling context and changing the context state
//   context state changed to: 3145728
//   context is requesting its state 3145728 which will handle this context
//   concrete state b (3145728) is handling context and changing the context state
//   context state changed to: 4194304
//
//   consequences
//   
//   it localizes state-specific behavior and partitions behavior for
//different states
//   it makes state transitions explicit
//   state objects can be shared
//
//   implementation
//
//   who defines the state transitions?
//   a table-based alternative
//   creating and destroying state objects
//   using dynamic inheritance
//
//   related patterns
//
//   flyweight pattern explains when and how state objects can be shared
//   state objects are often singletons
//
//+------------------------------------------------------------------+
