//+------------------------------------------------------------------+
//|                                                201028_095428.mq5 |
//|                                    2019-2020, dimitri pecheritsa |
//|                                                 792112@gmail.com |
//+------------------------------------------------------------------+
//   from: design patterns: elements of reusable object-oriented software
//   by gof: erich gamma, richard helm, ralph johnson, john vlissides
//   published in 1994
//+------------------------------------------------------------------+
//| mediator - behavioral design pattern                             |
//+------------------------------------------------------------------+
//   define an object that encapsulates how a set of objects interact
//   mediator promotes loose coupling by keeping objects from referring
// to each other explicitly, and it lets you vary their interaction
// independently
//+------------------------------------------------------------------+
//| applicability                                                    |
//+------------------------------------------------------------------+
//   a set of objects communicate in well-defined but complex ways.
// the resulting interdependencies are unstructured and difficult to
// understand
//   reusing an object is difficult because it refers to and communicates
// with many other objects
//   a behavior that's distributed between several classes should be
// customizable without a lot of subclassing
//+------------------------------------------------------------------+
//| structure                                                        |
//+------------------------------------------------------------------+
//
//                             mediator
//    |Mediator|<-----------------------|Colleague|
//        ^                                  ^
//        |                                  |
//        |                    +-------------+------------+
//        |                    |                          |
//|ConcreteMediator|-->|ConcreteColleague1|  +-->|ConcreteColleague2|
//               |                           |
//               +---------------------------+
//
//+------------------------------------------------------------------+
//| typical object structure                                         |
//+------------------------------------------------------------------+
//
//                                 |aColleague|
//                                 |----------|
//                                 |* mediator|
//                                  |
//                                  |                |aColleague|
//                                  |                |----------|
//      |aColleague|                v            +---|* mediator|
//      |----------|                             |         ^
//      |mediator *|----->|aConcreteMediator|<---+         |
//                        |-----------------|              |
//                        | *           * *-|--------------+
//                          |  ^     ^  |
//                          |  |     |  |
//                          |  |     |  |
//   |aColleague|<----------+  |     |  |
//   |----------|              |     |  +--->|aColleague|
//   |mediator *|--------------+     |       |----------|
//                                   +-------|* mediator|
//
//+------------------------------------------------------------------+
//| participants                                                     |
//+------------------------------------------------------------------+
//   mediator
//      defines an interface for communicating with colleague objects
//   concrete mediator
//      implements cooperative behavior by coordinating colleague objects
//      knows and maintains its colleagues
//   colleague classes
//      each colleague class knows its mediator object
//      each colleague communicates with its mediator whenever it would have
// otherwise communicated with another colleague
//+------------------------------------------------------------------+
//| collaborations                                                   |
//+------------------------------------------------------------------+
#include <Mqh\201028_103044.mqh> //colleague
#include <Mqh\201028_102459.mqh> //mediator
#include <Mqh\201028_102504.mqh> //concrete colleague 1
#include <Mqh\201028_103427.mqh> //concrete colleague 2
#include <Mqh\201028_102503.mqh> //concrete mediator
//   colleagues send and receive requests from a mediator object
//   the mediator implements the cooperative behavior by routing requests
// between the appropriate colleague(s)
//---
void OnStart()
  {
   ConcreteMediator mediator;
   Colleague* colleague_1=new ConcreteColleague1(mediator);
   Colleague* colleague_2=new ConcreteColleague2(mediator);
   mediator.colleague_1=colleague_1;
   mediator.colleague_2=colleague_2;
   colleague_1.Send("message 1");
   colleague_2.Send("message 2");
//---
   delete colleague_1;
   delete colleague_2;
  }
//+------------------------------------------------------------------+
//| output                                                           |
//+------------------------------------------------------------------+
//   colleague 1 sending message 1
//   colleague 2 notified about message 1
//   colleague 2 sending message 2
//   colleague 1 notified about message 2
//+------------------------------------------------------------------+
//| consequences                                                     |
//+------------------------------------------------------------------+
//   it limits subclassing
//   it simplifies object protocols
//   it abstracts how objects cooperate
//   it centralizes control
//+------------------------------------------------------------------+
//| implementation                                                   |
//+------------------------------------------------------------------+
//   omitting the abstract mediator class
//   colleague-mediator communication
//+------------------------------------------------------------------+
//| related patterns                                                 |
//+------------------------------------------------------------------+
//   facade
//   observer
//+------------------------------------------------------------------+
