/****************************************************************
FloatingPoint comparer
A tiny class to compare floating point variables the right way
 with desired precision.
Let's say you have two doubles with a value of 1.15.
When you compare them, you expect them to be equal.
But doubles in computer behave the strange way.
1.15 may be stored as 1.14999999999.
So comparing will fail your expectations.
The proper way to compare floating point variables,
 is by checking their subtraction with some minimum value.
FlatingPoint must be initialized with double or float datatype.
Comparer method returns 0 if x = y; 1 if x > y; and -1 if x < y.
Precision can be changed.
Deafult precision is 8 digits after fp for doubles, and 4 for floats.
/****************************************************************/
template<typename T>class FloatingPoint
  {
public:
                     FloatingPoint() {Precision(sizeof(T));}
   int               Compare(const T x, const T y) {return (((fabs(x-y)<min))?0:((x-y>=min))?1:-1);}
   void              Precision(int digits) {min=pow(10,-fabs(digits));}
protected:
   double            min;
  };
/**/
