//+------------------------------------------------------------------+
//|                                                       Sample.mq5 |
//|                                     Copyright 2018-2019, D. Dorn |
//|                                             mailto:d.dorn@web.de |
//+------------------------------------------------------------------+
#property copyright "Copyright 2018-2019, D. Dorn"
#property link      "mailto:d.dorn@web.de"
#property version   "1.00"

input string InpFileName="sample.csv"; // File with orders

#include <CsvReader.mqh>

CCsvReader fOrder;

bool fileopened=false;

MqlParam fOrder_column_desc[]=
  {
     { TYPE_STRING,   0, 0.0, "symbol" },       // 1. field 
     { TYPE_STRING,   0, 0.0, "ordertype" },    // 2. field 
     { TYPE_DOUBLE,   0, 0.0, "lot" },          // 3. field 
     { TYPE_DOUBLE,   0, 0.0, "entry" }         // 4. field 
  };

// Here the values of one line will be returned  
MqlParam fOrder_Line[];
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
struct struct_lookup
  {
   string            text;
   long              value;
  };
struct_lookup lookupordertype[]=
  {
     {"BuyMarket",     (long) ORDER_TYPE_BUY},
     {"BuyLimit",      (long) ORDER_TYPE_BUY_LIMIT},
     {"BuyStop",       (long) ORDER_TYPE_BUY_STOP},
     {"SellMarket",    (long) ORDER_TYPE_SELL},
     {"SellLimit",     (long) ORDER_TYPE_SELL_LIMIT},
     {"SellStop",      (long) ORDER_TYPE_SELL_STOP},
  };
//+------------------------------------------------------------------+
//| Script program start function                                    |
//+------------------------------------------------------------------+
void OnStart()
  {
//---
   int resultread=0;

   fOrder.HasHeader(true);
   fOrder.FieldDesc(fOrder_column_desc);
   fOrder.Open(InpFileName, FILE_READ);
//---
// If the file has a header skip the header
   if(fOrder.HasHeader())
     {
      resultread=fOrder.ReadLine();
     }

   do     
     {
      resultread=fOrder.ReadLine(fOrder_Line);
      if(resultread>=0)
        {
         if(resultread<4)
           {
            printf("Not 4 fields in order line.");
           }
         else
           {
            string symbol             = fOrder_Line[0].string_value;
            ENUM_ORDER_TYPE ordertype = (ENUM_ORDER_TYPE) lookup(
                                         fOrder_Line[1].string_value,
                                         lookupordertype);
            double lot                = fOrder_Line[2].double_value;
            double entry              = fOrder_Line[3].double_value;

            PrintFormat("%s %s lot %f price %f",
                        symbol,
                        EnumToString(ordertype),
                        lot,
                        entry);
           }
        }
     }
   while(resultread>0 && !IsStopped());
//---   
   fOrder.Close();
//---   
  }
//+------------------------------------------------------------------+
//| Lookup a code by text constant                                   |
//+------------------------------------------------------------------+
long lookup(const string text,const struct_lookup &arr[])
  {
   for(int i=0; i<ArraySize(arr);++i)
     {
      if(arr[i].text==text)
        {
         return arr[i].value;
        }
     }
   return LONG_MIN;  // no match was found
  }
//+------------------------------------------------------------------+
