//+------------------------------------------------------------------+ 
//|                                               CandleStop_HTF.mq5 | 
//|                               Copyright  2013, Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2013, Nikolay Kositsin"
#property link "arria@mail.redcom.ru"
//--- indicator version number
#property version   "1.00"
#property description "CandleStop with the timeframe selection option available in input parameters"
//--- drawing the indicator in the main window
#property indicator_chart_window 
//--- number of indicator buffers 5
#property indicator_buffers 5
//--- four plots are used
#property indicator_plots   4
//+----------------------------------------------+
//| declaring constants                          |
//+----------------------------------------------+
#define RESET 0                     // A constant for returning the indicator recalculation command to the terminal
#define INDICATOR_NAME "CandleStop" // A constant for the indicator name
#define SIZE 1                      // A constant for the number of calls of the CountIndicator function in the code
//+----------------------------------------------+
//| Indicator 1 drawing parameters               |
//+----------------------------------------------+
//--- drawing the indicator as a colored cloud
#property indicator_type1   DRAW_FILLING
//--- Lavender color is used for the indicator
#property indicator_color1  clrLavender
//--- displaying the indicator label
#property indicator_label1 "Channel"
//+----------------------------------------------+
//| Indicator 2 drawing parameters               |
//+----------------------------------------------+
//--- drawing the indicator 2 as a line
#property indicator_type2   DRAW_LINE
//--- LimeGreen color is used for the indicator
#property indicator_color2  clrLimeGreen
//--- Indicator line is a dash-dot one
#property indicator_style2 STYLE_DASHDOTDOT
//--- indicator 2 width is equal to 1
#property indicator_width2  1
//--- indicator bullish label display
#property indicator_label2  "Support"
//+----------------------------------------------+
//| Indicator 3 drawing parameters               |
//+----------------------------------------------+
//--- Drawing indicator 3 as line
#property indicator_type3   DRAW_LINE
//--- SlateBlue color is used for the indicator
#property indicator_color3  clrSlateBlue
//--- Indicator line is a dash-dot one
#property indicator_style3 STYLE_DASHDOTDOT
//--- indicator 3 width is equal to 1
#property indicator_width3  1
//--- bearish indicator label display
#property indicator_label3 "Middle"
//+----------------------------------------------+
//| Indicator 4 drawing parameters               |
//+----------------------------------------------+
//--- drawing the indicator 4 as a line
#property indicator_type4   DRAW_LINE
//--- DeepPink color is used as the indicator color
#property indicator_color4  clrDeepPink
//--- Indicator line is a dash-dot one
#property indicator_style4 STYLE_DASHDOTDOT
//--- indicator 4 width is equal to 1
#property indicator_width4  1
//--- bearish indicator label display
#property indicator_label4 "Resistance"
//+----------------------------------------------+
//| Indicator input parameters                   |
//+----------------------------------------------+ 
input ENUM_TIMEFRAMES TimeFrame=PERIOD_H4;  // Indicator chart period (timeframe)
input uint UpTrailPeriods=5;                // High finding period
input uint DnTrailPeriods=5;                // Low finding period
input int  Shift=0;                         // Horizontal shift of the indicator in bars
//+----------------------------------------------+
//--- declaration of dynamic arrays that will be used as indicator buffers
double UpIndBuffer[];
double MdIndBuffer[];
double DnIndBuffer[];
double UpChIndBuffer[];
double DnChIndBuffer[];
//--- declaration of integer variables of data starting point
int min_rates_total;
//--- declaration of integer variables for indicators handles
int Ind_Handle;
//+------------------------------------------------------------------+
//| Getting a timeframe as string                                    |
//+------------------------------------------------------------------+
string GetStringTimeframe(ENUM_TIMEFRAMES timeframe)
  {return(StringSubstr(EnumToString(timeframe),7,-1));}
//+------------------------------------------------------------------+    
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//--- checking correctness of the chart periods
   if(!TimeFramesCheck(INDICATOR_NAME,TimeFrame)) return(INIT_FAILED);
//--- initialization of variables 
   min_rates_total=2;
//--- getting the handle of the CandleStop indicator
   Ind_Handle=iCustom(Symbol(),TimeFrame,"CandleStop",UpTrailPeriods,DnTrailPeriods,0);
   if(Ind_Handle==INVALID_HANDLE)
     {
      Print(" Failed to get the handle of the CandleStop indicator");
      return(INIT_FAILED);
     }
//--- initialize indicator buffers
   IndInit(0,UpChIndBuffer,INDICATOR_DATA);
   IndInit(1,DnChIndBuffer,INDICATOR_DATA);
   IndInit(2,UpIndBuffer,INDICATOR_DATA);
   IndInit(3,MdIndBuffer,INDICATOR_DATA);
   IndInit(4,DnIndBuffer,INDICATOR_DATA);
//--- initialization of indicators
   PlotInit(0,0.0,0,Shift);
   PlotInit(1,0.0,0,Shift);
   PlotInit(2,0.0,0,Shift);
   PlotInit(3,0.0,0,Shift);
//--- creating a name for displaying in a separate sub-window and in tooltip
   string shortname;
   StringConcatenate(shortname,INDICATOR_NAME,"(",GetStringTimeframe(TimeFrame),")");
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//--- set accuracy of displaying for the indicator values
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//--- initialization end
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    // number of bars in history at the current tick
                const int prev_calculated,// amount of history in bars at the previous tick
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//--- checking the number of bars to be enough for calculation
   if(rates_total<min_rates_total) return(RESET);
//--- indexing elements in arrays as in timeseries  
   ArraySetAsSeries(time,true);
//---
   if(!CountIndicator(0,NULL,TimeFrame,Ind_Handle,1,UpChIndBuffer,2,DnChIndBuffer,1,UpIndBuffer,
      0,MdIndBuffer,2,DnIndBuffer,time,rates_total,prev_calculated,min_rates_total))
      return(RESET);
//---     
   return(rates_total);
  }
//---
//+------------------------------------------------------------------+
//| Indicator buffer initialization                                  |
//+------------------------------------------------------------------+    
void IndInit(int Number,double &Buffer[],ENUM_INDEXBUFFER_TYPE Type)
  {
//--- set dynamic array as an indicator buffer
   SetIndexBuffer(Number,Buffer,Type);
//--- indexing elements in the buffer as in timeseries
   ArraySetAsSeries(Buffer,true);
//---
  }
//+------------------------------------------------------------------+
//| indicator initialization                                         |
//+------------------------------------------------------------------+    
void PlotInit(int Number,double Empty_Value,int Draw_Begin,int nShift)
  {
//--- performing the shift of beginning of indicator drawing
   PlotIndexSetInteger(Number,PLOT_DRAW_BEGIN,Draw_Begin);
//--- setting the indicator values that won't be visible on a chart
   PlotIndexSetDouble(Number,PLOT_EMPTY_VALUE,Empty_Value);
//--- shifting the indicator horizontally by Shift
   PlotIndexSetInteger(Number,PLOT_SHIFT,nShift);
//---
  }
//+------------------------------------------------------------------+
//| CountLine                                                        |
//+------------------------------------------------------------------+
bool CountIndicator(uint     Numb,            // The number of the CountLine function in the list in the indicator code (starting number - 0)
                    string   Symb,            // Chart symbol
                    ENUM_TIMEFRAMES TFrame,   // Chart period
                    int      IndHandle,       // The handle of the processed indicator
                    uint     UpChBuffNumb,    // The index of the upper buffer of the processed indicator for the cloud 
                    double&  UpChIndBuf[],    // Receiving upper buffer of the indicator for the cloud
                    uint     DnChBuffNumb,    // The index of the lower buffer of the processed indicator for the cloud
                    double&  DnChIndBuf[],    // Receiving lower buffer of the indicator for the cloud
                    uint     UpBuffNumb,      // The index of the buffer of the processed indicator
                    double&  UpIndBuf[],      // Receiving upper buffer of the indicator
                    uint     MdBuffNumb,      // The index of the buffer of the processed indicator
                    double&  MdIndBuf[],      // Receiving middle buffer of the indicator
                    uint     DnBuffNumb,      // The index of the buffer of the processed indicator
                    double&  DnIndBuf[],      // Receiving lower buffer of the indicator
                    const datetime& iTime[],  // Timeseries of time
                    const int Rates_Total,    // amount of history in bars on the current tick
                    const int Prev_Calculated,// amount of history in bars at the previous tick
                    const int Min_Rates_Total)// minimum amount of history in bars for calculation
  {
//---
   static int LastCountBar[SIZE];
   datetime IndTime[1];
   int limit;
//--- calculations of the necessary amount of data to be copied
//--- and the 'limit' starting index for the bars recalculation loop
   if(Prev_Calculated>Rates_Total || Prev_Calculated<=0)// checking for the first start of the indicator calculation
     {
      limit=Rates_Total-Min_Rates_Total-1; // starting index for the calculation of all bars
      LastCountBar[Numb]=limit;
     }
   else limit=LastCountBar[Numb]+Rates_Total-Prev_Calculated; // starting index for calculation of new bars 
//--- main cycle of calculation of the indicator
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //--- zero out the contents of the indicator buffers for the calculation
      UpChIndBuf[bar]=0.0;
      DnChIndBuf[bar]=0.0;
      UpIndBuf[bar]=0.0;
      MdIndBuf[bar]=0.0;
      DnIndBuf[bar]=0.0;
      //--- copy new data to the IndTime array
      if(CopyTime(Symbol(),TFrame,iTime[bar],1,IndTime)<=0) return(RESET);

      if(iTime[bar]>=IndTime[0] && iTime[bar+1]<IndTime[0])
        {
         LastCountBar[Numb]=bar;
         double UpChArr[1],DnChArr[1],UpArr[1],MdArr[1],DnArr[1];
         //--- copy newly appeared data into the arrays
         if(CopyBuffer(IndHandle,UpChBuffNumb,iTime[bar],1,UpChArr)<=0) return(RESET);
         if(CopyBuffer(IndHandle,DnChBuffNumb,iTime[bar],1,DnChArr)<=0) return(RESET);
         if(CopyBuffer(IndHandle,UpBuffNumb,iTime[bar],1,UpArr)<=0) return(RESET);
         if(CopyBuffer(IndHandle,MdBuffNumb,iTime[bar],1,MdArr)<=0) return(RESET);
         if(CopyBuffer(IndHandle,DnBuffNumb,iTime[bar],1,DnArr)<=0) return(RESET);

         UpChIndBuf[bar]=UpChArr[0];
         DnChIndBuf[bar]=DnChArr[0];
         UpIndBuf[bar]=UpArr[0];
         MdIndBuf[bar]=MdArr[0];
         DnIndBuf[bar]=DnArr[0];
        }
      else
        {
         UpChIndBuf[bar]=UpChIndBuf[bar+1];
         DnChIndBuf[bar]=DnChIndBuf[bar+1];
         UpIndBuf[bar]=UpIndBuf[bar+1];
         MdIndBuf[bar]=MdIndBuf[bar+1];
         DnIndBuf[bar]=DnIndBuf[bar+1];
        }
     }
//---     
   return(true);
  }
//+------------------------------------------------------------------+
//| TimeFramesCheck()                                                |
//+------------------------------------------------------------------+    
bool TimeFramesCheck(string IndName,
                     ENUM_TIMEFRAMES TFrame) //Indicator chart period (timeframe)
  {
//--- checking correctness of the chart periods
   if(TFrame<Period() && TFrame!=PERIOD_CURRENT)
     {
      Print("Chart period for the "+IndName+" indicator cannot be less than the period of the current chart!");
      Print ("You must change the indicator input parameters!");
      return(RESET);
     }
//---
   return(true);
  }
//+------------------------------------------------------------------+
