//+------------------------------------------------------------------+
//|                                                     SuperSR6.mq5 |
//|                                       Copyright  2006, Scorpion |
//|            Scorpion@fxfisherman.com, http://www.fxfisherman.com/ |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, Scorpion"
#property link      "http://www.fxfisherman.com/"
#property description "       "
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----        
#property indicator_buffers 2
//----     
#property indicator_plots   2
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//----   1   
#property indicator_type1   DRAW_ARROW
//----        
#property indicator_color1  clrMagenta
//----    1  1
#property indicator_width1  1
//----   
#property indicator_label1  "Support"
//+----------------------------------------------+
//|            |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_ARROW
//----        
#property indicator_color2  clrLime
//----    2  1
#property indicator_width2  1
//----    
#property indicator_label2 "Resistance"

//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint Contract_Step=150;
input uint Precision=10;
input uint Shift_Bars=1;
//+----------------------------------------------+

//----   ,    
//      
double SellBuffer[];
double BuyBuffer[];
//---
int min_rates_total;
double contract,dPrecision;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
void OnInit()
  {
//----    
   min_rates_total=int(6+Shift_Bars);
   contract=(Contract_Step+Precision)*_Point;
   dPrecision=Precision*_Point;

//----      
   SetIndexBuffer(0,SellBuffer,INDICATOR_DATA);
//----       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//---      DataWindow
   PlotIndexSetString(0,PLOT_LABEL,"Support");
//----   
   PlotIndexSetInteger(0,PLOT_ARROW,159);
//----       
   ArraySetAsSeries(SellBuffer,true);

//----      
   SetIndexBuffer(1,BuyBuffer,INDICATOR_DATA);
//----       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//---      DataWindow
   PlotIndexSetString(1,PLOT_LABEL,"Resistance");
//----   
   PlotIndexSetInteger(1,PLOT_ARROW,159);
//----       
   ArraySetAsSeries(BuyBuffer,true);

//----     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----         
   string short_name="SuperSR6";
   IndicatorSetString(INDICATOR_SHORTNAME,short_name);
//----   
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<min_rates_total) return(0);

//----    
   int shift,limit,bar;
   bool fractal;
   double price,gap;
   
//----         
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);

//----    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
      BuyBuffer[bar]=high[limit+1];
      SellBuffer[bar]=low[limit+1];
     }
   else
     {
      limit=rates_total-prev_calculated+2; //      
     }

//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      shift=int(bar+Shift_Bars);

      //---- Resistance
      price=high[shift+2];
      fractal=price>=high[shift+4] && price>=high[shift+3] && price>high[shift+1] && price>high[shift];
      gap=BuyBuffer[bar+1]-price;

      if(fractal && (gap>=contract || gap<0)) BuyBuffer[bar]=price+dPrecision;
      else BuyBuffer[bar]=BuyBuffer[bar+1];

      //---- Support
      price=low[shift+2];
      fractal=price<=low[shift+4] && price<=low[shift+3] && price<low[shift+1] && price<low[shift];
      gap=price-SellBuffer[bar+1];

      if(fractal && (gap>=contract || gap<0)) SellBuffer[bar]=price-dPrecision;
      else SellBuffer[bar]=SellBuffer[bar+1];
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
