//+------------------------------------------------------------------+
//|                                                BS_Living_Now.mq5 |
//|                                      Copyright  2013, Backspace | 
//|                                                  Success Version | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2013, Backspace" 
#property link      "Success Version" 
//----   
#property version   "1.00"
//----     
#property indicator_chart_window
//----    4
#property indicator_buffers 4 
//----     
#property indicator_plots   4
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----     
#property indicator_type1 DRAW_ARROW
//----     
#property indicator_color1 clrLime
//----     2
#property indicator_width1 2
//----    
#property indicator_label1  "BS_Living_Now ExtrimHi"
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----     
#property indicator_type2 DRAW_ARROW
//----     
#property indicator_color2 clrRed
//----     2
#property indicator_width2 2
//----    
#property indicator_label2  "BS_Living_Now ExtrimLo"
//+----------------------------------------------+
//|           |
//+----------------------------------------------+
//----   3   
#property indicator_type3   DRAW_ARROW
//----         Blue
#property indicator_color3  clrBlue
//----    3  1
#property indicator_width3  1
//----    
#property indicator_label3  "Buy BS_Living_Now BreakHi"
//+----------------------------------------------+
//|        |
//+----------------------------------------------+
//----   4   
#property indicator_type4   DRAW_ARROW
//----         Magenta
#property indicator_color4  clrMagenta
//----    2  1
#property indicator_width4  1
//----    
#property indicator_label4  "Sell BS_Living_Now BreakLo"
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint iPeriod=10;  //  
input int Shift=0;      //       
//+----------------------------------------------+
//----   ,    
//----      
double ExtrimHi[],ExtrimLo[];
double BreakHi[],BreakLo[];
//----      
int min_rates_total;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
void OnInit()
  {
//----     
   min_rates_total=int(iPeriod);

//----      
   string shortname;
   StringConcatenate(shortname,"BS_Living_Now(",string(iPeriod),", ",string(Shift),")");
//----           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//----     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);

//----      
   SetIndexBuffer(0,ExtrimHi,INDICATOR_DATA);
//----       Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);
//----    ,      
   ArraySetAsSeries(ExtrimHi,true);
//----   
   PlotIndexSetInteger(0,PLOT_ARROW,217);

//----      
   SetIndexBuffer(1,ExtrimLo,INDICATOR_DATA);
//----       Shift
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);
//----    ,      
   ArraySetAsSeries(ExtrimLo,true);
//----   
   PlotIndexSetInteger(1,PLOT_ARROW,218);

//----      
   SetIndexBuffer(2,BreakHi,INDICATOR_DATA);
//----    1    Shift
   PlotIndexSetInteger(2,PLOT_SHIFT,Shift);
//----       1
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//----    ,      
   ArraySetAsSeries(BreakHi,true);
//----   ,      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,0.0);
//----   
   PlotIndexSetInteger(2,PLOT_ARROW,177);

//----      
   SetIndexBuffer(3,BreakLo,INDICATOR_DATA);
//----    2    Shift
   PlotIndexSetInteger(3,PLOT_SHIFT,Shift);
//----       2
   PlotIndexSetInteger(3,PLOT_DRAW_BEGIN,min_rates_total);
//----    ,      
   ArraySetAsSeries(BreakLo,true);
//----   ,      
   PlotIndexSetDouble(3,PLOT_EMPTY_VALUE,0.0);
//----   
   PlotIndexSetInteger(3,PLOT_ARROW,177);
//----
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //       
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(0);

//----    
   double HH,LL;
   int limit,bar;

//----    ,     
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(close,true);

//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      limit=rates_total-min_rates_total-1;               //      
     }
   else
     {
      limit=rates_total-prev_calculated;                 //      
     }

//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      ExtrimHi[bar]=0.0;
      ExtrimLo[bar]=0.0;
      BreakHi[bar]=0.0;
      BreakLo[bar]=0.0;
      if(!bar) break;

      HH=high[ArrayMaximum(high,bar+1,iPeriod)];
      LL=low[ArrayMinimum(low,bar+1,iPeriod)];

      if(high[bar]>HH && high[bar]>high[bar-1])
        {
         double AvgRange=0.0;
         for(int iii=0; iii<int(iPeriod); iii++) AvgRange+=MathAbs(high[bar+iii]-low[bar+iii]);
         AvgRange/=iPeriod;
         ExtrimHi[bar]=high[bar]+0.3*AvgRange;
        
        for(int iii=int(iPeriod); iii>0; iii--)
          {
          if(high[bar+iii]<high[ArrayMaximum(high,bar+iii+1,iPeriod)])
          BreakHi[bar]=low[ArrayMinimum(low,bar+iii+1,iPeriod)];
          }

        }

      if(low[bar]<LL && low[bar]<low[bar-1])
        {
         double AvgRange=0.0;
         for(int iii=0; iii<int(iPeriod); iii++) AvgRange+=MathAbs(high[bar+iii]-low[bar+iii]);
         AvgRange/=iPeriod;
         ExtrimLo[bar]=low[bar]-0.3*AvgRange;

      for(int iii=int(iPeriod); iii>0; iii--)
          {
          if(low[bar+iii]>low[ArrayMinimum(low,bar+iii+1,iPeriod)])
          BreakLo[bar]=high[ArrayMaximum(high,bar+iii+1,iPeriod)];
          }
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
