// MQL4&5-Code

//     double- "": CP(Price1) == Price2, CP(Price1) >= Price2  ..
//    double-: CP(Lots1, 0.01) == Lots2, CP(Lots1, 0.1) >= Lots2  ..

#define EPSILON (1.0e-7 + 1.0e-13)
#define HALF_PLUS  (0.5 + EPSILON)
#define HALF_MINUS (0.5 - EPSILON)

#define DEFINE_COMPARE_OPERATOR(OPERATOR)                                      \
  bool operator OPERATOR( const double dPrice ) const                          \
  {                                                                            \
    const double Tmp = (PRICE_COMPARE::Price - dPrice) / PRICE_COMPARE::point; \
                                                                               \
    return((int)((Tmp > 0) ? Tmp + HALF_MINUS : Tmp - HALF_PLUS) OPERATOR 0);  \
  }

class PRICE_COMPARE
{
private:
  static double Price;
  static double point;

public:
  static const PRICE_COMPARE* Compare( const double dPrice, const double dPoint = 0 )
  {
    PRICE_COMPARE::point = (dPoint == 0) ? ::Point() : dPoint;
    PRICE_COMPARE::Price = dPrice;

    // https://www.mql5.com/ru/forum/1111/page1671#comment_2759248
    return(#ifdef __MQL5__ &TempPriceCompare #else #ifdef _DEBUG &TempPriceCompare #else NULL #endif #endif);
  }

  DEFINE_COMPARE_OPERATOR(==)
  DEFINE_COMPARE_OPERATOR(!=)
  DEFINE_COMPARE_OPERATOR(>=)
  DEFINE_COMPARE_OPERATOR(<=)
  DEFINE_COMPARE_OPERATOR(>)
  DEFINE_COMPARE_OPERATOR(<)

  static double MyNormalizeDouble( const double Value, const int digits )
  {
    //  static     !
    static const double Points[] = {1.0e-0, 1.0e-1, 1.0e-2, 1.0e-3, 1.0e-4, 1.0e-5, 1.0e-6, 1.0e-7, 1.0e-8};

    return((int)((Value > 0) ? Value / Points[digits] + HALF_PLUS : Value / Points[digits] - HALF_PLUS) * Points[digits]);
  }
};

static double PRICE_COMPARE::Price = 0;
static double PRICE_COMPARE::point = 0;

#undef DEFINE_COMPARE_OPERATOR
#undef HALF_MINUS
#undef HALF_PLUS
#undef EPSILON

// Compare Prices
const PRICE_COMPARE* CP( const double dPrice, const double dPoint = 0 )
{
  return(PRICE_COMPARE::Compare(dPrice, dPoint));
}

// https://www.mql5.com/ru/forum/1111/page1671#comment_2759248
#ifdef __MQL5__
  static const PRICE_COMPARE TempPriceCompare;
#else
  #ifdef _DEBUG
    static const PRICE_COMPARE TempPriceCompare;
  #endif
#endif

//         (build 1395)
// #define NormalizeDouble PRICE_COMPARE::MyNormalizeDouble