//+---------------------------------------------------------------------+
//|                                                 XFatlXSatlCloud.mq5 |
//|                                  Copyright  2016, Nikolay Kositsin | 
//|                                 Khabarovsk,   farria@mail.redcom.ru | 
//+---------------------------------------------------------------------+ 
//|          SmoothAlgorithms.mqh |
//|   (): __\\MQL5\Include        |
//+---------------------------------------------------------------------+
//----  
#property copyright "Copyright  2016, Nikolay Kositsin"
//----    
#property link "farria@mail.redcom.ru" 
#property description "?       Fatl  Satl"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window
//----        
#property indicator_buffers 4
//----    
#property indicator_plots   3
//+----------------------------------------------+
//|     1            |
//+----------------------------------------------+
//----      
#property indicator_type1   DRAW_FILLING
//----     
#property indicator_color1  clrPaleGreen,clrHotPink
//----   
#property indicator_label1  "XFatlXSatlCloud Signal"
//+----------------------------------------------+
//|     2            |
//+----------------------------------------------+
//----     
#property indicator_type2 DRAW_LINE
//----     
#property indicator_color2 clrBlue
//----   - 
#property indicator_style2 STYLE_SOLID
//----     2
#property indicator_width2 2
//----   
#property indicator_label2  "XFatl"
//+----------------------------------------------+
//|     3            |
//+----------------------------------------------+
//----     
#property indicator_type3 DRAW_LINE
//----     
#property indicator_color3 clrRed
//----   - 
#property indicator_style3 STYLE_SOLID
//----     2
#property indicator_width3 2
//----   
#property indicator_label3  "XSatl"
//+----------------------------------------------+
//|    CXMA                        |
//+----------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//+----------------------------------------------+
//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA1,XMA2;
//----    CFSATL   JJMASeries_Cls.mqh
CFATL FTL; 
//----    CSATL   JJMASeries_Cls.mqh
CSATL STL; 
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
/*enum Smooth_Method -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //PRICE_CLOSE
   PRICE_OPEN_,          //PRICE_OPEN
   PRICE_HIGH_,          //PRICE_HIGH
   PRICE_LOW_,           //PRICE_LOW
   PRICE_MEDIAN_,        //PRICE_MEDIAN
   PRICE_TYPICAL_,       //PRICE_TYPICAL
   PRICE_WEIGHTED_,      //PRICE_WEIGHTED
   PRICE_SIMPL_,         //PRICE_SIMPL_
   PRICE_QUARTER_,       //PRICE_QUARTER_
   PRICE_TRENDFOLLOW0_,  //PRICE_TRENDFOLLOW0_
   PRICE_TRENDFOLLOW1_,  // TrendFollow_2 Price 
   PRICE_DEMARK_         // Demark Price 
  };
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input Smooth_Method XMA_Method1=MODE_JJMA; //  Fatl
input uint XLength1=3; //  Fatl
input int XPhase1=15;    //  Fatl,
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA                         
input Smooth_Method XMA_Method2=MODE_JJMA; //  Satl
input uint XLength2=5; //  Satl
input int XPhase2=15;    //  Satl,
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
input Applied_price_ IPC=PRICE_CLOSE_;   // 
//+----------------------------------------------+

//----   ,    
//      
double IndBuffer[],ColorIndBuffer[];
double UpBuffer[],DnBuffer[];
double UpIndBuffer[],DnIndBuffer[];
//----      
int min_rates_total,min_rates_1,min_rates_2,min_rates_3,min_rates_4;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
void OnInit()
  {
//----     
   min_rates_1=39;
   min_rates_2=min_rates_1+GetStartBars(XMA_Method1,XLength1,XPhase1);
   min_rates_3=65;
   min_rates_4=min_rates_3+GetStartBars(XMA_Method2,XLength2,XPhase2);  
   min_rates_total=MathMax(min_rates_2,min_rates_4);

//----      
   SetIndexBuffer(0,UpBuffer,INDICATOR_DATA);   
//----      
   SetIndexBuffer(1,DnBuffer,INDICATOR_DATA);
   
//----      
   SetIndexBuffer(2,UpIndBuffer,INDICATOR_DATA);
   
//----      
   SetIndexBuffer(3,DnIndBuffer,INDICATOR_DATA);
       
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);   

//----      
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);
   
//----      
   PlotIndexSetInteger(2,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(2,PLOT_EMPTY_VALUE,0.0);

//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"XFatlXSatlCloud");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<min_rates_total) return(0);

//----    
   double price,fatl,xfatl,satl,xsatl;
   int first,bar;

//----    first    
   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=min_rates_1; //      
     }
   else first=prev_calculated-1; //      

//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      price=PriceSeries(IPC,bar,open,low,high,close);
      fatl=FTL.FATLSeries(0,prev_calculated,rates_total,price,bar,false);
      xfatl=XMA1.XMASeries(min_rates_1,prev_calculated,rates_total,XMA_Method1,XPhase1,XLength1,fatl,bar,false);      
      satl=STL.SATLSeries(0,prev_calculated,rates_total,price,bar,false);
      xsatl=XMA2.XMASeries(min_rates_2,prev_calculated,rates_total,XMA_Method2,XPhase2,XLength2,satl,bar,false);
      UpIndBuffer[bar]=UpBuffer[bar]=xfatl;
      DnIndBuffer[bar]=DnBuffer[bar]=xsatl;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
