//+----------------------------------------------------------------------+ 
//|                                   BackgroundCandle_PPO_Cloud_HTF.mq5 | 
//|                                   Copyright  2016, Nikolay Kositsin | 
//|                                  Khabarovsk,   farria@mail.redcom.ru | 
//+----------------------------------------------------------------------+
//|     PPO_Cloud.mq5              |
//|  : __\\MQL5\Indicators   |
//+----------------------------------------------------------------------+
#property copyright "Copyright  2016, Nikolay Kositsin"
#property link "farria@mail.redcom.ru"
//---   
#property version   "1.61"
#property description "     PPO_Cloud       "
//---     
#property indicator_chart_window
//---    12
#property indicator_buffers 12 
//---    
#property indicator_plots   6
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0                                               //        
#define INDICATOR_NAME "BackgroundCandle_PPO_Cloud"           //    
#define SIZE  1                                               //      CountIndicator  
#define EMPTYVALUE 0                                          //     
//+----------------------------------------------+
//|    1             |
//+----------------------------------------------+
//---      
#property indicator_type1   DRAW_FILLING
//---     
#property indicator_color1  clrPaleGreen,clrPlum
//---   -  
#property indicator_style1  STYLE_SOLID
//---   
#property indicator_label1  "Upper Shade"
//+----------------------------------------------+
//|    2             |
//+----------------------------------------------+
//---      
#property indicator_type2   DRAW_FILLING
//---     
#property indicator_color2  clrLimeGreen,clrMediumOrchid
//---   -  
#property indicator_style2  STYLE_SOLID
//---   
#property indicator_label2  "Body"
//+----------------------------------------------+
//|    3             |
//+----------------------------------------------+
//---      
#property indicator_type3   DRAW_FILLING
//---     
#property indicator_color3  clrPaleGreen,clrPlum
//---   -  
#property indicator_style3  STYLE_SOLID
//---   
#property indicator_label3  "Lower Shade"
//+----------------------------------------------+
//|    4             |
//+----------------------------------------------+
//---      
#property indicator_type4   DRAW_FILLING
//---     
#property indicator_color4  clrPaleGreen,clrPlum
//---   -  
#property indicator_style4  STYLE_SOLID
//---   
#property indicator_label4  "Upper Shade"
//+----------------------------------------------+
//|    5             |
//+----------------------------------------------+
//---      
#property indicator_type5   DRAW_FILLING
//---     
#property indicator_color5  clrLimeGreen,clrMediumOrchid
//---   -  
#property indicator_style5  STYLE_SOLID
//---   
#property indicator_label5  "Body"
//+----------------------------------------------+
//|    6             |
//+----------------------------------------------+
//---      
#property indicator_type6   DRAW_FILLING
//---     
#property indicator_color6  clrPaleGreen,clrPlum
//---   -  
#property indicator_style6  STYLE_SOLID
//---   
#property indicator_label6  "Lower Shade"
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Smooth_Method
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  };
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price
   PRICE_DEMARK_         //Demark Price
  };
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input ENUM_TIMEFRAMES TimeFrame=PERIOD_H4;   //   
input Smooth_Method FastMethod=MODE_EMA_; //  
input uint FastLength=12; //            
input int FastPhase=15; //  ,
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
input Smooth_Method SlowMethod=MODE_EMA_; //  
input uint SlowLength=26; //                   
input int SlowPhase=15; //  ,
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
input Smooth_Method SignMethod=MODE_EMA_; // 
input uint SignLength=9; //                     
input int SignPhase=15; // ,
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA    
input Applied_price_ IPC=PRICE_CLOSE_;// 
input int Shift=0; //       
//+----------------------------------------------+
//---   ,   
//---      
double ExtA1Buffer[];
double ExtB1Buffer[];
double ExtA2Buffer[];
double ExtB2Buffer[];
double ExtA3Buffer[];
double ExtB3Buffer[];
double ExtA4Buffer[];
double ExtB4Buffer[];
double ExtA5Buffer[];
double ExtB5Buffer[];
double ExtA6Buffer[];
double ExtB6Buffer[];
//---      
int min_rates_total;
//---      
int Ind_Handle;
//+------------------------------------------------------------------+
//|                                    |
//+------------------------------------------------------------------+
string GetStringTimeframe(ENUM_TIMEFRAMES timeframe)
  {return(StringSubstr(EnumToString(timeframe),7,-1));}
//+------------------------------------------------------------------+    
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+  
int OnInit()
  {
//---     
   if(!TimeFramesCheck(INDICATOR_NAME,TimeFrame)) return(INIT_FAILED);
//---   
   min_rates_total=2;
//---    PPO_Cloud
   Ind_Handle=iCustom(Symbol(),TimeFrame,"PPO_Cloud",FastMethod,FastLength,FastPhase,SlowMethod,SlowLength,SlowPhase,SignMethod,SignLength,SignPhase,IPC,0);
   if(Ind_Handle==INVALID_HANDLE)
     {
      Print("      PPO_Cloud");
      return(INIT_FAILED);
     }
//---      
   ArrayInit(0,ExtA1Buffer);
   ArrayInit(1,ExtB1Buffer);
   ArrayInit(2,ExtA2Buffer);
   ArrayInit(3,ExtB2Buffer);
   ArrayInit(4,ExtA3Buffer);
   ArrayInit(5,ExtB3Buffer);
   ArrayInit(6,ExtA4Buffer);
   ArrayInit(7,ExtB4Buffer);
   ArrayInit(8,ExtA5Buffer);
   ArrayInit(9,ExtB5Buffer);
   ArrayInit(10,ExtA6Buffer);
   ArrayInit(11,ExtB6Buffer);
//---  
   PlotInit(0,2,Shift);
   PlotInit(1,2,Shift);
   PlotInit(2,2,Shift);
   PlotInit(3,2,Shift);
   PlotInit(4,2,Shift);
   PlotInit(5,2,Shift);
//---           
   string shortname;
   StringConcatenate(shortname,INDICATOR_NAME,"(",GetStringTimeframe(TimeFrame),")");
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//---  
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+  
//| Custom iteration function                                        | 
//+------------------------------------------------------------------+  
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---       
   if(rates_total<min_rates_total) return(RESET);
   if(BarsCalculated(Ind_Handle)<Bars(Symbol(),TimeFrame)) return(prev_calculated);
//---         
   ArraySetAsSeries(time,true);
//---
   if(!CountIndicator(0,Symbol(),TimeFrame,Ind_Handle,
      ExtA1Buffer,ExtB1Buffer,ExtA2Buffer,ExtB2Buffer,
      ExtA3Buffer,ExtB3Buffer,ExtA4Buffer,ExtB4Buffer,
      ExtA5Buffer,ExtB5Buffer,ExtA6Buffer,ExtB6Buffer,
      time,rates_total,prev_calculated,min_rates_total)) return(RESET);
//---     
   return(rates_total);
  }
//+------------------------------------------------------------------+
//| CountIndicator                                                   |
//+------------------------------------------------------------------+
bool CountIndicator(uint     Numb,             //   CountLine      (  - 0)
                    string   Symb,             //  
                    ENUM_TIMEFRAMES TFrame,    //  
                    int      IndHandle,        //   
                    double&  ExtA1Buff[],      //    1
                    double&  ExtB1Buff[],      //    2
                    double&  ExtA2Buff[],      //    3
                    double&  ExtB2Buff[],      //    4
                    double&  ExtA3Buff[],      //    5
                    double&  ExtB3Buff[],      //    6
                    double&  ExtA4Buff[],      //    7
                    double&  ExtB4Buff[],      //    8
                    double&  ExtA5Buff[],      //    9
                    double&  ExtB5Buff[],      //    10
                    double&  ExtA6Buff[],      //    11
                    double&  ExtB6Buff[],      //    12
                    const datetime &Time[],    //  
                    const int Rates_Total,     //       
                    const int Prev_Calculated, //       
                    const int Min_Rates_Total) //       
  {
//---
   static int Sign,Trend;
   static datetime LastTime;
   static int LastCountBar[SIZE];
   double iOpen[1],iLow[1],iHigh[1],iClose[1],iUp[1],iDn[1];
   datetime iTime[1];
   int limit;
//---   limit    
   if(Prev_Calculated>Rates_Total || Prev_Calculated<=0)//      
     {
      limit=Rates_Total-Min_Rates_Total-1; //      
      LastCountBar[Numb]=limit;
      LastTime=0;
      Sign=1;
     }
   else limit=LastCountBar[Numb]+Rates_Total-Prev_Calculated; //       

//---    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      //---       IndTime
      if(CopyTime(Symbol(),TFrame,Time[bar],1,iTime)<=0) return(RESET);

      if(Time[bar]>=iTime[0] && Time[bar+1]<iTime[0])
        {
         LastCountBar[Numb]=bar;
         if(iTime[0]!=LastTime)
           {
            LastTime=iTime[0];
            Sign*=(-1);
           }
         //---      
         if(CopyBuffer(IndHandle,0,Time[bar],1,iUp)<=0) return(RESET);
         if(CopyBuffer(IndHandle,1,Time[bar],1,iDn)<=0) return(RESET);
         if(CopyOpen(Symbol(),TFrame,Time[bar],1,iOpen)<=0) return(RESET);
         if(CopyLow(Symbol(),TFrame,Time[bar],1,iLow)<=0) return(RESET);
         if(CopyHigh(Symbol(),TFrame,Time[bar],1,iHigh)<=0) return(RESET);
         if(CopyClose(Symbol(),TFrame,Time[bar],1,iClose)<=0) return(RESET);
         //--- 
         double mathmax=MathMax(iOpen[0],iClose[0]);
         double mathmin=MathMin(iOpen[0],iClose[0]);
         //--- 
         if(Sign>0)
           {
            if(iUp[0]>iDn[0])
              {
               ExtA1Buff[bar]=iHigh[0];
               ExtB1Buff[bar]=mathmax;
               ExtA2Buff[bar]=mathmax;
               ExtB2Buff[bar]=mathmin;
               ExtA3Buff[bar]=mathmin;
               ExtB3Buff[bar]=iLow[0];
               Trend=+1;
              }

            if(iUp[0]<iDn[0])
              {
               ExtB1Buff[bar]=iHigh[0];
               ExtA1Buff[bar]=mathmax;
               ExtB2Buff[bar]=mathmax;
               ExtA2Buff[bar]=mathmin;
               ExtB3Buff[bar]=mathmin;
               ExtA3Buff[bar]=iLow[0];
               Trend=-1;
              }

            if(iUp[0]==iDn[0])
              {
               if(Trend>0)
                 {
                  ExtA1Buff[bar]=iHigh[0];
                  ExtB1Buff[bar]=mathmax;
                  ExtA2Buff[bar]=mathmax;
                  ExtB2Buff[bar]=mathmin;
                  ExtA3Buff[bar]=mathmin;
                  ExtB3Buff[bar]=iLow[0];
                 }

               if(Trend<0)
                 {
                  ExtB1Buff[bar]=iHigh[0];
                  ExtA1Buff[bar]=mathmax;
                  ExtB2Buff[bar]=mathmax;
                  ExtA2Buff[bar]=mathmin;
                  ExtB3Buff[bar]=mathmin;
                  ExtA3Buff[bar]=iLow[0];
                 }

              }

            ExtA4Buff[bar]=EMPTYVALUE;
            ExtB4Buff[bar]=EMPTYVALUE;
            ExtA5Buff[bar]=EMPTYVALUE;
            ExtB5Buff[bar]=EMPTYVALUE;
            ExtA6Buff[bar]=EMPTYVALUE;
            ExtB6Buff[bar]=EMPTYVALUE;
           }
         else
           {
            if(iUp[0]>iDn[0])
              {
               ExtA4Buff[bar]=iHigh[0];
               ExtB4Buff[bar]=mathmax;
               ExtA5Buff[bar]=mathmax;
               ExtB5Buff[bar]=mathmin;
               ExtA6Buff[bar]=mathmin;
               ExtB6Buff[bar]=iLow[0];
               Trend=+1;
              }

            if(iUp[0]<iDn[0])
              {
               ExtB4Buff[bar]=iHigh[0];
               ExtA4Buff[bar]=mathmax;
               ExtB5Buff[bar]=mathmax;
               ExtA5Buff[bar]=mathmin;
               ExtB6Buff[bar]=mathmin;
               ExtA6Buff[bar]=iLow[0];
               Trend=-1;
              }

            if(iUp[0]==iDn[0])
              {
               if(Trend>0)
                 {
                  ExtA4Buff[bar]=iHigh[0];
                  ExtB4Buff[bar]=mathmax;
                  ExtA5Buff[bar]=mathmax;
                  ExtB5Buff[bar]=mathmin;
                  ExtA6Buff[bar]=mathmin;
                  ExtB6Buff[bar]=iLow[0];
                 }

               if(Trend<0)
                 {
                  ExtB4Buff[bar]=iHigh[0];
                  ExtA4Buff[bar]=mathmax;
                  ExtB5Buff[bar]=mathmax;
                  ExtA5Buff[bar]=mathmin;
                  ExtB6Buff[bar]=mathmin;
                  ExtA6Buff[bar]=iLow[0];
                 }
              }

            ExtA1Buff[bar]=EMPTYVALUE;
            ExtB1Buff[bar]=EMPTYVALUE;
            ExtA2Buff[bar]=EMPTYVALUE;
            ExtB2Buff[bar]=EMPTYVALUE;
            ExtA3Buff[bar]=EMPTYVALUE;
            ExtB3Buff[bar]=EMPTYVALUE;
           }
        }
      else
        {
         int bar1=bar+1;
         ExtA1Buff[bar]=ExtA1Buff[bar1];
         ExtB1Buff[bar]=ExtB1Buff[bar1];
         ExtA2Buff[bar]=ExtA2Buff[bar1];
         ExtB2Buff[bar]=ExtB2Buff[bar1];
         ExtA3Buff[bar]=ExtA3Buff[bar1];
         ExtB3Buff[bar]=ExtB3Buff[bar1];
         ExtA4Buff[bar]=ExtA4Buff[bar1];
         ExtB4Buff[bar]=ExtB4Buff[bar1];
         ExtA5Buff[bar]=ExtA5Buff[bar1];
         ExtB5Buff[bar]=ExtB5Buff[bar1];
         ExtA6Buff[bar]=ExtA6Buff[bar1];
         ExtB6Buff[bar]=ExtB6Buff[bar1];
        }
     }
//---     
   return(true);
  }
//+------------------------------------------------------------------+
//| PlotInit()                                                       |
//+------------------------------------------------------------------+    
void PlotInit(uint PlotNumber,
              int DrawBegin,
              int PlotShift)
  {
//---      
   PlotIndexSetInteger(PlotNumber,PLOT_DRAW_BEGIN,DrawBegin);
//---    1    Shift
   PlotIndexSetInteger(PlotNumber,PLOT_SHIFT,PlotShift);
//---
  }
//+------------------------------------------------------------------+
//| ArrayInit()                                                      |
//+------------------------------------------------------------------+    
void ArrayInit(uint ArrNumber,
               double &Array[])
  {
//---      
   SetIndexBuffer(ArrNumber,Array,INDICATOR_DATA);
//---       
   ArraySetAsSeries(Array,true);
//---
  }
//+------------------------------------------------------------------+
//| TimeFramesCheck()                                                |
//+------------------------------------------------------------------+    
bool TimeFramesCheck(string IndName,
                     ENUM_TIMEFRAMES TFrame) //  
  {
//---     
   if(TFrame<Period() && TFrame!=PERIOD_CURRENT)
     {
      Print("    "+IndName+"       !");
      Print("    !");
      return(RESET);
     }
//---
   return(true);
  }
//+------------------------------------------------------------------+

   