//+------------------------------------------------------------------+
//|                                                       Harami.mq5 |
//|                                  Copyright  2009, Paul Stringer |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property description "Harami"
//----  
#property copyright "Copyright  2009, Paul Stringer"
//----    
#property link      "http://www.metaquotes.net"
//----   
#property version   "1.00"
//----     
#property indicator_chart_window 
//----        
#property indicator_buffers 2
//----     
#property indicator_plots   2
//+----------------------------------------------+
//|          |
//+----------------------------------------------+
//----   1   
#property indicator_type1   DRAW_ARROW
//----       
#property indicator_color1  clrMagenta
//----    1  1
#property indicator_width1  1
//----    
#property indicator_label1  "Up Harami"
//+----------------------------------------------+
//|           |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_ARROW
//----       
#property indicator_color2  clrBlue
//----    2  1
#property indicator_width2  1
//----    
#property indicator_label2 "Down Harami"

//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint MinMasterSize = 40;
input uint MaxMasterSize = 500;
input uint MinHaramiSize = 20;
input uint MaxHaramiSize = 300;
input double   MaxRatioHaramiToMaster = 0.75;
input double   MinRatioHaramiToMaster = 0.5;
input uint ArrowOffSet=35;
input int  UpLable=218;//  
input int  DnLable=217;//  
//+----------------------------------------------+

//----   ,    
//      
double SellBuffer[];
double BuyBuffer[];
//----      
int  min_rates_total;
double dMinMasterSize,dMaxMasterSize,dMinHaramiSize,dMaxHaramiSize,dArrowOffSet;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
void OnInit()
  {
//----    
   min_rates_total=6;
   dMinMasterSize=MinMasterSize*_Point;
   dMaxMasterSize=MaxMasterSize*_Point;
   dMinHaramiSize=MinHaramiSize*_Point;
   dMaxHaramiSize=MaxHaramiSize*_Point;
   dArrowOffSet=ArrowOffSet*_Point;

//----      
   SetIndexBuffer(0,SellBuffer,INDICATOR_DATA);
//----       1
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   
   PlotIndexSetInteger(0,PLOT_ARROW,UpLable);
//----       
   ArraySetAsSeries(SellBuffer,true);
//----      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,0.0);

//----      
   SetIndexBuffer(1,BuyBuffer,INDICATOR_DATA);
//----       2
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----   
   PlotIndexSetInteger(1,PLOT_ARROW,DnLable);
//----       
   ArraySetAsSeries(BuyBuffer,true);
//----      
   PlotIndexSetDouble(1,PLOT_EMPTY_VALUE,0.0);

//----     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----         
   string short_name="Harami";
   IndicatorSetString(INDICATOR_SHORTNAME,short_name);
//----   
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(0);

//----    
   int limit;

//----      
//  limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
     }
   else
     {
      limit=rates_total-prev_calculated; //      
     }

//----         
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(open,true);
   ArraySetAsSeries(close,true);

//----    
   for(int bar=limit; bar>=1 && !IsStopped(); bar--)
     {
      BuyBuffer[bar-1]=SellBuffer[bar-1]=NULL;
      double _MasterBarSize=MathAbs(open[bar+1]-close[bar+1]);
      double _HaramiBarSize=MathAbs(open[bar]-close[bar]);
      double MaxM=_MasterBarSize-dMaxMasterSize;
      double MinM=_MasterBarSize-dMinMasterSize;
      double MaxH=_HaramiBarSize-dMaxHaramiSize;
      double MinH=_HaramiBarSize-dMinHaramiSize;
      if(!_MasterBarSize) _MasterBarSize=_Point;
      double res=_HaramiBarSize/_MasterBarSize;

      if(MaxM && MinM && MaxH && MinH && res<=MaxRatioHaramiToMaster && res>=MinRatioHaramiToMaster)
        {
         // Is it reversal in favour of a BEAR reversal...
         if(
            (open[bar+1]>close[bar+1]) && 
            (open[bar]<close[bar]) && 
            (close[bar+1]<open[bar]) && 
            (open[bar+1]>close[bar])
            )
           {
            // Reversal favouring a bull coming...
            BuyBuffer[bar-1]=low[bar-1]-dArrowOffSet;
           }

         // Is it reversal in favour of a BULL reversal...
         if(
            (open[bar+1]<close[bar+1]) && 
            (open[bar]>close[bar]) && 
            (close[bar+1]>open[bar]) && 
            (open[bar+1]<close[bar])
            )
           {
            // Reversal favouring a bull coming...
            SellBuffer[bar-1]=high[bar-1]+dArrowOffSet;
           }
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
