//+------------------------------------------------------------------+ 
//|                                                        M2_MA.mq5 | 
//|                                Copyright  2011, Dodonov Vitalii |
//|                                                  ellizii@mail.ru | 
//+------------------------------------------------------------------+ 
#property copyright "Copyright  2010, Dodonov Vitaliin"
#property link "ellizii@mail.ru" 
//----   
#property version   "1.01"
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 1 
//----     
#property indicator_plots   1
//+-----------------------------------+
//|       |
//+-----------------------------------+
//----     
#property indicator_type1   DRAW_LINE
//----       clrMediumSlateBlue 
#property indicator_color1 clrMediumSlateBlue
//----   -  
#property indicator_style1  STYLE_SOLID
//----     2
#property indicator_width1 2
//----   
#property indicator_label1  "M2_MA"
//+-----------------------------------+
//|    CXMA             |
//+-----------------------------------+
#include <SmoothAlgorithms.mqh> 
//----    CXMA  CMoving_Average   SmoothAlgorithms.mqh
CXMA XMA1;
CMoving_Average EMA,LWMA1,LWMA2;
//+-----------------------------------+
//|             |
//+-----------------------------------+
/*enum SmoothMethod -     SmoothAlgorithms.mqh
  {
   MODE_SMA_,  //SMA
   MODE_EMA_,  //EMA
   MODE_SMMA_, //SMMA
   MODE_LWMA_, //LWMA
   MODE_JJMA,  //JJMA
   MODE_JurX,  //JurX
   MODE_ParMA, //ParMA
   MODE_T3,    //T3
   MODE_VIDYA, //VIDYA
   MODE_AMA,   //AMA
  }; */
//+-----------------------------------+
//|             |
//+-----------------------------------+
enum Applied_price_ // 
  {
   PRICE_CLOSE_ = 1,     //Close
   PRICE_OPEN_,          //Open
   PRICE_HIGH_,          //High
   PRICE_LOW_,           //Low
   PRICE_MEDIAN_,        //Median Price (HL/2)
   PRICE_TYPICAL_,       //Typical Price (HLC/3)
   PRICE_WEIGHTED_,      //Weighted Close (HLCC/4)
   PRICE_SIMPL_,         //Simpl Price (OC/2)
   PRICE_QUARTER_,       //Quarted Price (HLOC/4) 
   PRICE_TRENDFOLLOW0_,  //TrendFollow_1 Price 
   PRICE_TRENDFOLLOW1_,  //TrendFollow_2 Price 
   PRICE_DEMARK_         //Demark Price
  };
//+-----------------------------------+
//|         |
//+-----------------------------------+
input Smooth_Method XMA_Method=MODE_SMA_; //  
input uint MPeriod=6;                     //   
input int XPhase=15;                      //  ,
//----  JJMA    -100 ... +100,     ;
//----  VIDIA   CMO,  AMA                      
input Applied_price_ IPC=PRICE_CLOSE_;    //  
input int Shift=0;                        //      
input int PriceShift=0;                   // c     
//+-----------------------------------+
//----  
double IndBuffer[];
double dPriceShift;
//----   
int min_rates_total,min_rates_;
int period1,period2,period3;
//+------------------------------------------------------------------+
//   CMoving_Average                                   |
//+------------------------------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//+------------------------------------------------------------------+    
//| M2_MA indicator initialization function                          | 
//+------------------------------------------------------------------+  
void OnInit()
  {
//----     
   int periodf=int(MPeriod);
   int tme=periodf+5;
   int ry=periodf+3;
   period1=tme/periodf;
   period2=ry/periodf;
   period3=tme/periodf;
   min_rates_=int(MathMin(MathMin(period1,period2),period3));
   min_rates_total=min_rates_+GetStartBars(XMA_Method,int(MPeriod),XPhase);     
//----      
   SetIndexBuffer(0,IndBuffer,INDICATOR_DATA);
//----       Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,"M2_MA");
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);
//----    
   dPriceShift=_Point*PriceShift;
//----  
  }
//+------------------------------------------------------------------+  
//| M2_MA iteration function                                         | 
//+------------------------------------------------------------------+  
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(rates_total<min_rates_total) return(0);

//----   
   int first,bar;
   double series,ema,lwma1,lwma2,ma,xma;

   if(prev_calculated>rates_total || prev_calculated<=0) //      
     {
      first=0; //      
     }
   else first=prev_calculated; //      

//----    
   for(bar=first; bar<rates_total && !IsStopped(); bar++)
     {
      series=PriceSeries(IPC,bar,open,low,high,close);
      ema=EMA.EMASeries(0,prev_calculated,rates_total,period2,series,bar,false); 
      lwma1=LWMA1.LWMASeries(0,prev_calculated,rates_total,period1,series,bar,false);
      lwma2=LWMA2.LWMASeries(0,prev_calculated,rates_total,period3,series,bar,false);      
      ma=(2*ema+(((lwma2+ema)/2)-lwma1))/2;  
      xma=XMA1.XMASeries(min_rates_,prev_calculated,rates_total,XMA_Method,XPhase,MPeriod,ma,bar,false);         
      IndBuffer[bar]=xma+dPriceShift;
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
