//+------------------------------------------------------------------+
//|                                      AsymmetricStochNR_Cloud.mq5 | 
//|                                    Copyright  2010,   Svinozavr | 
//+------------------------------------------------------------------+
//|     SmoothAlgorithms.mqh                  |
//|    : __\MQL5\Include  |
//+------------------------------------------------------------------+
#property copyright "Copyright  2010,   Svinozavr"
#property link ""
#property description "Asymmetric Stoch NR"
//----   
#property version   "1.01"
//----     
#property indicator_separate_window
//----    2
#property indicator_buffers 2 
//----     
#property indicator_plots   1
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET 0 //        
//+----------------------------------------------+
//|                  |
//+----------------------------------------------+
//----     
#property indicator_type1   DRAW_FILLING
//----    
#property indicator_color1  clrDeepSkyBlue,clrPlum
//----   
#property indicator_label1  "Asymmetric Stochastic NR"
//+----------------------------------------------+
//|    CXMA                        |
//+----------------------------------------------+
#include <SmoothAlgorithms.mqh> 
//+----------------------------------------------+
//----    CXMA   SmoothAlgorithms.mqh
CXMA XMA;
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
/*enum Smooth_Method -    SmoothAlgorithms.mqh
  {
   MODE_SMA_,  // SMA
   MODE_EMA_,  // EMA
   MODE_SMMA_, // SMMA
   MODE_LWMA_, // LWMA
   MODE_JJMA,  // JJMA
   MODE_JurX,  // JurX
   MODE_ParMA, // ParMA
   MODE_T3,    // T3
   MODE_VIDYA, // VIDYA
   MODE_AMA,   // AMA
  }; */
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+  
enum WIDTH
  {
   Width_1=1, // 1
   Width_2,   // 2
   Width_3,   // 3
   Width_4,   // 4
   Width_5    // 5
  };
//+----------------------------------------------+
//|                        |
//+----------------------------------------------+
enum STYLE
  {
   SOLID_,       //  
   DASH_,        //  
   DOT_,         //  
   DASHDOT_,     // - 
   DASHDOTDOT_   // -    
  };
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input uint KperiodShort=5;                   //  %K
input uint KperiodLong=12;                   //  %K
input Smooth_Method DMethod=MODE_SMA_;       //     
input uint Dperiod=7;                        //    %D
input int DPhase=15;                         //    
input uint Slowing=3;                        // 
input ENUM_STO_PRICE PriceField=STO_LOWHIGH; //     
input uint Sens=7;                           //   
input uint OverBought=80;                    //    %%
input uint OverSold=20;                      //    %%
input color UpLevelsColor=clrBlue;           //   
input color DnLevelsColor=clrMagenta;        //   
input STYLE Levelstyle=DASH_;                //  
input WIDTH  LevelsWidth=Width_1;            //  
input int Shift=0;                           //      
//+----------------------------------------------+
//----   ,   
//----      
double Stoch[],XStoch[];
double sens; //   
//----      
int min_rates_total,min_rates_stoch;
//+------------------------------------------------------------------+   
//| Asymmetric Stoch NR indicator initialization function            | 
//+------------------------------------------------------------------+ 
void OnInit()
  {
//----     
   min_rates_stoch=int(MathMax(KperiodShort,KperiodLong)+Slowing);
   min_rates_total=min_rates_stoch+XMA.GetStartBars(DMethod,Dperiod,DPhase);

//----     
   sens=Sens*_Point; //   

//----     
   IndicatorSetInteger(INDICATOR_LEVELS,2);

   IndicatorSetDouble(INDICATOR_LEVELVALUE,0,OverSold);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,0,DnLevelsColor);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,0,Levelstyle);
   IndicatorSetInteger(INDICATOR_LEVELWIDTH,0,LevelsWidth);

   IndicatorSetDouble(INDICATOR_LEVELVALUE,1,OverBought);
   IndicatorSetInteger(INDICATOR_LEVELCOLOR,1,UpLevelsColor);
   IndicatorSetInteger(INDICATOR_LEVELSTYLE,1,Levelstyle);
   IndicatorSetInteger(INDICATOR_LEVELWIDTH,1,LevelsWidth);

//----       
   XMA.XMALengthCheck("Dperiod",Dperiod);
   XMA.XMALengthCheck("Dperiod",Dperiod);
   XMA.XMAPhaseCheck("DPhase",DPhase,DMethod);

//----    Stoch[]   
   SetIndexBuffer(0,Stoch,INDICATOR_DATA);
//----    1  
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----      
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----   ,      
   PlotIndexSetDouble(0,PLOT_EMPTY_VALUE,EMPTY_VALUE);
//----    ,   
   ArraySetAsSeries(Stoch,true);

//----    XStoch[]   
   SetIndexBuffer(1,XStoch,INDICATOR_DATA);
//----    ,   
   ArraySetAsSeries(XStoch,true);

//----      
   string shortname,Smooth;
   Smooth=XMA.GetString_MA_Method(DMethod);
   StringConcatenate(shortname,"Asymmetric Stochastic NR(",KperiodShort,",",KperiodLong,",",Dperiod,",",Smooth,",",Slowing,")");
//----           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);

//----     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//----  
  }
//+------------------------------------------------------------------+ 
//| Asymmetric Stoch NR iteration function                           | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//----       
   if(rates_total<min_rates_total) return(RESET);

//----   
   int limit,bar,maxbar;

//----    
   static uint Kperiod0,Kperiod1;

//----      
//----   limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-1-min_rates_stoch; //      
      Kperiod0=KperiodShort;
      Kperiod1=KperiodShort;
     }
   else limit=rates_total-prev_calculated; //       

//----    ,     
   ArraySetAsSeries(close,true);
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);

   maxbar=rates_total-1-min_rates_stoch;

//----    
   for(bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      Stoch[bar]=Stoch(Kperiod0,Kperiod1,Slowing,PriceField,sens,bar,low,high,close);
      //----
      XStoch[bar]=XMA.XMASeries(maxbar,prev_calculated,rates_total,DMethod,DPhase,Dperiod,Stoch[bar],bar,true);

      //---  
      if(XStoch[bar+1]>OverBought)
        { //  
         Kperiod0=KperiodShort;
         Kperiod1=KperiodLong;
        }

      if(XStoch[bar+1]<OverSold)
        { //  
         Kperiod0=KperiodLong;
         Kperiod1=KperiodShort;
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|                                  |
//+------------------------------------------------------------------+    
double Stoch(
             int Kperiod0,
             int Kperiod1,
             int Slowing_,
             int PriceField_,
             double sens_,
             int Bar,
             const double &Low[],
             const double &High[],
             const double &Close[])
  {
//----
   double max,min,c,delta,diff;

   c=0.0;
   max=0.0;
   min=0.0;
   int end=Bar+Slowing_;;

   for(int j=Bar; j<end; j++)
     {
      if(PriceField_==STO_CLOSECLOSE)
        {
         max+=Close[ArrayMaximum(Close,j,Kperiod0)];
         min+=Close[ArrayMinimum(Close,j,Kperiod1)];
        }

      if(PriceField_==STO_LOWHIGH)
        {
         max+=High[ArrayMaximum(High,j,Kperiod0)];
         min+=Low[ArrayMinimum(Low,j,Kperiod1)];
        }

      c+=Close[j];
     }

//--- 
   sens_*=Slowing_; //       
   delta=max-min;   // 
   diff=sens-delta; //      

//---   >0 (  )
   if(diff>0)
     {
      delta=sens;   //  = 
      min-=diff/2;  //   
     }
//---  
   if(delta) return(100*(c-min)/delta); // 
//----
   return(-2);
  }
//+------------------------------------------------------------------+
